/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.network.packets;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.client.gui.ChocoboInventoryScreen;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class OpenChocoboGuiMessage {
    public int entityId;
    public int windowId;
    public CompoundTag saddle;
    @Nullable
    public CompoundTag inventory;

    public OpenChocoboGuiMessage(ChocoboEntity chocobo, int windowId) {
        ChocoboSaddleItem saddleItem;
        this.entityId = chocobo.m_142049_();
        this.windowId = windowId;
        this.saddle = chocobo.saddleItemStackHandler.serializeNBT();
        ItemStack saddleStack = chocobo.getSaddle();
        if (!saddleStack.m_41619_() && saddleStack.m_41720_() instanceof ChocoboSaddleItem && (saddleItem = (ChocoboSaddleItem)saddleStack.m_41720_()).getInventorySize() > 0) {
            this.inventory = chocobo.chocoboInventory.serializeNBT();
        }
    }

    public OpenChocoboGuiMessage(int entityID, int windowId, CompoundTag saddle, CompoundTag inventory) {
        this.entityId = entityID;
        this.windowId = windowId;
        this.saddle = saddle;
        this.inventory = inventory;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.windowId);
        buf.m_130079_(this.saddle);
        buf.writeBoolean(this.inventory != null);
        if (this.inventory != null) {
            buf.m_130079_(this.inventory);
        }
    }

    public static OpenChocoboGuiMessage decode(FriendlyByteBuf buffer) {
        return new OpenChocoboGuiMessage(buffer.readInt(), buffer.readInt(), buffer.m_130260_(), buffer.readBoolean() ? buffer.m_130260_() : null);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                Minecraft mc = Minecraft.m_91087_();
                Entity entity = mc.f_91073_.m_6815_(this.entityId);
                if (!(entity instanceof ChocoboEntity)) {
                    Chococraft.log.warn("Server send OpenGUI for chocobo with id {}, but this entity does not exist on my side", (Object)this.entityId);
                    return;
                }
                ChocoboEntity chocobo = (ChocoboEntity)entity;
                ChocoboInventoryScreen.openInventory(this.windowId, chocobo);
                chocobo.saddleItemStackHandler.deserializeNBT(this.saddle);
                if (this.inventory != null) {
                    chocobo.chocoboInventory.deserializeNBT(this.inventory);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

