/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.items;

import net.chococraft.common.ChocoConfig;
import net.chococraft.common.blocks.ChocoboEggBlock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ChocoboEggBlockItem
extends BlockItem {
    public ChocoboEggBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!ChocoboEggBlock.isChocoboEgg(stack)) {
            return super.showDurabilityBar(stack);
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag nbtHatchIngstate = stack.m_41737_("HatchingState");
        return nbtHatchIngstate != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!ChocoboEggBlock.isChocoboEgg(stack)) {
            return super.getDurabilityForDisplay(stack);
        }
        if (!stack.m_41782_()) {
            return 0.0;
        }
        int time = 0;
        CompoundTag nbtHatchIngstate = stack.m_41737_("HatchingState");
        if (nbtHatchIngstate != null) {
            time = nbtHatchIngstate.m_128451_("Time");
        }
        double percent = (double)time / (double)((Integer)ChocoConfig.COMMON.eggHatchTimeTicks.get()).intValue();
        return 1.0 - percent;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (!ChocoboEggBlock.isChocoboEgg(stack)) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return 65280;
    }
}

