/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class SaddleItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected ItemStack itemStack = ItemStack.f_41583_;

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        ItemStack oldStack = this.itemStack;
        this.itemStack = stack;
        if (!oldStack.m_41619_() || !stack.m_41619_()) {
            this.onStackChanged();
        }
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.itemStack.m_41619_()) {
            if (simulate) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
            }
            this.itemStack = stack.m_41620_(1);
        }
        this.onStackChanged();
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.itemStack, (int)amount);
        }
        ItemStack outStack = this.itemStack.m_41620_(amount);
        this.onStackChanged();
        return outStack;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public CompoundTag serializeNBT() {
        return this.itemStack.m_41739_(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemStack = ItemStack.m_41712_((CompoundTag)nbt);
        this.onStackChanged();
    }

    protected abstract void onStackChanged();
}

