/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.inventory;

import java.util.Objects;
import net.chococraft.common.blockentities.ChocoboNestBlockEntity;
import net.chococraft.common.init.ModContainers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;

public class NestContainer
extends AbstractContainerMenu {
    private ChocoboNestBlockEntity tile;

    public NestContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, NestContainer.getTileEntity(playerInventory, data));
    }

    private static ChocoboNestBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (tileAtPos instanceof ChocoboNestBlockEntity) {
            return (ChocoboNestBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public NestContainer(int id, Inventory playerInventoryIn, ChocoboNestBlockEntity chocoboNest) {
        super((MenuType)ModContainers.NEST.get(), id);
        this.tile = chocoboNest;
        this.m_38897_((Slot)new SlotItemHandler(this.tile.getInventory(), 0, 80, 35));
        this.bindPlayerInventory(playerInventoryIn);
    }

    private void bindPlayerInventory(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    public ChocoboNestBlockEntity getTile() {
        return this.tile;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            boolean tileSize = true;
            if (index < 1 ? !this.m_38903_(itemstack1, 1, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            this.tile.onInventoryChanged();
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }
}

