/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.properties;

import java.util.Optional;
import java.util.Random;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;

public enum ChocoboColor {
    YELLOW((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_YELLOW),
    GREEN((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_LIME),
    BLUE((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_BLUE),
    WHITE((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_WHITE),
    BLACK((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_BLACK),
    GOLD((Tags.IOptionalNamedTag<Item>)Tags.Items.INGOTS_GOLD),
    PINK((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_PINK),
    RED((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_RED),
    PURPLE((Tags.IOptionalNamedTag<Item>)Tags.Items.DYES_PURPLE),
    FLAME(null);

    private static Random rand;
    private Tags.IOptionalNamedTag<Item> colorTag;
    private final TranslatableComponent eggText;

    private ChocoboColor(Tags.IOptionalNamedTag<Item> colorIngredient) {
        this.colorTag = colorIngredient;
        this.eggText = new TranslatableComponent("item.chococraft.chocobo_egg.tooltip." + this.name().toLowerCase());
    }

    public static ChocoboColor getRandomColor() {
        return ChocoboColor.values()[rand.nextInt(ChocoboColor.values().length)];
    }

    public static Optional<ChocoboColor> getColorForItemstack(ItemStack stack) {
        for (ChocoboColor color : ChocoboColor.values()) {
            if (color.colorTag == null || !stack.m_150922_(color.colorTag)) continue;
            return Optional.of(color);
        }
        return Optional.empty();
    }

    public TranslatableComponent getEggText() {
        return this.eggText;
    }

    static {
        rand = new Random();
    }
}

