/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.breeding;

import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.entities.properties.ChocoboColor;
import net.chococraft.common.init.ModAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ChocoboStatSnapshot {
    public static final ChocoboStatSnapshot DEFAULT = new ChocoboStatSnapshot();
    public static final String NBTKEY_GENERATION = "Generation";
    public static final String NBTKEY_HEALTH = "Health";
    public static final String NBTKEY_SPEED = "Speed";
    public static final String NBTKEY_STAMINA = "Stamina";
    public static final String NBTKEY_CAN_SPRINT = "CanSprint";
    public static final String NBTKEY_CAN_GLIDE = "CanGlide";
    public static final String NBTKEY_CAN_DIVE = "CanDive";
    public static final String NBTKEY_CAN_FLY = "CanFly";
    public static final String NBTKEY_COLOR = "Color";
    public int generation;
    public float health;
    public float speed;
    public float stamina;
    public boolean canSprint;
    public boolean canGlide;
    public boolean canDive;
    public boolean canFly;
    public ChocoboColor color;

    private ChocoboStatSnapshot() {
    }

    public ChocoboStatSnapshot(ChocoboEntity chocobo) {
        this.generation = chocobo.getGeneration();
        this.health = (float)chocobo.m_21051_(Attributes.f_22276_).m_22115_();
        this.speed = (float)chocobo.m_21051_(Attributes.f_22279_).m_22115_();
        this.stamina = (float)chocobo.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22115_();
        this.canSprint = chocobo.canSprint();
        this.canGlide = chocobo.canGlide();
        this.canDive = chocobo.canDive();
        this.canFly = chocobo.canFly();
        this.color = chocobo.getChocoboColor();
    }

    public ChocoboStatSnapshot(CompoundTag nbt) {
        this.generation = nbt.m_128451_(NBTKEY_GENERATION);
        this.health = nbt.m_128457_(NBTKEY_HEALTH);
        this.speed = nbt.m_128457_(NBTKEY_SPEED);
        this.stamina = nbt.m_128457_(NBTKEY_STAMINA);
        this.canSprint = nbt.m_128471_(NBTKEY_CAN_SPRINT);
        this.canGlide = nbt.m_128471_(NBTKEY_CAN_GLIDE);
        this.canDive = nbt.m_128471_(NBTKEY_CAN_DIVE);
        this.canFly = nbt.m_128471_(NBTKEY_CAN_FLY);
        this.color = ChocoboColor.values()[nbt.m_128445_(NBTKEY_COLOR)];
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBTKEY_GENERATION, this.generation);
        nbt.m_128350_(NBTKEY_HEALTH, this.health);
        nbt.m_128350_(NBTKEY_SPEED, this.speed);
        nbt.m_128350_(NBTKEY_STAMINA, this.stamina);
        nbt.m_128379_(NBTKEY_CAN_FLY, this.canFly);
        nbt.m_128379_(NBTKEY_CAN_GLIDE, this.canGlide);
        nbt.m_128379_(NBTKEY_CAN_SPRINT, this.canSprint);
        nbt.m_128379_(NBTKEY_CAN_DIVE, this.canDive);
        nbt.m_128344_(NBTKEY_COLOR, (byte)this.color.ordinal());
        return nbt;
    }

    static {
        ChocoboStatSnapshot.DEFAULT.generation = 1;
        ChocoboStatSnapshot.DEFAULT.health = ((Integer)ChocoConfig.COMMON.defaultHealth.get()).intValue();
        ChocoboStatSnapshot.DEFAULT.stamina = ((Integer)ChocoConfig.COMMON.defaultStamina.get()).intValue();
        ChocoboStatSnapshot.DEFAULT.speed = (float)((Integer)ChocoConfig.COMMON.defaultSpeed.get()).intValue() / 100.0f;
        ChocoboStatSnapshot.DEFAULT.canSprint = false;
        ChocoboStatSnapshot.DEFAULT.canGlide = false;
        ChocoboStatSnapshot.DEFAULT.canDive = false;
        ChocoboStatSnapshot.DEFAULT.canFly = false;
        ChocoboStatSnapshot.DEFAULT.color = ChocoboColor.YELLOW;
    }
}

