/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import net.chococraft.common.entities.ChocoboEntity;
import net.chococraft.common.init.ModAttributes;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.util.BiConsumer;

public class ChocoboCommand {
    private static final String MODID = "chococraft";
    private static final Map<String, BiConsumer<ChocoboEntity, String>> setMap = new HashMap<String, BiConsumer<ChocoboEntity, String>>();

    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"chocobo");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"list").executes(ChocoboCommand::sendList))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"health").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "health", String.valueOf(FloatArgumentType.getFloat((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resistance").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "resistance", String.valueOf(FloatArgumentType.getFloat((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"speed").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "speed", String.valueOf(FloatArgumentType.getFloat((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stamina").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "stamina", String.valueOf(FloatArgumentType.getFloat((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sprint").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "sprint", String.valueOf(BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dive").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "dive", String.valueOf(BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"glide").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "glide", String.valueOf(BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fly").then((ArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()))).executes(ctx -> ChocoboCommand.setAttribute((CommandContext<CommandSourceStack>)ctx, "fly", String.valueOf(BoolArgumentType.getBool((CommandContext)ctx, (String)"value"))))));
        dispatcher.register(root);
    }

    private static int sendList(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        Entity commandEntity = source.m_81373_();
        if (commandEntity instanceof Player) {
            Player player = (Player)commandEntity;
            Entity mount = player.m_20202_();
            if (!(mount instanceof ChocoboEntity)) {
                source.m_81354_((Component)new TranslatableComponent("command.chococraft.chocobo.not_riding_chocobo"), false);
                return 0;
            }
            ChocoboEntity chocobo = (ChocoboEntity)mount;
            source.m_81354_((Component)ChocoboCommand.getText("get_health", chocobo, Attributes.f_22276_), false);
            source.m_81354_((Component)ChocoboCommand.getText("get_resistance", chocobo, Attributes.f_22284_), false);
            source.m_81354_((Component)ChocoboCommand.getText("get_speed", chocobo, Attributes.f_22279_), false);
            source.m_81354_((Component)ChocoboCommand.getText("get_stamina", chocobo, (Attribute)ModAttributes.MAX_STAMINA.get()), false);
            source.m_81354_((Component)ChocoboCommand.getText("sprint", chocobo.canSprint()), false);
            source.m_81354_((Component)ChocoboCommand.getText("dive", chocobo.canDive()), false);
            source.m_81354_((Component)ChocoboCommand.getText("glide", chocobo.canGlide()), false);
            source.m_81354_((Component)ChocoboCommand.getText("fly", chocobo.canFly()), false);
        }
        return 0;
    }

    private static int setAttribute(CommandContext<CommandSourceStack> commandContext, String trait, String value) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        Entity commandEntity = source.m_81373_();
        if (commandEntity instanceof Player) {
            Player player = (Player)commandEntity;
            Entity mount = player.m_20202_();
            if (!(mount instanceof ChocoboEntity)) {
                source.m_81354_((Component)new TranslatableComponent("command.chococraft.chocobo.not_riding_chocobo"), false);
                return 0;
            }
            ChocoboEntity chocobo = (ChocoboEntity)mount;
            if (setMap.containsKey(trait)) {
                setMap.get(trait).accept((Object)chocobo, (Object)value);
                source.m_81354_((Component)new TranslatableComponent("command.chococraft.chocobo.successfuly_set_parameters", new Object[]{trait, value}), false);
            }
        }
        return 0;
    }

    private static TranslatableComponent getText(String key, ChocoboEntity chocobo, Attribute attribute) {
        return new TranslatableComponent("command.chococraft.chocobo." + key, new Object[]{chocobo.m_21051_(attribute).m_22115_()});
    }

    private static TranslatableComponent getText(String key, boolean state) {
        return new TranslatableComponent("command.chococraft.chocobo." + key, new Object[]{I18n.m_118938_((String)(state ? "command.chococraft.chocobo.true" : "command.chococraft.chocobo.false"), (Object[])new Object[0])});
    }

    static {
        setMap.put("health", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.m_21051_(Attributes.f_22276_).m_22100_((double)Float.parseFloat(arg))));
        setMap.put("resistance", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.m_21051_(Attributes.f_22284_).m_22100_((double)Float.parseFloat(arg))));
        setMap.put("speed", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.m_21051_(Attributes.f_22279_).m_22100_((double)Float.parseFloat(arg))));
        setMap.put("stamina", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.m_21051_((Attribute)ModAttributes.MAX_STAMINA.get()).m_22100_((double)Float.parseFloat(arg))));
        setMap.put("sprint", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.setCanSprint(Boolean.parseBoolean(arg))));
        setMap.put("dive", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.setCanDive(Boolean.parseBoolean(arg))));
        setMap.put("glide", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.setCanGlide(Boolean.parseBoolean(arg))));
        setMap.put("fly", (BiConsumer<ChocoboEntity, String>)((BiConsumer)(entity, arg) -> entity.setCanFly(Boolean.parseBoolean(arg))));
    }
}

