/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.chococraft.common.blockentities.ChocoboNestBlockEntity;
import net.chococraft.common.blocks.ChocoboEggBlock;
import net.chococraft.common.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class StrawNestBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_EGG = BooleanProperty.m_61465_((String)"egg");
    protected static final VoxelShape EMPTY_SHAPE = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0), Block.m_49796_((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)3.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public StrawNestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_EGG, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue()) {
            return SHAPE;
        }
        return EMPTY_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_EGG});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (!(tile instanceof ChocoboNestBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ChocoboNestBlockEntity nest = (ChocoboNestBlockEntity)tile;
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (ChocoboEggBlock.isChocoboEgg(heldItem)) {
            if (!nest.getEggItemStack().m_41619_()) {
                return InteractionResult.FAIL;
            }
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            nest.setEggItemStack(playerIn.m_21120_(handIn).m_41777_());
            playerIn.m_21120_(handIn).m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (!worldIn.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)nest, (BlockPos)pos);
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return StrawNestBlock.createNestTicker(level, blockEntityType, (BlockEntityType<? extends ChocoboNestBlockEntity>)((BlockEntityType)ModRegistry.STRAW_NEST_TILE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createNestTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends ChocoboNestBlockEntity> nestBlockEntityType) {
        return level.f_46443_ ? null : StrawNestBlock.m_152132_(blockEntityType, nestBlockEntityType, ChocoboNestBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChocoboNestBlockEntity(pos, state);
    }
}

