/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.chococraft.Chococraft;
import net.chococraft.common.blockentities.ChocoboEggBlockEntity;
import net.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.chococraft.common.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChocoboEggBlock
extends BaseEntityBlock {
    public static final String NBTKEY_HATCHINGSTATE_TIME = "Time";
    public static final String NBTKEY_HATCHINGSTATE = "HatchingState";
    public static final String NBTKEY_BREEDINFO = "BreedInfo";
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ChocoboEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static boolean isChocoboEgg(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BlockItem && ((BlockItem)itemStack.m_41720_()).m_40614_() instanceof ChocoboEggBlock;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChocoboEggBlockEntity(pos, state);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.f_46443_) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (!(tile instanceof ChocoboEggBlockEntity)) {
                return;
            }
            ChocoboBreedInfo breedInfo = ChocoboBreedInfo.getFromNbtOrDefault(stack.m_41737_(NBTKEY_BREEDINFO));
            ((ChocoboEggBlockEntity)tile).setBreedInfo(breedInfo);
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (worldIn.f_46443_) {
            return;
        }
        if (te instanceof ChocoboEggBlockEntity) {
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.005f);
            ItemStack itemStack = new ItemStack((ItemLike)ModRegistry.CHOCOBO_EGG.get());
            ChocoboBreedInfo breedInfo = ((ChocoboEggBlockEntity)te).getBreedInfo();
            if (breedInfo == null) {
                Chococraft.log.error("Unable to create ItemStack for egg @ {}, the eggy has no breeding info attached");
                return;
            }
            itemStack.m_41700_(NBTKEY_BREEDINFO, (Tag)breedInfo.serialize());
            ChocoboEggBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemStack);
            return;
        }
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag nbtBreedInfo = stack.m_41737_(NBTKEY_BREEDINFO);
        if (nbtBreedInfo != null) {
            ChocoboBreedInfo info = new ChocoboBreedInfo(nbtBreedInfo);
            ChocoboStatSnapshot mother = info.getMother();
            ChocoboStatSnapshot father = info.getFather();
            tooltip.add((Component)new TranslatableComponent("item.chococraft.chocobo_egg.tooltip.mother_info", new Object[]{(int)mother.health, (int)(mother.speed * 100.0f), (int)mother.stamina, mother.color.getEggText()}));
            tooltip.add((Component)new TranslatableComponent("item.chococraft.chocobo_egg.tooltip.father_info", new Object[]{(int)father.health, (int)(father.speed * 100.0f), (int)father.stamina, father.color.getEggText()}));
        } else {
            tooltip.add((Component)new TranslatableComponent("item.chococraft.chocobo_egg.tooltip.invalid_egg"));
        }
    }
}

