/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.models.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ChocoDisguiseModel
extends HumanoidModel<LivingEntity> {
    private EquipmentSlot slot;
    private final ModelPart chocobo_head;
    private final ModelPart chocobo_body;
    private final ModelPart chocobo_right_arm;
    private final ModelPart chocobo_left_arm;
    private final ModelPart chocobo_leg_right;
    private final ModelPart chocobo_leg_left;
    private final ModelPart chocobo_claw_right;
    private final ModelPart chocobo_claw_left;

    public ChocoDisguiseModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.slot = slot;
        this.chocobo_head = root.m_171324_("chocobo_head");
        this.chocobo_body = root.m_171324_("chocobo_body");
        this.chocobo_right_arm = root.m_171324_("chocobo_right_arm");
        this.chocobo_left_arm = root.m_171324_("chocobo_left_arm");
        this.chocobo_leg_right = root.m_171324_("chocobo_leg_right");
        this.chocobo_leg_left = root.m_171324_("chocobo_leg_left");
        this.chocobo_claw_right = root.m_171324_("chocobo_claw_right");
        this.chocobo_claw_left = root.m_171324_("chocobo_claw_left");
    }

    public static LayerDefinition createArmorDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)1.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition chocobo_head = partdefinition.m_171599_("chocobo_head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.f_171404_);
        PartDefinition the_head = chocobo_head.m_171599_("the_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.2063f, -3.8667f, -9.081f, 6.0f, 6.0f, 12.0f).m_171514_(36, 12).m_171481_(2.0f, -3.0f, -3.0f, 1.0f, 3.0f, 3.0f).m_171514_(36, 12).m_171481_(-3.5f, -3.0f, -3.0f, 1.0f, 3.0f, 3.0f).m_171480_(), PartPose.m_171423_((float)0.2063f, (float)-10.1333f, (float)-0.919f, (float)0.2618f, (float)0.0f, (float)0.0f));
        the_head.m_171599_("crest_right", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171481_(-0.5f, -4.5f, 0.0f, 1.0f, 7.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)-2.7063f, (float)-0.3667f, (float)2.919f, (float)0.2094f, (float)-0.384f, (float)0.2094f));
        the_head.m_171599_("crest_top", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171481_(-3.0f, -0.5f, 0.0f, 5.0f, 1.0f, 6.0f), PartPose.m_171423_((float)0.2937f, (float)-2.8667f, (float)2.919f, (float)0.4538f, (float)0.0f, (float)0.0f));
        the_head.m_171599_("crest_left", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171481_(-0.5f, -4.5f, 0.0f, 1.0f, 7.0f, 4.0f), PartPose.m_171423_((float)2.2937f, (float)-0.3667f, (float)2.919f, (float)0.2094f, (float)0.384f, (float)-0.2094f));
        PartDefinition chocobo_body = partdefinition.m_171599_("chocobo_body", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171481_(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f), PartPose.f_171404_);
        chocobo_body.m_171599_("feathers_middle", CubeListBuilder.m_171558_().m_171514_(102, 93).m_171481_(-3.5f, 0.5f, -0.5f, 7.0f, 1.0f, 6.0f), PartPose.m_171423_((float)-0.5f, (float)8.0f, (float)2.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        chocobo_body.m_171599_("feathers_left", CubeListBuilder.m_171558_().m_171514_(44, 92).m_171481_(1.5f, -8.5f, -0.5f, 1.0f, 14.0f, 9.0f), PartPose.m_171423_((float)-0.5f, (float)8.0f, (float)2.5f, (float)-0.2094f, (float)0.384f, (float)0.3491f));
        chocobo_body.m_171599_("feathers_right", CubeListBuilder.m_171558_().m_171514_(44, 92).m_171481_(1.5f, -8.5f, -0.5f, 1.0f, 14.0f, 9.0f), PartPose.m_171423_((float)-0.5f, (float)8.0f, (float)2.5f, (float)-0.2094f, (float)-0.384f, (float)-0.3491f));
        partdefinition.m_171599_("chocobo_right_arm", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-3.5f, -3.0f, -2.5f, 5.0f, 15.0f, 5.0f, new CubeDeformation(-0.25f)).m_171480_(), PartPose.f_171404_);
        partdefinition.m_171599_("chocobo_left_arm", CubeListBuilder.m_171558_().m_171514_(20, 36).m_171488_(-1.5f, -2.5f, -2.5f, 5.0f, 15.0f, 5.0f, new CubeDeformation(-0.25f)).m_171480_(), PartPose.f_171404_);
        partdefinition.m_171599_("chocobo_leg_right", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.6f, -0.5f, -2.6f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.125f)).m_171480_(), PartPose.f_171404_);
        partdefinition.m_171599_("chocobo_leg_left", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.125f)).m_171480_(), PartPose.f_171404_);
        PartDefinition chocobo_claw_right = partdefinition.m_171599_("chocobo_claw_right", CubeListBuilder.m_171558_().m_171514_(20, 56).m_171488_(-2.5f, 6.25f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.25f)).m_171480_(), PartPose.f_171404_);
        chocobo_claw_right.m_171599_("claw_right", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171481_(-1.0f, -1.25f, -6.5f, 2.0f, 2.0f, 7.0f), PartPose.m_171423_((float)-1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)0.3054f, (float)0.0f));
        chocobo_claw_right.m_171599_("claw_left", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171481_(0.0f, -1.25f, -5.5f, 2.0f, 2.0f, 7.0f), PartPose.m_171423_((float)-1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition chocobo_claw_left = partdefinition.m_171599_("chocobo_claw_left", CubeListBuilder.m_171558_().m_171514_(20, 56).m_171488_(-2.4f, 6.25f, -2.6f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.25f)).m_171480_(), PartPose.f_171404_);
        chocobo_claw_left.m_171599_("claw_right", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171481_(-1.0f, -1.25f, -6.5f, 2.0f, 2.0f, 7.0f), PartPose.m_171423_((float)1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        chocobo_claw_left.m_171599_("claw_left", CubeListBuilder.m_171558_().m_171514_(40, 37).m_171481_(-2.0f, -1.25f, -5.5f, 2.0f, 2.0f, 7.0f), PartPose.m_171423_((float)1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)livingEntity;
            this.chocobo_head.f_104203_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123156_();
            this.chocobo_head.f_104204_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123157_();
            this.chocobo_head.f_104205_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123158_();
            this.chocobo_head.m_104227_(0.0f, 1.0f, 0.0f);
            this.chocobo_body.f_104203_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123156_();
            this.chocobo_body.f_104204_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123157_();
            this.chocobo_body.f_104205_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123158_();
            this.chocobo_left_arm.f_104203_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123156_();
            this.chocobo_left_arm.f_104204_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123157_();
            this.chocobo_left_arm.f_104205_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123158_();
            this.chocobo_right_arm.f_104203_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123156_();
            this.chocobo_right_arm.f_104204_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123157_();
            this.chocobo_right_arm.f_104205_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123158_();
            this.chocobo_leg_left.f_104203_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123156_();
            this.chocobo_leg_left.f_104204_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123157_();
            this.chocobo_leg_left.f_104205_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123158_();
            this.chocobo_leg_left.m_104227_(1.9f, 11.0f, 0.0f);
            this.chocobo_leg_right.f_104203_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123156_();
            this.chocobo_leg_right.f_104204_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123157_();
            this.chocobo_leg_right.f_104205_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123158_();
            this.chocobo_leg_right.m_104227_(-1.9f, 11.0f, 0.0f);
            this.f_102809_.m_104315_(this.chocobo_head);
        } else {
            super.m_6973_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        this.setHeadRotation();
        this.setChestRotation();
        this.setLegsRotation();
        this.setBootRotation();
        this.chocobo_head.f_104207_ = this.slot == EquipmentSlot.HEAD;
        this.chocobo_body.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.chocobo_right_arm.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.chocobo_left_arm.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.chocobo_leg_right.f_104207_ = this.slot == EquipmentSlot.LEGS;
        this.chocobo_leg_left.f_104207_ = this.slot == EquipmentSlot.LEGS;
        this.chocobo_claw_right.f_104207_ = this.slot == EquipmentSlot.FEET;
        boolean bl = this.chocobo_claw_left.f_104207_ = this.slot == EquipmentSlot.FEET;
        if (this.f_102610_) {
            float f = 2.0f;
            matrixStack.m_85841_(1.5f / f, 1.5f / f, 1.5f / f);
            matrixStack.m_85837_(0.0, 16.0, 0.0);
            this.chocobo_head.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.0f / f, 1.0f / f, 1.0f / f);
            matrixStack.m_85837_(0.0, 24.0, 0.0);
            this.chocobo_body.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.chocobo_head.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chocobo_body.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chocobo_right_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chocobo_left_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.chocobo_leg_right.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.chocobo_leg_left.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.chocobo_claw_right.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.chocobo_claw_left.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.m_85849_();
    }

    public void setHeadRotation() {
        this.chocobo_head.f_104200_ = this.f_102808_.f_104200_;
        this.chocobo_head.f_104201_ = this.f_102808_.f_104201_;
        this.chocobo_head.f_104202_ = this.f_102808_.f_104202_;
        this.setRotation(this.chocobo_head, this.f_102808_.f_104203_, this.f_102808_.f_104204_, this.f_102808_.f_104205_);
    }

    public void setChestRotation() {
        this.chocobo_body.f_104200_ = this.f_102810_.f_104200_;
        this.chocobo_body.f_104201_ = this.f_102810_.f_104201_;
        this.chocobo_body.f_104202_ = this.f_102810_.f_104202_;
        this.chocobo_right_arm.f_104200_ = this.f_102811_.f_104200_;
        this.chocobo_right_arm.f_104201_ = this.f_102811_.f_104201_;
        this.chocobo_right_arm.f_104202_ = this.f_102811_.f_104202_;
        this.chocobo_left_arm.f_104200_ = this.f_102812_.f_104200_;
        this.chocobo_left_arm.f_104201_ = this.f_102812_.f_104201_;
        this.chocobo_left_arm.f_104202_ = this.f_102812_.f_104202_;
        this.setRotation(this.chocobo_body, this.f_102810_.f_104203_, this.f_102810_.f_104204_, this.f_102810_.f_104205_);
        this.setRotation(this.chocobo_right_arm, this.f_102811_.f_104203_, this.f_102811_.f_104204_, this.f_102811_.f_104205_);
        this.setRotation(this.chocobo_left_arm, this.f_102812_.f_104203_, this.f_102812_.f_104204_, this.f_102812_.f_104205_);
    }

    public void setLegsRotation() {
        this.chocobo_leg_right.f_104200_ = this.f_102813_.f_104200_;
        this.chocobo_leg_right.f_104201_ = this.f_102813_.f_104201_;
        this.chocobo_leg_right.f_104202_ = this.f_102813_.f_104202_;
        this.chocobo_leg_left.f_104200_ = this.f_102814_.f_104200_;
        this.chocobo_leg_left.f_104201_ = this.f_102814_.f_104201_;
        this.chocobo_leg_left.f_104202_ = this.f_102814_.f_104202_;
        this.setRotation(this.chocobo_leg_right, this.f_102813_.f_104203_, this.f_102813_.f_104204_, this.f_102813_.f_104205_);
        this.setRotation(this.chocobo_leg_left, this.f_102814_.f_104203_, this.f_102814_.f_104204_, this.f_102814_.f_104205_);
    }

    public void setBootRotation() {
        this.chocobo_claw_right.f_104200_ = this.f_102813_.f_104200_;
        this.chocobo_claw_right.f_104201_ = this.f_102813_.f_104201_;
        this.chocobo_claw_right.f_104202_ = this.f_102813_.f_104202_;
        this.chocobo_claw_left.f_104200_ = this.f_102814_.f_104200_;
        this.chocobo_claw_left.f_104201_ = this.f_102814_.f_104201_;
        this.chocobo_claw_left.f_104202_ = this.f_102814_.f_104202_;
        this.setRotation(this.chocobo_claw_right, this.f_102813_.f_104203_, this.f_102813_.f_104204_, this.f_102813_.f_104205_);
        this.setRotation(this.chocobo_claw_left, this.f_102814_.f_104203_, this.f_102814_.f_104204_, this.f_102814_.f_104205_);
    }

    public void setRotation(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

