/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.utility;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010$\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010%\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0004J\u001e\u0010'\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u000bJ\u001e\u0010(\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u000eJ\u001e\u0010)\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0010J\u001e\u0010*\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0013J\u001e\u0010+\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0016J\u001e\u0010,\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0018J\u001e\u0010-\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001bJ\u001e\u0010.\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001eJ\u001e\u0010/\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b\u00a8\u00060"}, d2={"Lcom/davidm1a2/afraidofthedark/common/utility/NBTHelper;", "", "()V", "getBoolean", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "keyName", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Boolean;", "getByte", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Byte;", "getCompound", "Lnet/minecraft/nbt/CompoundNBT;", "getDouble", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Double;", "getFloat", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Float;", "getIntArray", "", "getInteger", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Long;", "getShort", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Short;", "getString", "hasTag", "initNBTTagCompound", "", "removeTag", "setBoolean", "keyValue", "setByte", "setCompound", "setDouble", "setFloat", "setIntArray", "setInteger", "setLong", "setShort", "setString", "afraidofthedark"})
public final class NBTHelper {
    @NotNull
    public static final NBTHelper INSTANCE = new NBTHelper();

    private NBTHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (itemStack.func_77978_p() == null) return false;
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        if (!compoundNBT.func_74764_b(keyName)) return false;
        return true;
    }

    public final void removeTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            compoundNBT.func_82580_o(keyName);
        }
    }

    private final void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new CompoundNBT());
        }
    }

    public final void setLong(@NotNull ItemStack itemStack, @NotNull String keyName, long keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74772_a(keyName, keyValue);
    }

    @Nullable
    public final Long getLong(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Long l;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            l = compoundNBT.func_74763_f(keyName);
        } else {
            l = null;
        }
        return l;
    }

    public final void setString(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull String keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74778_a(keyName, keyValue);
    }

    @Nullable
    public final String getString(@NotNull ItemStack itemStack, @NotNull String keyName) {
        String string;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            string = compoundNBT.func_74779_i(keyName);
        } else {
            string = null;
        }
        return string;
    }

    public final void setBoolean(@NotNull ItemStack itemStack, @NotNull String keyName, boolean keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74757_a(keyName, keyValue);
    }

    @Nullable
    public final Boolean getBoolean(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Boolean bl;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            bl = compoundNBT.func_74767_n(keyName);
        } else {
            bl = null;
        }
        return bl;
    }

    public final void setByte(@NotNull ItemStack itemStack, @NotNull String keyName, byte keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74774_a(keyName, keyValue);
    }

    @Nullable
    public final Byte getByte(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Byte by;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            by = compoundNBT.func_74771_c(keyName);
        } else {
            by = null;
        }
        return by;
    }

    public final void setShort(@NotNull ItemStack itemStack, @NotNull String keyName, short keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74777_a(keyName, keyValue);
    }

    @Nullable
    public final Short getShort(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Short s;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            s = compoundNBT.func_74765_d(keyName);
        } else {
            s = null;
        }
        return s;
    }

    public final void setInteger(@NotNull ItemStack itemStack, @NotNull String keyName, int keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74768_a(keyName, keyValue);
    }

    @Nullable
    public final Integer getInteger(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Integer n;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            n = compoundNBT.func_74762_e(keyName);
        } else {
            n = null;
        }
        return n;
    }

    public final void setFloat(@NotNull ItemStack itemStack, @NotNull String keyName, float keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74776_a(keyName, keyValue);
    }

    @Nullable
    public final Float getFloat(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Float f;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            f = Float.valueOf(compoundNBT.func_74760_g(keyName));
        } else {
            f = null;
        }
        return f;
    }

    public final void setDouble(@NotNull ItemStack itemStack, @NotNull String keyName, double keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74780_a(keyName, keyValue);
    }

    @Nullable
    public final Double getDouble(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Double d;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            d = compoundNBT.func_74769_h(keyName);
        } else {
            d = null;
        }
        return d;
    }

    public final void setCompound(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull CompoundNBT keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_218657_a(keyName, (INBT)keyValue);
    }

    @Nullable
    public final CompoundNBT getCompound(@NotNull ItemStack itemStack, @NotNull String keyName) {
        CompoundNBT compoundNBT;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT2 = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT2);
            compoundNBT = compoundNBT2.func_74775_l(keyName);
        } else {
            compoundNBT = null;
        }
        return compoundNBT;
    }

    public final void setIntArray(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull int[] keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74783_a(keyName, keyValue);
    }

    @Nullable
    public final int[] getIntArray(@NotNull ItemStack itemStack, @NotNull String keyName) {
        int[] nArray;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            nArray = compoundNBT.func_74759_k(keyName);
        } else {
            nArray = null;
        }
        return nArray;
    }
}

