/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.powerSource;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.AOTDSpellPowerSource;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/AlchemySpellPowerSource;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/base/AOTDSpellPowerSource;", "()V", "canCast", "", "entity", "Lnet/minecraft/entity/Entity;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "consumePowerToCast", "", "getCostDescription", "", "getUnlocalizedOutOfPowerMsg", "Companion", "afraidofthedark"})
public final class AlchemySpellPowerSource
extends AOTDSpellPowerSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double UNIT_COST_PER_GOLD = 5.0;

    public AlchemySpellPowerSource() {
        super(new ResourceLocation("afraidofthedark", "alchemy"));
    }

    @Override
    public boolean canCast(@NotNull Entity entity, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(spell, "spell");
        if (entity instanceof PlayerEntity) {
            NonNullList nonNullList = ((PlayerEntity)entity).field_71071_by.field_70462_a;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.items");
            Collection collection = (Collection)nonNullList;
            nonNullList = ((PlayerEntity)entity).field_71071_by.field_184439_c;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.offhand");
            List<ItemStack> inventory = CollectionsKt.plus(collection, (Iterable)nonNullList);
            int goldCount = 0;
            for (ItemStack stack : inventory) {
                if (!Intrinsics.areEqual(stack.func_77973_b(), Items.field_151043_k)) continue;
                goldCount += stack.func_190916_E();
            }
            return (double)goldCount * 5.0 > spell.getCost();
        }
        return false;
    }

    @Override
    public void consumePowerToCast(@NotNull Entity entity, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(spell, "spell");
        if (entity instanceof PlayerEntity) {
            NonNullList nonNullList = ((PlayerEntity)entity).field_71071_by.field_70462_a;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.items");
            Collection collection = (Collection)nonNullList;
            nonNullList = ((PlayerEntity)entity).field_71071_by.field_184439_c;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.offhand");
            List<ItemStack> inventory = CollectionsKt.plus(collection, (Iterable)nonNullList);
            double costRemaining = spell.getCost();
            for (ItemStack stack : inventory) {
                if (Intrinsics.areEqual(stack.func_77973_b(), Items.field_151043_k)) {
                    while (costRemaining > 0.0 && stack.func_190916_E() > 0) {
                        costRemaining -= 5.0;
                        ItemStack itemStack = stack;
                        int n = itemStack.func_190916_E();
                        itemStack.func_190920_e(n + -1);
                    }
                }
                if (!(costRemaining <= 0.0)) continue;
                break;
            }
        }
    }

    @Override
    @NotNull
    public String getCostDescription() {
        return "Transmute gold ingots into magic essence at a rate of 5.0 spell power per ingot";
    }

    @Override
    @NotNull
    public String getUnlocalizedOutOfPowerMsg() {
        return "message.afraidofthedark.spell.power_source.alchemy.invalid_msg";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/AlchemySpellPowerSource$Companion;", "", "()V", "UNIT_COST_PER_GOLD", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

