/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IPlayerSpellFreezeData;
import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/FreezeSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getFreezeDuration", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "setFreezeDuration", "duration", "Companion", "afraidofthedark"})
public final class FreezeSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_FREEZE_DURATION = "freeze_duration";

    public FreezeSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "freeze"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Duration")).withDescription("The number of ticks the freeze will last against entities.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(20)).withMinValue(1)).withMaxValue(1200)).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        World world = (World)state.getWorld();
        BlockPos blockPos = state.getBlockPosition();
        Entity entity = state.getEntity();
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                IPlayerSpellFreezeData freezeData;
                if (entity instanceof PlayerEntity) {
                    freezeData = CapabilityExtensionsKt.getSpellFreezeData((PlayerEntity)entity);
                    freezeData.setFreezeTicks(this.getFreezeDuration(instance));
                    freezeData.setFreezePosition(new Vector3d(((PlayerEntity)entity).func_226277_ct_(), ((PlayerEntity)entity).func_226278_cu_(), ((PlayerEntity)entity).func_226281_cx_()));
                    freezeData.setFreezeYaw(((LivingEntity)entity).field_70177_z);
                    freezeData.setFreezePitch(((LivingEntity)entity).field_70125_A);
                } else {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, this.getFreezeDuration(instance), 99));
                }
                freezeData = ((LivingEntity)entity).func_213303_ch();
                Intrinsics.checkNotNullExpressionValue(freezeData, "entity.position()");
                IPlayerSpellFreezeData iPlayerSpellFreezeData = freezeData;
                freezeData = ((LivingEntity)entity).field_70170_p.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(freezeData, "entity.level.dimension()");
                AOTDSpellEffect.Companion.createParticlesAround(5, 10, (Vector3d)iPlayerSpellFreezeData, (RegistryKey<World>)freezeData, ModParticles.INSTANCE.getFREEZE(), 1.0);
            }
        } else {
            BlockState hitBlock = world.func_180495_p(blockPos);
            if (Intrinsics.areEqual(hitBlock.func_177230_c(), Blocks.field_150355_j)) {
                world.func_175656_a(blockPos, Blocks.field_150432_aD.func_176223_P());
                Vector3d vector3d = state.getPosition();
                RegistryKey registryKey = world.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(registryKey, "world.dimension()");
                AOTDSpellEffect.Companion.createParticlesAround(5, 10, vector3d, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getFREEZE(), 1.0);
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        double freezeDuration = (double)this.getFreezeDuration(instance) / 20.0;
        return 25.0 + freezeDuration * freezeDuration * 5.0;
    }

    public final void setFreezeDuration(@NotNull SpellComponentInstance<SpellEffect> instance, int duration) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74768_a(NBT_FREEZE_DURATION, duration);
    }

    public final int getFreezeDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_FREEZE_DURATION);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/FreezeSpellEffect$Companion;", "", "()V", "NBT_FREEZE_DURATION", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

