/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0001.BU\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010(\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u0004\u0018\u00010\u000eJ\b\u0010,\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010-\u001a\u00020\u0013R\u0011\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0006\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "stageIndex", "", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/vector/Vector3d;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "direction", "casterEntity", "Lnet/minecraft/entity/Entity;", "entity", "deliveryEntity", "(Lcom/davidm1a2/afraidofthedark/common/spell/Spell;ILnet/minecraft/world/World;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;)V", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "(Lnet/minecraft/nbt/CompoundNBT;)V", "blockPosition", "getBlockPosition", "()Lnet/minecraft/util/math/BlockPos;", "casterEntityId", "Ljava/util/UUID;", "deliveryEntityId", "getDirection", "()Lnet/minecraft/util/math/vector/Vector3d;", "entityId", "lazyWorld", "Lkotlin/Lazy;", "Lnet/minecraft/world/server/ServerWorld;", "getPosition", "getSpell", "()Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "getStageIndex", "()I", "getWorld", "()Lnet/minecraft/world/server/ServerWorld;", "getCasterEntity", "getCurrentStage", "Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "getDeliveryEntity", "getEntity", "writeToNbt", "Companion", "afraidofthedark"})
public final class DeliveryTransitionState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Spell spell;
    private final int stageIndex;
    @NotNull
    private final Lazy<ServerWorld> lazyWorld;
    @NotNull
    private final Vector3d position;
    @NotNull
    private final BlockPos blockPosition;
    @NotNull
    private final Vector3d direction;
    @Nullable
    private final UUID casterEntityId;
    @Nullable
    private final UUID entityId;
    @Nullable
    private final UUID deliveryEntityId;
    @NotNull
    private static final String NBT_SPELL = "spell";
    @NotNull
    private static final String NBT_STAGE_INDEX = "stage_index";
    @NotNull
    private static final String NBT_WORLD = "world";
    @NotNull
    private static final String NBT_POSITION = "position";
    @NotNull
    private static final String NBT_BLOCK_POSITION = "block_position";
    @NotNull
    private static final String NBT_DIRECTION = "direction";
    @NotNull
    private static final String NBT_CASTER_ENTITY_ID = "caster_entity_id";
    @NotNull
    private static final String NBT_ENTITY_ID = "entity_id";
    @NotNull
    private static final String NBT_DELIVERY_ENTITY_ID = "delivery_entity_id";

    @NotNull
    public final Spell getSpell() {
        return this.spell;
    }

    public final int getStageIndex() {
        return this.stageIndex;
    }

    @NotNull
    public final ServerWorld getWorld() {
        return this.lazyWorld.getValue();
    }

    @NotNull
    public final Vector3d getPosition() {
        return this.position;
    }

    @NotNull
    public final BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    @NotNull
    public final Vector3d getDirection() {
        return this.direction;
    }

    public DeliveryTransitionState(@NotNull Spell spell, int stageIndex, @NotNull World world, @NotNull Vector3d position, @NotNull BlockPos blockPos, @NotNull Vector3d direction, @Nullable Entity casterEntity, @Nullable Entity entity, @Nullable Entity deliveryEntity) {
        Intrinsics.checkNotNullParameter(spell, NBT_SPELL);
        Intrinsics.checkNotNullParameter(world, NBT_WORLD);
        Intrinsics.checkNotNullParameter(position, NBT_POSITION);
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(direction, NBT_DIRECTION);
        this.spell = spell;
        this.stageIndex = stageIndex;
        this.lazyWorld = LazyKt.lazyOf((ServerWorld)world);
        this.position = position;
        this.blockPosition = blockPos;
        this.direction = direction;
        Entity entity2 = casterEntity;
        this.casterEntityId = entity2 == null ? null : entity2.func_110124_au();
        entity2 = entity;
        this.entityId = entity2 == null ? null : entity2.func_110124_au();
        entity2 = deliveryEntity;
        this.deliveryEntityId = entity2 == null ? null : entity2.func_110124_au();
    }

    public DeliveryTransitionState(final @NotNull CompoundNBT nbt) {
        UUID uUID;
        UUID uUID2;
        UUID uUID3;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        CompoundNBT compoundNBT = nbt.func_74775_l(NBT_SPELL);
        Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt.getCompound(NBT_SPELL)");
        this.spell = new Spell(compoundNBT);
        this.stageIndex = nbt.func_74762_e(NBT_STAGE_INDEX);
        this.lazyWorld = LazyKt.lazy((Function0)new Function0<ServerWorld>(){

            @Override
            @NotNull
            public final ServerWorld invoke() {
                ServerWorld serverWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i(DeliveryTransitionState.NBT_WORLD))));
                Intrinsics.checkNotNull(serverWorld);
                return serverWorld;
            }
        });
        this.position = new Vector3d(nbt.func_74769_h("position_x"), nbt.func_74769_h("position_y"), nbt.func_74769_h("position_z"));
        compoundNBT = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l(NBT_BLOCK_POSITION));
        Intrinsics.checkNotNullExpressionValue(compoundNBT, "readBlockPos(nbt.getCompound(NBT_BLOCK_POSITION))");
        this.blockPosition = compoundNBT;
        this.direction = new Vector3d(nbt.func_74769_h("direction_x"), nbt.func_74769_h("direction_y"), nbt.func_74769_h("direction_z"));
        if (nbt.func_74764_b(NBT_CASTER_ENTITY_ID)) {
            compoundNBT = nbt.func_74781_a(NBT_CASTER_ENTITY_ID);
            Intrinsics.checkNotNull(compoundNBT);
            uUID3 = NBTUtil.func_186860_b((INBT)compoundNBT);
        } else {
            uUID3 = this.casterEntityId = (UUID)null;
        }
        if (nbt.func_74764_b(NBT_ENTITY_ID)) {
            compoundNBT = nbt.func_74781_a(NBT_ENTITY_ID);
            Intrinsics.checkNotNull(compoundNBT);
            uUID2 = NBTUtil.func_186860_b((INBT)compoundNBT);
        } else {
            uUID2 = this.entityId = (UUID)null;
        }
        if (nbt.func_74764_b(NBT_DELIVERY_ENTITY_ID)) {
            compoundNBT = nbt.func_74781_a(NBT_DELIVERY_ENTITY_ID);
            Intrinsics.checkNotNull(compoundNBT);
            uUID = NBTUtil.func_186860_b((INBT)compoundNBT);
        } else {
            uUID = null;
        }
        this.deliveryEntityId = uUID;
    }

    @NotNull
    public final CompoundNBT writeToNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(NBT_SPELL, (INBT)this.spell.serializeNBT());
        nbt.func_74768_a(NBT_STAGE_INDEX, this.stageIndex);
        nbt.func_74778_a(NBT_WORLD, this.getWorld().func_234923_W_().func_240901_a_().toString());
        nbt.func_74780_a("position_x", this.position.field_72450_a);
        nbt.func_74780_a("position_y", this.position.field_72448_b);
        nbt.func_74780_a("position_z", this.position.field_72449_c);
        nbt.func_218657_a(NBT_BLOCK_POSITION, (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPosition));
        nbt.func_74780_a("direction_x", this.direction.field_72450_a);
        nbt.func_74780_a("direction_y", this.direction.field_72448_b);
        nbt.func_74780_a("direction_z", this.direction.field_72449_c);
        if (this.casterEntityId != null) {
            nbt.func_218657_a(NBT_CASTER_ENTITY_ID, (INBT)NBTUtil.func_240626_a_((UUID)this.casterEntityId));
        }
        if (this.entityId != null) {
            nbt.func_218657_a(NBT_ENTITY_ID, (INBT)NBTUtil.func_240626_a_((UUID)this.entityId));
        }
        if (this.deliveryEntityId != null) {
            nbt.func_218657_a(NBT_DELIVERY_ENTITY_ID, (INBT)NBTUtil.func_240626_a_((UUID)this.deliveryEntityId));
        }
        return nbt;
    }

    @NotNull
    public final SpellStage getCurrentStage() {
        SpellStage spellStage = this.spell.getStage(this.stageIndex);
        if (spellStage == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Current spell state is null, that shouldn't be possible. Spell: \n", this.spell.getName()));
        }
        return spellStage;
    }

    @Nullable
    public final Entity getCasterEntity() {
        Entity entity;
        UUID uUID = this.casterEntityId;
        if (uUID == null) {
            entity = null;
        } else {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.getWorld().func_217461_a(this.casterEntityId);
        }
        return entity;
    }

    @Nullable
    public final Entity getEntity() {
        Entity entity;
        UUID uUID = this.entityId;
        if (uUID == null) {
            entity = null;
        } else {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.getWorld().func_217461_a(it);
        }
        return entity;
    }

    @Nullable
    public final Entity getDeliveryEntity() {
        Entity entity;
        UUID uUID = this.deliveryEntityId;
        if (uUID == null) {
            entity = null;
        } else {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            entity = this.getWorld().func_217461_a(it);
        }
        return entity;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState$Companion;", "", "()V", "NBT_BLOCK_POSITION", "", "NBT_CASTER_ENTITY_ID", "NBT_DELIVERY_ENTITY_ID", "NBT_DIRECTION", "NBT_ENTITY_ID", "NBT_POSITION", "NBT_SPELL", "NBT_STAGE_INDEX", "NBT_WORLD", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

