/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.registry;

import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.registry.CodecExtensionsKt;
import com.davidm1a2.afraidofthedark.common.registry.MeteorEntry;
import com.davidm1a2.afraidofthedark.common.research.Research;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/MeteorEntry;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "icon", "Lnet/minecraft/util/ResourceLocation;", "minRadius", "", "maxRadius", "richnessPercent", "", "interiorBlock", "Lnet/minecraft/block/Block;", "lazyPrerequisiteResearch", "Lkotlin/Lazy;", "Lcom/davidm1a2/afraidofthedark/common/research/Research;", "(Lnet/minecraft/util/ResourceLocation;IIDLnet/minecraft/block/Block;Lkotlin/Lazy;)V", "getIcon", "()Lnet/minecraft/util/ResourceLocation;", "getInteriorBlock", "()Lnet/minecraft/block/Block;", "getMaxRadius", "()I", "getMinRadius", "prerequisiteResearch", "getPrerequisiteResearch", "()Lcom/davidm1a2/afraidofthedark/common/research/Research;", "prerequisiteResearch$delegate", "Lkotlin/Lazy;", "getRichnessPercent", "()D", "getUnlocalizedName", "", "Companion", "afraidofthedark"})
public final class MeteorEntry
extends ForgeRegistryEntry<MeteorEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation icon;
    private final int minRadius;
    private final int maxRadius;
    private final double richnessPercent;
    @NotNull
    private final Block interiorBlock;
    @NotNull
    private final Lazy prerequisiteResearch$delegate;
    private static final Logger LOG = LogManager.getLogger();
    @NotNull
    private static final Codec<MeteorEntry> CODEC;

    public MeteorEntry(@NotNull ResourceLocation icon, int minRadius, int maxRadius, double richnessPercent, @NotNull Block interiorBlock, @NotNull Lazy<Research> lazyPrerequisiteResearch) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(interiorBlock, "interiorBlock");
        Intrinsics.checkNotNullParameter(lazyPrerequisiteResearch, "lazyPrerequisiteResearch");
        this.icon = icon;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.richnessPercent = richnessPercent;
        this.interiorBlock = interiorBlock;
        this.prerequisiteResearch$delegate = lazyPrerequisiteResearch;
        if (this.minRadius < 2) {
            LOG.error("Meteor entries should not have a min radius less than 2!");
        }
        if (this.minRadius > this.maxRadius) {
            LOG.error("Meteor entries max-radius should be larger than the min-radius!");
        }
    }

    @NotNull
    public final ResourceLocation getIcon() {
        return this.icon;
    }

    public final int getMinRadius() {
        return this.minRadius;
    }

    public final int getMaxRadius() {
        return this.maxRadius;
    }

    public final double getRichnessPercent() {
        return this.richnessPercent;
    }

    @NotNull
    public final Block getInteriorBlock() {
        return this.interiorBlock;
    }

    @NotNull
    public final Research getPrerequisiteResearch() {
        Lazy lazy = this.prerequisiteResearch$delegate;
        boolean bl = false;
        return (Research)((Object)lazy.getValue());
    }

    @NotNull
    public final String getUnlocalizedName() {
        StringBuilder stringBuilder = new StringBuilder().append("meteor_entry.");
        ResourceLocation resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        StringBuilder stringBuilder2 = stringBuilder.append((Object)resourceLocation.func_110624_b()).append('.');
        resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        return stringBuilder2.append((Object)resourceLocation.func_110623_a()).toString();
    }

    private static final ResourceLocation CODEC$lambda-7$lambda-0(KProperty1 $tmp0, MeteorEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (ResourceLocation)((Function1)$tmp0).invoke(p0);
    }

    private static final Integer CODEC$lambda-7$lambda-1(KProperty1 $tmp0, MeteorEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)((Function1)$tmp0).invoke(p0);
    }

    private static final Integer CODEC$lambda-7$lambda-2(KProperty1 $tmp0, MeteorEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)((Function1)$tmp0).invoke(p0);
    }

    private static final Double CODEC$lambda-7$lambda-3(KProperty1 $tmp0, MeteorEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Double)((Function1)$tmp0).invoke(p0);
    }

    private static final Block CODEC$lambda-7$lambda-4(KProperty1 $tmp0, MeteorEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Block)((Function1)$tmp0).invoke(p0);
    }

    private static final Lazy CODEC$lambda-7$lambda-5(MeteorEntry meteorEntry) {
        return LazyKt.lazyOf(meteorEntry.getPrerequisiteResearch());
    }

    private static final MeteorEntry CODEC$lambda-7$lambda-6(ResourceLocation name, ResourceLocation icon, Integer minRadius, Integer maxRadius, Double richnessPercent, Block interiorBlock, Lazy prerequisiteResearch) {
        Intrinsics.checkNotNullExpressionValue(icon, "icon");
        Intrinsics.checkNotNullExpressionValue(minRadius, "minRadius");
        int n = minRadius;
        Intrinsics.checkNotNullExpressionValue(maxRadius, "maxRadius");
        int n2 = maxRadius;
        Intrinsics.checkNotNullExpressionValue(richnessPercent, "richnessPercent");
        double d = richnessPercent;
        Intrinsics.checkNotNullExpressionValue(interiorBlock, "interiorBlock");
        Intrinsics.checkNotNullExpressionValue(prerequisiteResearch, "prerequisiteResearch");
        return (MeteorEntry)new MeteorEntry(icon, n, n2, d, interiorBlock, prerequisiteResearch).setRegistryName(name);
    }

    private static final App CODEC$lambda-7(RecordCodecBuilder.Instance it) {
        App app = (App)ResourceLocation.field_240908_a_.fieldOf("forge:registry_name").forGetter(ForgeRegistryEntry::getRegistryName);
        KProperty1 kProperty1 = Companion.CODEC.1.2.INSTANCE;
        App app2 = (App)ResourceLocation.field_240908_a_.fieldOf("icon").forGetter(arg_0 -> MeteorEntry.CODEC$lambda-7$lambda-0(kProperty1, arg_0));
        kProperty1 = Companion.CODEC.1.3.INSTANCE;
        App app3 = (App)Codec.INT.fieldOf("min_radius").forGetter(arg_0 -> MeteorEntry.CODEC$lambda-7$lambda-1(kProperty1, arg_0));
        kProperty1 = Companion.CODEC.1.4.INSTANCE;
        App app4 = (App)Codec.INT.fieldOf("max_radius").forGetter(arg_0 -> MeteorEntry.CODEC$lambda-7$lambda-2(kProperty1, arg_0));
        kProperty1 = Companion.CODEC.1.5.INSTANCE;
        App app5 = (App)Codec.DOUBLE.fieldOf("richness_percent").forGetter(arg_0 -> MeteorEntry.CODEC$lambda-7$lambda-3(kProperty1, arg_0));
        kProperty1 = ForgeRegistries.BLOCKS;
        Intrinsics.checkNotNullExpressionValue(kProperty1, "BLOCKS");
        MapCodec mapCodec = CodecExtensionsKt.codec(kProperty1).fieldOf("interior_block");
        kProperty1 = Companion.CODEC.1.6.INSTANCE;
        return it.group(app, app2, app3, app4, app5, (App)mapCodec.forGetter(arg_0 -> MeteorEntry.CODEC$lambda-7$lambda-4(kProperty1, arg_0)), (App)CodecExtensionsKt.lazy(CodecExtensionsKt.codec(ModRegistries.INSTANCE.getRESEARCH())).fieldOf("prerequisite_research").forGetter(MeteorEntry::CODEC$lambda-7$lambda-5)).apply((Applicative)it, it.stable(MeteorEntry::CODEC$lambda-7$lambda-6));
    }

    static {
        Codec codec = RecordCodecBuilder.create(MeteorEntry::CODEC$lambda-7);
        Intrinsics.checkNotNullExpressionValue(codec, "create {\n            it.group(\n                ResourceLocation.CODEC.fieldOf(\"forge:registry_name\").forGetter(MeteorEntry::getRegistryName),\n                ResourceLocation.CODEC.fieldOf(\"icon\").forGetter(MeteorEntry::icon),\n                Codec.INT.fieldOf(\"min_radius\").forGetter(MeteorEntry::minRadius),\n                Codec.INT.fieldOf(\"max_radius\").forGetter(MeteorEntry::maxRadius),\n                Codec.DOUBLE.fieldOf(\"richness_percent\").forGetter(MeteorEntry::richnessPercent),\n                ForgeRegistries.BLOCKS.codec()\n                    .fieldOf(\"interior_block\")\n                    .forGetter(MeteorEntry::interiorBlock),\n                ModRegistries.RESEARCH.codec()\n                    .lazy()\n                    .fieldOf(\"prerequisite_research\")\n                    .forGetter { meteorEntry -> lazyOf(meteorEntry.prerequisiteResearch) }\n            ).apply(it, it.stable(Function7 { name, icon, minRadius, maxRadius, richnessPercent, interiorBlock, prerequisiteResearch ->\n                MeteorEntry(icon, minRadius, maxRadius, richnessPercent, interiorBlock, prerequisiteResearch).setRegistryName(name)\n            }))\n        }");
        CODEC = codec;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/MeteorEntry$Companion;", "", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/davidm1a2/afraidofthedark/common/registry/MeteorEntry;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<MeteorEntry> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

