/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.network.packets.other;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.network.handler.PacketProcessor;
import com.davidm1a2.afraidofthedark.common.network.packets.other.ProcessSextantInputPacket;
import com.davidm1a2.afraidofthedark.common.registry.MeteorEntry;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/common/network/packets/other/ProcessSextantInputPacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/handler/PacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/packets/other/ProcessSextantInputPacket;", "()V", "decode", "buf", "Lnet/minecraft/network/PacketBuffer;", "dropMeteor", "", "world", "Lnet/minecraft/world/World;", "meteorEntry", "Lcom/davidm1a2/afraidofthedark/common/registry/MeteorEntry;", "xPos", "", "zPos", "encode", "msg", "process", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "Companion", "afraidofthedark"})
public final class ProcessSextantInputPacketProcessor
implements PacketProcessor<ProcessSextantInputPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();
    private static final int MAX_METEOR_DISTANCE = 500;
    @NotNull
    private static final Set<Block> INVALID_TOP_BLOCKS;
    @NotNull
    private static final Set<Block> REPLACEABLE_BLOCKS;

    @Override
    public void encode(@NotNull ProcessSextantInputPacket msg, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(buf, "buf");
        buf.writeInt(msg.getDropAngle$afraidofthedark());
        buf.writeInt(msg.getLatitude$afraidofthedark());
        buf.writeInt(msg.getLongitude$afraidofthedark());
    }

    @Override
    @NotNull
    public ProcessSextantInputPacket decode(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        return new ProcessSextantInputPacket(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void process(@NotNull ProcessSextantInputPacket msg, @NotNull NetworkEvent.Context ctx) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayerEntity serverPlayerEntity;
            ServerPlayerEntity serverPlayerEntity2 = ctx.getSender();
            Intrinsics.checkNotNull(serverPlayerEntity2);
            ServerPlayerEntity player = serverPlayerEntity = serverPlayerEntity2;
            IAOTDPlayerBasics playerBasics = CapabilityExtensionsKt.getBasics((PlayerEntity)player);
            if (playerBasics.getWatchedMeteorDropAngle() == msg.getDropAngle$afraidofthedark() && playerBasics.getWatchedMeteorLatitude() == msg.getLatitude$afraidofthedark() && playerBasics.getWatchedMeteorLongitude() == msg.getLongitude$afraidofthedark()) {
                MeteorEntry meteorEntry = playerBasics.getWatchedMeteor();
                if (meteorEntry != null) {
                    double xLocOfDrop = player.func_226277_ct_() + (double)((Random.Default.nextBoolean() ? -1 : 1) * (Random.Default.nextInt(485) + 15));
                    double zLocOfDrop = player.func_226281_cx_() + (double)((Random.Default.nextBoolean() ? -1 : 1) * (Random.Default.nextInt(485) + 15));
                    World world = player.field_70170_p;
                    Intrinsics.checkNotNullExpressionValue(world, "player.level");
                    this.dropMeteor(world, meteorEntry, MathKt.roundToInt(xLocOfDrop), MathKt.roundToInt(zLocOfDrop));
                    int accuracy = playerBasics.getWatchedMeteorAccuracy();
                    Object[] objectArray = new Object[]{MathKt.roundToInt(xLocOfDrop += (double)((Random.Default.nextBoolean() ? -1 : 1) * Random.Default.nextInt(accuracy + 1))), MathKt.roundToInt(zLocOfDrop += (double)((Random.Default.nextBoolean() ? -1 : 1) * Random.Default.nextInt(accuracy + 1)))};
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.meteor.location", objectArray), player.func_110124_au());
                    playerBasics.setWatchedMeteor(null, 0, -1, -1, -1);
                    playerBasics.syncWatchedMeteor((PlayerEntity)player);
                } else {
                    logger.error("Player " + player.func_146103_bH().getName() + " had null meteor entry");
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.meteor.process.invalid_vals"), player.func_110124_au());
            }
        }
    }

    private final void dropMeteor(World world, MeteorEntry meteorEntry, int xPos, int zPos) {
        int yPos = 255;
        Block block = world.func_180495_p(new BlockPos(xPos, yPos, zPos)).func_177230_c();
        while (yPos > 0 && INVALID_TOP_BLOCKS.contains(block)) {
            int n = yPos;
            yPos = n + -1;
            block = world.func_180495_p(new BlockPos(xPos, yPos, zPos)).func_177230_c();
        }
        logger.info("Meteor dropped at " + xPos + ", " + yPos + ", " + zPos);
        if (yPos > 0) {
            int n;
            int radius = Random.Default.nextInt(meteorEntry.getMinRadius(), meteorEntry.getMaxRadius() + 1);
            int n2 = xPos - radius;
            if (n2 <= (n = xPos + radius)) {
                int x;
                do {
                    x = n2++;
                    int n3 = yPos - radius;
                    int n4 = yPos + radius;
                    if (n3 >= n4) continue;
                    do {
                        int z;
                        int y = n3++;
                        int n5 = zPos - radius;
                        int n6 = zPos + radius;
                        if (n5 > n6) continue;
                        do {
                            BlockPos blockPos;
                            Block existingBlock;
                            double distanceFromCenter;
                            if (!((distanceFromCenter = (double)((xPos - x) * (xPos - x) + (yPos - y) * (yPos - y)) + (double)((zPos - (z = n5++)) * (zPos - z))) < (double)(radius * radius)) || !REPLACEABLE_BLOCKS.contains(existingBlock = world.func_180495_p(blockPos = new BlockPos(x, y, z)).func_177230_c())) continue;
                            if (distanceFromCenter >= (double)((radius - 1) * (radius - 1)) || Math.random() > meteorEntry.getRichnessPercent()) {
                                world.func_175656_a(blockPos, ModBlocks.INSTANCE.getMETEOR().func_176223_P());
                                continue;
                            }
                            world.func_175656_a(blockPos, meteorEntry.getInteriorBlock().func_176223_P());
                        } while (z != n6);
                    } while (n3 < n4);
                } while (x != n);
            }
        } else {
            logger.error("Could not find a suitable y-level for the meteor at " + xPos + ", " + yPos);
        }
    }

    @Override
    public boolean processAsync() {
        return PacketProcessor.DefaultImpls.processAsync(this);
    }

    static {
        Block[] blockArray = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150353_l};
        INVALID_TOP_BLOCKS = SetsKt.setOf(blockArray);
        blockArray = new Block[]{ModBlocks.INSTANCE.getMETEOR(), Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_196658_i, Blocks.field_196645_X, Blocks.field_196642_W, Blocks.field_196648_Z, Blocks.field_196574_ab, Blocks.field_196647_Y, Blocks.field_196572_aa, Blocks.field_150354_m, Blocks.field_196621_O, Blocks.field_196619_M, Blocks.field_196623_P, Blocks.field_196620_N, Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_150395_bd, Blocks.field_196555_aI, Blocks.field_196804_gh, Blocks.field_150432_aD, Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150322_A, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150405_ch, Blocks.field_150435_aG, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_185774_da};
        REPLACEABLE_BLOCKS = SetsKt.setOf(blockArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/network/packets/other/ProcessSextantInputPacketProcessor$Companion;", "", "()V", "INVALID_TOP_BLOCKS", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "MAX_METEOR_DISTANCE", "", "REPLACEABLE_BLOCKS", "logger", "Lorg/apache/logging/log4j/Logger;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

