/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.crossbow;

import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.entity.bolt.BoltEntity;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.item.core.IHasModelProperties;
import com.davidm1a2.afraidofthedark.common.registry.BoltEntry;
import com.davidm1a2.afraidofthedark.common.utility.BoltOrderHelper;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001a\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00190\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0018\u0010%\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0016\u00a8\u0006-"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/CrossbowItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/IHasModelProperties;", "()V", "appendHoverText", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "fireBolt", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "itemStack", "getCurrentBoltType", "Lcom/davidm1a2/afraidofthedark/common/registry/BoltEntry;", "getCurrentBoltTypeIndex", "", "getProperties", "", "Lkotlin/Pair;", "Lnet/minecraft/util/ResourceLocation;", "Lnet/minecraft/item/IItemPropertyGetter;", "getUseDuration", "isLoaded", "", "onEntitySwing", "entityLiving", "Lnet/minecraft/entity/LivingEntity;", "onUsingTick", "entity", "count", "selectNextBoltType", "setLoaded", "use", "Lnet/minecraft/util/ActionResult;", "player", "hand", "Lnet/minecraft/util/Hand;", "Companion", "afraidofthedark"})
public final class CrossbowItem
extends AOTDItem
implements IHasModelProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int RELOAD_TIME = 40;
    @NotNull
    private static final String NBT_BOLT_TYPE = "bolt_type";
    @NotNull
    private static final String NBT_LOADED = "is_loaded";

    public CrossbowItem() {
        Item.Properties properties = new Item.Properties().func_200917_a(1);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().stacksTo(1)");
        super("crossbow", properties, false, 4, null);
    }

    @Override
    @NotNull
    public List<Pair<ResourceLocation, IItemPropertyGetter>> getProperties() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(new ResourceLocation("afraidofthedark", "charge_level"), (arg_0, arg_1, arg_2) -> CrossbowItem.getProperties$lambda-0(this, arg_0, arg_1, arg_2)), TuplesKt.to(new ResourceLocation("afraidofthedark", NBT_LOADED), (arg_0, arg_1, arg_2) -> CrossbowItem.getProperties$lambda-1(this, arg_0, arg_1, arg_2))};
        return CollectionsKt.listOf(pairArray);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_213453_ef()) {
                Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
                this.selectNextBoltType(itemStack, player);
            } else {
                Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
                if (!this.isLoaded(itemStack)) {
                    if (player.func_184812_l_() || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)this.getCurrentBoltType(itemStack).getItem()))) {
                        world.func_184133_a(null, player.func_233580_cy_(), ModSounds.INSTANCE.getCROSSBOW_LOAD(), SoundCategory.PLAYERS, 0.9f, world.field_73012_v.nextFloat() * 0.8f + 1.2f);
                        player.func_184598_c(hand);
                    } else {
                        objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(itemStack).getUnlocalizedName())};
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.crossbow.no_bolt", objectArray), player.func_110124_au());
                    }
                }
            }
        }
        objectArray = ActionResult.func_226251_d_((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue(objectArray, "fail(itemStack)");
        return objectArray;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull LivingEntity entity, int count) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (entity instanceof PlayerEntity && count == 2 && (((PlayerEntity)entity).func_184812_l_() || ItemStackHelper.func_233534_a_((IInventory)((IInventory)((PlayerEntity)entity).field_71071_by), arg_0 -> CrossbowItem.onUsingTick$lambda-2(this, stack, arg_0), (int)1, (boolean)false) == 1)) {
            this.setLoaded(stack, true);
        }
    }

    public boolean onEntitySwing(@NotNull ItemStack stack, @NotNull LivingEntity entityLiving) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entityLiving, "entityLiving");
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof PlayerEntity && this.isLoaded(stack)) {
            this.setLoaded(stack, false);
            PlayerEntity playerEntity = (PlayerEntity)entityLiving;
            World world = entityLiving.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "entityLiving.level");
            this.fireBolt(playerEntity, world, stack);
        }
        return super.onEntitySwing(stack, entityLiving);
    }

    private final void fireBolt(PlayerEntity entityPlayer, World world, ItemStack itemStack) {
        world.func_184133_a(null, entityPlayer.func_233580_cy_(), ModSounds.INSTANCE.getCROSSBOW_FIRE(), SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        BoltEntity bolt = this.getCurrentBoltType(itemStack).makeBoltEntity(world);
        bolt.setShotFrom((LivingEntity)entityPlayer);
        world.func_217376_c((Entity)bolt);
    }

    private final void selectNextBoltType(ItemStack itemStack, PlayerEntity entityPlayer) {
        if (!this.isLoaded(itemStack)) {
            int currentBoltTypeIndex = this.getCurrentBoltTypeIndex(itemStack);
            currentBoltTypeIndex = BoltOrderHelper.INSTANCE.getNextBoltIndex(entityPlayer, currentBoltTypeIndex);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, currentBoltTypeIndex);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                Object[] objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(itemStack).getUnlocalizedName())};
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.crossbow.bolt_change", objectArray), entityPlayer.func_110124_au());
            }
        }
    }

    private final BoltEntry getCurrentBoltType(ItemStack itemStack) {
        return BoltOrderHelper.INSTANCE.getBoltAt(this.getCurrentBoltTypeIndex(itemStack));
    }

    private final int getCurrentBoltTypeIndex(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_BOLT_TYPE)) {
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, 0);
        }
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_BOLT_TYPE);
        Intrinsics.checkNotNull(n);
        return n;
    }

    private final void setLoaded(ItemStack itemStack, boolean isLoaded) {
        NBTHelper.INSTANCE.setBoolean(itemStack, NBT_LOADED, isLoaded);
    }

    private final boolean isLoaded(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LOADED)) {
            this.setLoaded(itemStack, false);
        }
        Boolean bl = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_LOADED);
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        if (ModRegistries.INSTANCE.getBOLTS().isEmpty()) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.change_bolt"));
        Object[] objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(stack).getUnlocalizedName())};
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.fire_bolt_type", objectArray));
        if (this.isLoaded(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.loaded"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.unloaded"));
        }
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 40;
    }

    private static final float getProperties$lambda-0(CrossbowItem this$0, ItemStack stack, World $noName_1, LivingEntity entity) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (entity instanceof PlayerEntity && Intrinsics.areEqual(((PlayerEntity)entity).field_71071_by.field_70462_a.get(((PlayerEntity)entity).field_71071_by.field_70461_c), stack)) {
            return (float)((PlayerEntity)entity).func_184607_cu().func_77988_m() / (float)this$0.func_77626_a(stack);
        }
        return 0.0f;
    }

    private static final float getProperties$lambda-1(CrossbowItem this$0, ItemStack stack, World $noName_1, LivingEntity $noName_2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this$0.isLoaded(stack) ? 1.0f : 0.0f;
    }

    private static final boolean onUsingTick$lambda-2(CrossbowItem this$0, ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($stack, "$stack");
        return Intrinsics.areEqual(it.func_77973_b(), this$0.getCurrentBoltType($stack).getItem());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/CrossbowItem$Companion;", "", "()V", "NBT_BOLT_TYPE", "", "NBT_LOADED", "RELOAD_TIME", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

