/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModArmorMaterials;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDArmorItem;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\nH\u0002\u00a8\u0006'"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalArmorItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDArmorItem;", "baseName", "", "equipmentSlot", "Lnet/minecraft/inventory/EquipmentSlotType;", "(Ljava/lang/String;Lnet/minecraft/inventory/EquipmentSlotType;)V", "appendHoverText", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getArmorTexture", "entity", "Lnet/minecraft/entity/Entity;", "slot", "type", "getRatio", "", "onArmorTick", "itemStack", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "processDamage", "Lnet/minecraft/entity/LivingEntity;", "armorStack", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "readyToProcAbsorption", "", "Companion", "afraidofthedark"})
public final class StarMetalArmorItem
extends AOTDArmorItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_LAST_ABSORPTION_PROC = "last_absorption_proc";
    private static final int ABSORPTION_PROC_CD_MILLIS = 120000;
    private static final int ABSORPTION_PER_PIECE = 4;
    @NotNull
    private static final Set<DamageSource> TRUE_DAMAGE_SOURCES;

    public StarMetalArmorItem(@NotNull String baseName, @NotNull EquipmentSlotType equipmentSlot) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(equipmentSlot, "equipmentSlot");
        IArmorMaterial iArmorMaterial = ModArmorMaterials.INSTANCE.getSTAR_METAL();
        Item.Properties properties = new Item.Properties().func_200915_b(0);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().defaultDurability(0)");
        super(baseName, iArmorMaterial, equipmentSlot, properties, false, 16, null);
    }

    @NotNull
    public String getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlotType slot, @Nullable String type) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(slot, "slot");
        return slot == EquipmentSlotType.LEGS ? "afraidofthedark:textures/armor/star_metal_2.png" : "afraidofthedark:textures/armor/star_metal_1.png";
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.magic_armor_never_breaks"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.star_metal_armor.effect"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.dont_know_how_to_use"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onArmorTick(@NotNull ItemStack itemStack, @NotNull World world, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        if (player.func_70089_S() && CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getSTAR_METAL()) && this.readyToProcAbsorption(itemStack)) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            Object object = player.field_71071_by.field_70460_b;
            Intrinsics.checkNotNullExpressionValue(object, "player.inventory.armor");
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ItemStack itemStack2 = (ItemStack)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Item item = it.func_77973_b();
                collection.add(item);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof StarMetalArmorItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            boolean bl = false;
            int numberStarMetalPiecesWorn = object.size();
            if ((float)(numberStarMetalPiecesWorn * 4) >= player.func_110139_bj()) {
                player.func_110149_m(RangesKt.coerceIn(player.func_110139_bj() + (float)4, 0.0f, (float)numberStarMetalPiecesWorn * 4.0f));
            }
            NBTHelper.INSTANCE.setLong(itemStack, NBT_LAST_ABSORPTION_PROC, System.currentTimeMillis());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean readyToProcAbsorption(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LAST_ABSORPTION_PROC)) return true;
        long l = System.currentTimeMillis();
        Long l2 = NBTHelper.INSTANCE.getLong(itemStack, NBT_LAST_ABSORPTION_PROC);
        Intrinsics.checkNotNull(l2);
        if (l <= l2 + (long)120000) return false;
        return true;
    }

    @Override
    public double processDamage(@NotNull LivingEntity entity, @NotNull ItemStack armorStack, @NotNull DamageSource source, float amount, @NotNull EquipmentSlotType slot) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(armorStack, "armorStack");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(slot, "slot");
        if (!(entity instanceof PlayerEntity)) {
            return 0.0;
        }
        if (!CapabilityExtensionsKt.getResearch((PlayerEntity)entity).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            return 0.0;
        }
        if (TRUE_DAMAGE_SOURCES.contains(source)) {
            return 0.0;
        }
        double protectionRatio = this.getRatio(slot);
        if (Intrinsics.areEqual(source, DamageSource.field_76379_h)) {
            return protectionRatio * 0.8;
        }
        if (Intrinsics.areEqual(source, DamageSource.field_76371_c)) {
            return protectionRatio * 0.8;
        }
        return protectionRatio * 0.95;
    }

    private final double getRatio(EquipmentSlotType slot) {
        double d;
        int totalProtection = 20;
        EquipmentSlotType equipmentSlotType = slot;
        int n = WhenMappings.$EnumSwitchMapping$0[equipmentSlotType.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                d = 3.0 / (double)totalProtection;
                break;
            }
            case 3: {
                d = 6.0 / (double)totalProtection;
                break;
            }
            case 4: {
                d = 8.0 / (double)totalProtection;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    static {
        DamageSource[] damageSourceArray = new DamageSource[]{DamageSource.field_76369_e, DamageSource.field_76368_d, DamageSource.field_76380_i, DamageSource.field_76366_f};
        TRUE_DAMAGE_SOURCES = SetsKt.setOf(damageSourceArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalArmorItem$Companion;", "", "()V", "ABSORPTION_PER_PIECE", "", "ABSORPTION_PROC_CD_MILLIS", "NBT_LAST_ABSORPTION_PROC", "", "TRUE_DAMAGE_SOURCES", "", "Lnet/minecraft/util/DamageSource;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlotType.values().length];
            nArray[EquipmentSlotType.HEAD.ordinal()] = 1;
            nArray[EquipmentSlotType.FEET.ordinal()] = 2;
            nArray[EquipmentSlotType.LEGS.ordinal()] = 3;
            nArray[EquipmentSlotType.CHEST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

