/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDPerItemCooldownItem;
import com.davidm1a2.afraidofthedark.common.item.core.IHasModelProperties;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019H\u0016J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u001bJ8\u0010#\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0016\u00a8\u0006/"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/FlaskOfSoulsItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDPerItemCooldownItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/IHasModelProperties;", "()V", "addKills", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "kills", "", "appendHoverText", "stack", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getCooldownInMilliseconds", "getDurabilityForDisplay", "", "getKills", "getKillsRequired", "getProperties", "", "Lkotlin/Pair;", "Lnet/minecraft/util/ResourceLocation;", "Lnet/minecraft/item/IItemPropertyGetter;", "getSpawnedEntity", "isComplete", "", "setKills", "setSpawnedEntity", "entity", "spawnEntity", "x", "y", "z", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "use", "Lnet/minecraft/util/ActionResult;", "player", "hand", "Lnet/minecraft/util/Hand;", "Companion", "afraidofthedark"})
public final class FlaskOfSoulsItem
extends AOTDPerItemCooldownItem
implements IHasModelProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();
    @NotNull
    public static final String NBT_FLASK_TYPE = "flask_type";
    @NotNull
    public static final String NBT_FLASK_KILLS = "flask_kills";
    public static final int DEFAULT_KILLS_REQUIRED = 32;
    public static final int KILLS_PER_SPAWN = 4;
    public static final int FLASK_POWER = 300;
    @NotNull
    private static final Map<ResourceLocation, Integer> ENTITY_TO_KILLS_REQUIRED;
    private static final int DEFAULT_COOLDOWN = 60000;
    @NotNull
    private static final Map<Integer, Integer> KILL_COUNT_TO_COOLDOWN;

    public FlaskOfSoulsItem() {
        super("flask_of_souls", new Item.Properties(), false, 4, null);
    }

    @Override
    @NotNull
    public List<Pair<ResourceLocation, IItemPropertyGetter>> getProperties() {
        return CollectionsKt.listOf(TuplesKt.to(new ResourceLocation("afraidofthedark", "complete"), (arg_0, arg_1, arg_2) -> FlaskOfSoulsItem.getProperties$lambda-0(this, arg_0, arg_1, arg_2)));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
                RayTraceResult rayTraceResult = (RayTraceResult)Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
                if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos hitPos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
                    Direction hitFace = ((BlockRayTraceResult)rayTraceResult).func_216354_b();
                    BlockPos spawnPos = hitPos.func_177972_a(hitFace);
                    if (world.func_175660_a(player, hitPos) && player.func_175151_a(hitPos, hitFace, itemStack)) {
                        double d = (double)spawnPos.func_177958_n() + 0.5;
                        double d2 = (double)spawnPos.func_177956_o() + 0.5;
                        double d3 = (double)spawnPos.func_177952_p() + 0.5;
                        Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
                        this.spawnEntity(world, d, d2, d3, itemStack, player);
                    }
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dont_understand"), player.func_110124_au());
            }
        }
        ActionResult actionResult = ActionResult.func_226248_a_((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue(actionResult, "success(itemStack)");
        return actionResult;
    }

    private final void spawnEntity(World world, double x, double y, double z, ItemStack itemStack, PlayerEntity entityPlayer) {
        if (!world.field_72995_K) {
            if (this.getKills(itemStack) >= 4) {
                if (!this.isOnCooldown(itemStack)) {
                    ResourceLocation entityToSpawnID = this.getSpawnedEntity(itemStack);
                    if (entityToSpawnID != null) {
                        Entity entity = EntityType.func_220327_a((String)entityToSpawnID.toString()).map(arg_0 -> FlaskOfSoulsItem.spawnEntity$lambda-1(world, arg_0)).orElse(null);
                        if (entity != null) {
                            entity.func_70012_b(x, y, z, (float)Random.Default.nextDouble(0.0, 360.0), 0.0f);
                            world.func_217376_c(entity);
                            this.setOnCooldown(itemStack, entityPlayer);
                            this.addKills(itemStack, -4);
                        } else {
                            logger.error(Intrinsics.stringPlus("Unknown entity: ", entityToSpawnID));
                        }
                    }
                } else {
                    Object[] objectArray = new Object[]{this.cooldownRemainingInSeconds(itemStack)};
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.flask_of_souls.on_cooldown", objectArray), entityPlayer.func_110124_au());
                }
            } else {
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.flask_of_souls.incomplete"), entityPlayer.func_110124_au());
            }
        }
    }

    @Override
    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getSpawnedEntity(stack) == null ? 1.0 : 1.0 - (double)this.getKills(stack) / (double)this.getKillsRequired(stack);
    }

    @Override
    public int getCooldownInMilliseconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Integer n = KILL_COUNT_TO_COOLDOWN.get(this.getKillsRequired(itemStack));
        return n == null ? 60000 : n;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(ModResearches.INSTANCE.getPHYLACTERY_OF_SOULS())) {
            if (this.getSpawnedEntity(stack) == null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.flask_of_souls.empty.line1"));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.flask_of_souls.empty.line2"));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.flask_of_souls.empty.line3"));
            } else {
                Object[] objectArray = new Object[1];
                ResourceLocation resourceLocation = this.getSpawnedEntity(stack);
                Intrinsics.checkNotNull(resourceLocation);
                objectArray[0] = ((EntityType)EntityType.func_220327_a((String)resourceLocation.toString()).get()).func_212546_e();
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.flask_of_souls.incomplete.line1", objectArray));
                objectArray = new Object[]{this.getKills(stack), this.getKillsRequired(stack)};
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.flask_of_souls.incomplete.line2", objectArray));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.dont_know_how_to_use"));
        }
    }

    public final int getKillsRequired(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Integer n = ENTITY_TO_KILLS_REQUIRED.get(this.getSpawnedEntity(stack));
        return n == null ? 32 : n;
    }

    public final boolean isComplete(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getKills(stack) == this.getKillsRequired(stack);
    }

    public final void addKills(@NotNull ItemStack itemStack, int kills) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        int currentKills = this.getKills(itemStack);
        ResourceLocation spawnedEntity = this.getSpawnedEntity(itemStack);
        if (spawnedEntity != null) {
            int killsRequired = this.getKillsRequired(itemStack);
            currentKills = RangesKt.coerceIn(currentKills + kills, 0, killsRequired);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_FLASK_KILLS, currentKills);
        }
    }

    public final void setKills(@NotNull ItemStack itemStack, int kills) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        ResourceLocation spawnedEntity = this.getSpawnedEntity(itemStack);
        if (spawnedEntity != null) {
            int killsRequired = this.getKillsRequired(itemStack);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_FLASK_KILLS, RangesKt.coerceIn(kills, 0, killsRequired));
        }
    }

    public final int getKills(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_FLASK_KILLS)) {
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_FLASK_KILLS, 0);
        }
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_FLASK_KILLS);
        Intrinsics.checkNotNull(n);
        return n;
    }

    public final void setSpawnedEntity(@NotNull ItemStack itemStack, @Nullable ResourceLocation entity) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (entity != null) {
            String string = entity.toString();
            Intrinsics.checkNotNullExpressionValue(string, "entity.toString()");
            NBTHelper.INSTANCE.setString(itemStack, NBT_FLASK_TYPE, string);
        } else {
            NBTHelper.INSTANCE.removeTag(itemStack, NBT_FLASK_TYPE);
        }
    }

    @Nullable
    public final ResourceLocation getSpawnedEntity(@NotNull ItemStack itemStack) {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_FLASK_TYPE)) {
            String string = NBTHelper.INSTANCE.getString(itemStack, NBT_FLASK_TYPE);
            Intrinsics.checkNotNull(string);
            ResourceLocation resourceLocation2 = new ResourceLocation(string);
            resourceLocation = resourceLocation2;
        } else {
            resourceLocation = null;
        }
        return resourceLocation;
    }

    private static final float getProperties$lambda-0(FlaskOfSoulsItem this$0, ItemStack stack, ClientWorld $noName_1, LivingEntity $noName_2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(stack, "stack");
        return this$0.isComplete(stack) ? 1.0f : 0.0f;
    }

    private static final Entity spawnEntity$lambda-1(World $world, EntityType it) {
        Intrinsics.checkNotNullParameter($world, "$world");
        return it.func_200721_a($world);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(ModEntities.INSTANCE.getWEREWOLF().getRegistryName(), 8), TuplesKt.to(ModEntities.INSTANCE.getENCHANTED_FROG().getRegistryName(), 8), TuplesKt.to(new ResourceLocation("enderman"), 16), TuplesKt.to(new ResourceLocation("zombie_pigman"), 16), TuplesKt.to(new ResourceLocation("blaze"), 16), TuplesKt.to(new ResourceLocation("magma_cube"), 16), TuplesKt.to(new ResourceLocation("witch"), 16)};
        ENTITY_TO_KILLS_REQUIRED = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(8, 120000), TuplesKt.to(16, 60000), TuplesKt.to(32, 30000)};
        KILL_COUNT_TO_COOLDOWN = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/FlaskOfSoulsItem$Companion;", "", "()V", "DEFAULT_COOLDOWN", "", "DEFAULT_KILLS_REQUIRED", "ENTITY_TO_KILLS_REQUIRED", "", "Lnet/minecraft/util/ResourceLocation;", "getENTITY_TO_KILLS_REQUIRED", "()Ljava/util/Map;", "FLASK_POWER", "KILLS_PER_SPAWN", "KILL_COUNT_TO_COOLDOWN", "NBT_FLASK_KILLS", "", "NBT_FLASK_TYPE", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ResourceLocation, Integer> getENTITY_TO_KILLS_REQUIRED() {
            return ENTITY_TO_KILLS_REQUIRED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

