/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.tree;

import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.feature.tree.AOTDTreeFeature;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JD\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JL\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/tree/MangroveTreeFeature;", "Lcom/davidm1a2/afraidofthedark/common/feature/tree/AOTDTreeFeature;", "()V", "generateBase", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/gen/IWorldGenerationReader;", "random", "Ljava/util/Random;", "pos", "logPositions", "", "boundingBox", "Lnet/minecraft/util/math/MutableBoundingBox;", "generateBranches", "", "topOfTrunk", "leafPositions", "generateLeafCluster", "location", "place", "Lnet/minecraft/world/ISeedReader;", "chunkGenerator", "Lnet/minecraft/world/gen/ChunkGenerator;", "blockPos", "afraidofthedark"})
public final class MangroveTreeFeature
extends AOTDTreeFeature {
    public MangroveTreeFeature() {
        Object object = ModBlocks.INSTANCE.getMANGROVE().func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
        Intrinsics.checkNotNullExpressionValue(object, "ModBlocks.MANGROVE.defaultBlockState().setValue(RotatedPillarBlock.AXIS, Direction.Axis.Y)");
        BlockState blockState = (BlockState)object;
        object = ModBlocks.INSTANCE.getMANGROVE_LEAVES().func_176223_P();
        Intrinsics.checkNotNullExpressionValue(object, "ModBlocks.MANGROVE_LEAVES.defaultBlockState()");
        super(blockState, (BlockState)object);
        this.setRegistryName("afraidofthedark", "mangrove_tree");
    }

    @Override
    public void place(@NotNull ISeedReader world, @NotNull ChunkGenerator chunkGenerator, @NotNull Random random, @NotNull BlockPos blockPos, @NotNull Set<BlockPos> logPositions, @NotNull Set<BlockPos> leafPositions, @NotNull MutableBoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(chunkGenerator, "chunkGenerator");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(logPositions, "logPositions");
        Intrinsics.checkNotNullParameter(leafPositions, "leafPositions");
        Intrinsics.checkNotNullParameter(boundingBox, "boundingBox");
        BlockPos topOfTrunk = this.generateBase((IWorldGenerationReader)world, random, blockPos, logPositions, boundingBox);
        this.generateBranches((IWorldGenerationReader)world, topOfTrunk, random, logPositions, leafPositions, boundingBox);
    }

    private final BlockPos generateBase(IWorldGenerationReader world, Random random, BlockPos pos, Set<BlockPos> logPositions, MutableBoundingBox boundingBox) {
        int heightBeforeTrunk = random.nextInt(4) + 4;
        int n = 0;
        int numRoots = random.nextInt(5) + 4;
        if (n < numRoots) {
            do {
                int i = n++;
                Direction xOffsetDirection = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                Direction zOffsetDirection = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                int xDistanceFromTrunk = random.nextInt(3) + 3;
                int zDistanceFromTrunk = random.nextInt(3) + 3;
                BlockPos currentPos = pos.func_177967_a(xOffsetDirection, xDistanceFromTrunk).func_177967_a(zOffsetDirection, zDistanceFromTrunk);
                int n2 = 0;
                if (n2 < heightBeforeTrunk) {
                    do {
                        int n3;
                        int j = n2++;
                        if (xDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                            n3 = xDistanceFromTrunk;
                            xDistanceFromTrunk = n3 + -1;
                        }
                        if (zDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                            n3 = zDistanceFromTrunk;
                            zDistanceFromTrunk = n3 + -1;
                        }
                        BlockPos blockPos = currentPos;
                        Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
                        this.setLog(world, blockPos, logPositions, boundingBox);
                        if (random.nextDouble() < 0.1) {
                            blockPos = random.nextBoolean() ? currentPos.func_177984_a() : currentPos.func_177977_b();
                            Intrinsics.checkNotNullExpressionValue(blockPos, "if (random.nextBoolean()) currentPos.above() else currentPos.below()");
                            this.setLog(world, blockPos, logPositions, boundingBox);
                        }
                        currentPos = currentPos.func_177984_a();
                    } while (n2 < heightBeforeTrunk);
                }
                while (xDistanceFromTrunk > 0 || zDistanceFromTrunk > 0) {
                    if (xDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                        n2 = xDistanceFromTrunk;
                        xDistanceFromTrunk = n2 + -1;
                    }
                    if (zDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                        n2 = zDistanceFromTrunk;
                        zDistanceFromTrunk = n2 + -1;
                    }
                    BlockPos blockPos = currentPos;
                    Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
                    this.setLog(world, blockPos, logPositions, boundingBox);
                }
            } while (n < numRoots);
        }
        int trunkHeight = random.nextInt(4) + 6;
        BlockPos currentPos = pos.func_177981_b(heightBeforeTrunk);
        int n4 = 0;
        if (n4 < trunkHeight) {
            do {
                int i = n4++;
                if (random.nextDouble() < 0.1) {
                    currentPos = currentPos.func_177972_a(Direction.func_176731_b((int)random.nextInt(4)));
                }
                BlockPos blockPos = currentPos;
                Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
                this.setLog(world, blockPos, logPositions, boundingBox);
                currentPos = currentPos.func_177984_a();
            } while (n4 < trunkHeight);
        }
        BlockPos blockPos = currentPos;
        Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
        return blockPos;
    }

    private final void generateBranches(IWorldGenerationReader world, BlockPos topOfTrunk, Random random, Set<BlockPos> logPositions, Set<BlockPos> leafPositions, MutableBoundingBox boundingBox) {
        this.generateLeafCluster(world, random, topOfTrunk, logPositions, leafPositions, boundingBox);
        int numBranches = random.nextInt(3) + 3;
        int n = 0;
        if (n < numBranches) {
            do {
                int i = n++;
                Direction branchDir1 = Direction.func_176731_b((int)random.nextInt(4));
                Direction branchDir2 = random.nextBoolean() ? branchDir1.func_176746_e() : branchDir1.func_176735_f();
                int branchLength = random.nextInt(5) + 3;
                BlockPos currentBranchPos = topOfTrunk.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                int n2 = 0;
                if (n2 < branchLength) {
                    do {
                        int j = n2++;
                        BlockPos blockPos = currentBranchPos;
                        Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                        this.setLog(world, blockPos, logPositions, boundingBox);
                        if (random.nextDouble() < 0.1) {
                            blockPos = currentBranchPos;
                            Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                            this.generateLeafCluster(world, random, blockPos, logPositions, leafPositions, boundingBox);
                        }
                        currentBranchPos = currentBranchPos.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                        if (!(random.nextDouble() < 0.2)) continue;
                        currentBranchPos = currentBranchPos.func_177984_a();
                    } while (n2 < branchLength);
                }
                BlockPos blockPos = currentBranchPos;
                Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                this.generateLeafCluster(world, random, blockPos, logPositions, leafPositions, boundingBox);
            } while (n < numBranches);
        }
    }

    private final void generateLeafCluster(IWorldGenerationReader world, Random random, BlockPos location, Set<BlockPos> logPositions, Set<BlockPos> leafPositions, MutableBoundingBox boundingBox) {
        this.setLog(world, location, logPositions, boundingBox);
        int n = -2;
        do {
            int x = n++;
            int n2 = -1;
            do {
                int y = n2++;
                int n3 = -2;
                do {
                    int z = n3++;
                    BlockPos leafPos = location.func_177982_a(x, y, z);
                    double d = leafPos.func_177951_i((Vector3i)location);
                    boolean bl = false;
                    double d2 = Math.sqrt(d);
                    double d3 = y == 0 ? 2.5 : 2.0;
                    if (!(d2 < d3) || !(random.nextDouble() < 0.9)) continue;
                    if (random.nextDouble() < 0.03) {
                        int i;
                        Intrinsics.checkNotNullExpressionValue(leafPos, "leafPos");
                        this.setLog(world, leafPos, logPositions, boundingBox);
                        int vineLength = random.nextInt(3) + 2;
                        int n4 = 1;
                        if (n4 > vineLength) continue;
                        do {
                            i = n4++;
                            BlockPos blockPos = leafPos.func_177979_c(i);
                            Intrinsics.checkNotNullExpressionValue(blockPos, "leafPos.below(i)");
                            this.setLeaf(world, blockPos, leafPositions, boundingBox);
                        } while (i != vineLength);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue(leafPos, "leafPos");
                    this.setLeaf(world, leafPos, leafPositions, boundingBox);
                } while (n3 <= 2);
            } while (n2 <= 1);
        } while (n <= 2);
    }
}

