/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.tree;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.template.Template;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0014\u001a\u00020\u0015H&J0\u0010\u0007\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J.\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J.\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J4\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/tree/AOTDTreeFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lnet/minecraft/world/gen/feature/BaseTreeFeatureConfig;", "log", "Lnet/minecraft/block/BlockState;", "leaves", "(Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V", "place", "", "world", "Lnet/minecraft/world/ISeedReader;", "chunkGenerator", "Lnet/minecraft/world/gen/ChunkGenerator;", "random", "Ljava/util/Random;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "logPositions", "", "leafPositions", "boundingBox", "Lnet/minecraft/util/math/MutableBoundingBox;", "", "ignored", "setLeaf", "Lnet/minecraft/world/gen/IWorldGenerationReader;", "setLog", "updateLeaves", "Lnet/minecraft/world/IWorld;", "", "afraidofthedark"})
public abstract class AOTDTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    @NotNull
    private final BlockState log;
    @NotNull
    private final BlockState leaves;

    public AOTDTreeFeature(@NotNull BlockState log, @NotNull BlockState leaves) {
        Intrinsics.checkNotNullParameter(log, "log");
        Intrinsics.checkNotNullParameter(leaves, "leaves");
        super(BaseTreeFeatureConfig.field_236676_a_);
        this.log = log;
        this.leaves = leaves;
    }

    public boolean place(@NotNull ISeedReader world, @NotNull ChunkGenerator chunkGenerator, @NotNull Random random, @NotNull BlockPos blockPos, @NotNull BaseTreeFeatureConfig ignored) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(chunkGenerator, "chunkGenerator");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(ignored, "ignored");
        boolean bl = false;
        Set logPositions = new LinkedHashSet();
        boolean bl2 = false;
        Set leafPositions = new LinkedHashSet();
        MutableBoundingBox boundingBox = MutableBoundingBox.func_78887_a();
        Intrinsics.checkNotNullExpressionValue(boundingBox, "boundingBox");
        this.place(world, chunkGenerator, random, blockPos, logPositions, leafPositions, boundingBox);
        this.updateLeaves((IWorld)world, boundingBox, logPositions, leafPositions);
        return true;
    }

    public abstract void place(@NotNull ISeedReader var1, @NotNull ChunkGenerator var2, @NotNull Random var3, @NotNull BlockPos var4, @NotNull Set<BlockPos> var5, @NotNull Set<BlockPos> var6, @NotNull MutableBoundingBox var7);

    protected final void setLog(@NotNull IWorldGenerationReader world, @NotNull BlockPos blockPos, @NotNull Set<BlockPos> logPositions, @NotNull MutableBoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(logPositions, "logPositions");
        Intrinsics.checkNotNullParameter(boundingBox, "boundingBox");
        this.func_230367_a_((IWorldWriter)world, blockPos, this.log);
        logPositions.add(blockPos);
        boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
    }

    protected final void setLeaf(@NotNull IWorldGenerationReader world, @NotNull BlockPos blockPos, @NotNull Set<BlockPos> leafPositions, @NotNull MutableBoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(leafPositions, "leafPositions");
        Intrinsics.checkNotNullParameter(boundingBox, "boundingBox");
        this.func_230367_a_((IWorldWriter)world, blockPos, this.leaves);
        leafPositions.add(blockPos);
        boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLeaves(IWorld world, MutableBoundingBox boundingBox, Set<? extends BlockPos> logPositions, Set<? extends BlockPos> leafPositions) {
        void var8_13;
        int n = 6;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Set> arrayList = new ArrayList<Set>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<Set> arrayList2 = arrayList;
            boolean bl5 = false;
            boolean bl6 = false;
            Set set = new LinkedHashSet();
            arrayList2.add(set);
        }
        List leafCheckIterationSets = arrayList;
        BitSetVoxelShapePart voxelShape = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        for (BlockPos blockPos : leafPositions) {
            if (!boundingBox.func_175898_b((Vector3i)blockPos)) continue;
            voxelShape.func_199625_a(blockPos.func_177958_n() - boundingBox.field_78897_a, blockPos.func_177956_o() - boundingBox.field_78895_b, blockPos.func_177952_p() - boundingBox.field_78896_c, true, true);
        }
        BlockPos.Mutable tempBlockPos = new BlockPos.Mutable();
        for (BlockPos blockPos : logPositions) {
            if (boundingBox.func_175898_b((Vector3i)blockPos)) {
                voxelShape.func_199625_a(blockPos.func_177958_n() - boundingBox.field_78897_a, blockPos.func_177956_o() - boundingBox.field_78895_b, blockPos.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockNextToLog;
                tempBlockPos.func_239622_a_((Vector3i)blockPos, direction);
                if (logPositions.contains(tempBlockPos) || !(blockNextToLog = world.func_180495_p((BlockPos)tempBlockPos)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                Set set = (Set)leafCheckIterationSets.get(0);
                BlockPos blockPos2 = tempBlockPos.func_185334_h();
                Intrinsics.checkNotNullExpressionValue(blockPos2, "tempBlockPos.immutable()");
                set.add(blockPos2);
                TreeFeature.func_236408_b_((IWorldWriter)((IWorldWriter)world), (BlockPos)((BlockPos)tempBlockPos), (BlockState)((BlockState)blockNextToLog.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1))));
                if (!boundingBox.func_175898_b((Vector3i)tempBlockPos)) continue;
                voxelShape.func_199625_a(tempBlockPos.func_177958_n() - boundingBox.field_78897_a, tempBlockPos.func_177956_o() - boundingBox.field_78895_b, tempBlockPos.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
        }
        boolean n6 = true;
        do {
            void var9_17 = var8_13++;
            Set currentSet = (Set)leafCheckIterationSets.get((int)(var9_17 - true));
            Set nextSet = (Set)leafCheckIterationSets.get((int)var9_17);
            for (BlockPos blockPos : currentSet) {
                if (boundingBox.func_175898_b((Vector3i)blockPos)) {
                    voxelShape.func_199625_a(blockPos.func_177958_n() - boundingBox.field_78897_a, blockPos.func_177956_o() - boundingBox.field_78895_b, blockPos.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                Direction[] directionArray = Direction.values();
                int n7 = 0;
                int n8 = directionArray.length;
                while (n7 < n8) {
                    BlockState leafState;
                    Direction direction = directionArray[n7];
                    ++n7;
                    tempBlockPos.func_239622_a_((Vector3i)blockPos, direction);
                    if (currentSet.contains(tempBlockPos) || nextSet.contains(tempBlockPos) || !(leafState = world.func_180495_p((BlockPos)tempBlockPos)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                    Integer distance = (Integer)leafState.func_177229_b((Property)BlockStateProperties.field_208514_aa);
                    Intrinsics.checkNotNullExpressionValue(distance, "distance");
                    if (distance <= var9_17 + true) continue;
                    BlockState newLeafState = (BlockState)leafState.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf((int)(var9_17 + true)));
                    TreeFeature.func_236408_b_((IWorldWriter)((IWorldWriter)world), (BlockPos)((BlockPos)tempBlockPos), (BlockState)newLeafState);
                    if (boundingBox.func_175898_b((Vector3i)tempBlockPos)) {
                        voxelShape.func_199625_a(tempBlockPos.func_177958_n() - boundingBox.field_78897_a, tempBlockPos.func_177956_o() - boundingBox.field_78895_b, tempBlockPos.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    BlockPos blockPos3 = tempBlockPos.func_185334_h();
                    Intrinsics.checkNotNullExpressionValue(blockPos3, "tempBlockPos.immutable()");
                    nextSet.add(blockPos3);
                }
            }
        } while (var8_13 <= 5);
        Template.func_222857_a((IWorld)world, (int)3, (VoxelShapePart)((VoxelShapePart)voxelShape), (int)boundingBox.field_78897_a, (int)boundingBox.field_78895_b, (int)boundingBox.field_78896_c);
    }
}

