/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.structure.darkforest;

import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructureStart;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.MultiplierConfig;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.SchematicStructurePiece;
import com.davidm1a2.afraidofthedark.common.schematic.Schematic;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u001c\u0010\u0014\u001a\u00020\u0006*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/darkforest/DarkForestStructureStart;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/AOTDStructureStart;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/MultiplierConfig;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "chunkX", "", "chunkZ", "boundsIn", "Lnet/minecraft/util/math/MutableBoundingBox;", "referenceIn", "seed", "", "(Lnet/minecraft/world/gen/feature/structure/Structure;IILnet/minecraft/util/math/MutableBoundingBox;IJ)V", "init", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "xPos", "zPos", "nextInt", "Ljava/util/Random;", "min", "max", "Companion", "afraidofthedark"})
public final class DarkForestStructureStart
extends AOTDStructureStart<MultiplierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MIN_PROPS = 35;
    private static final int MAX_PROPS = 75;
    private static final int MIN_TREES = 14;
    private static final int MAX_TREES = 20;

    public DarkForestStructureStart(@NotNull Structure<MultiplierConfig> structure, int chunkX, int chunkZ, @NotNull MutableBoundingBox boundsIn, int referenceIn, long seed) {
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(boundsIn, "boundsIn");
        super(structure, chunkX, chunkZ, boundsIn, referenceIn, seed);
    }

    @Override
    public void init(@NotNull ChunkGenerator generator, int xPos, int zPos) {
        int cornerHeight1;
        Intrinsics.checkNotNullParameter(generator, "generator");
        short bedHouseWidth = ModSchematics.INSTANCE.getBED_HOUSE().getWidth();
        short bedHouseLength = ModSchematics.INSTANCE.getBED_HOUSE().getLength();
        Structure structure = this.func_214627_k();
        if (structure == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructure<*>");
        }
        AOTDStructure darkForest = (AOTDStructure)structure;
        Integer n = SequencesKt.minOrNull(darkForest.getEdgeHeights$afraidofthedark(xPos, zPos, generator, bedHouseWidth, bedHouseLength));
        Intrinsics.checkNotNull(n);
        int yPos = n - 1;
        int width = darkForest.getWidth();
        int length = darkForest.getLength();
        int topGutterWidth = (length - bedHouseLength) / 2;
        int bottomGutterWidth = (length - bedHouseLength) / 2;
        int leftGutterWidth = (width - bedHouseWidth) / 2;
        int rightGutterWidth = (width - bedHouseWidth) / 2;
        int n2 = xPos - bedHouseWidth / 2;
        int n3 = zPos - bedHouseLength / 2;
        SharedSeedRandom sharedSeedRandom = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "random");
        this.field_75075_a.add(new SchematicStructurePiece(n2, yPos, n3, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getBED_HOUSE(), ModLootTables.INSTANCE.getDARK_FOREST(), null, 64, null));
        SharedSeedRandom sharedSeedRandom2 = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom2, "random");
        int numProps = this.nextInt((Random)sharedSeedRandom2, 35, 75);
        int n4 = 0;
        if (n4 <= numProps) {
            int ignored;
            do {
                Pair<Integer, Integer> pair;
                ignored = n4++;
                Schematic propSchematic = ModSchematics.INSTANCE.getDARK_FOREST_PROPS()[this.field_214631_d.nextInt(ModSchematics.INSTANCE.getDARK_FOREST_PROPS().length)];
                short s = propSchematic.getWidth();
                short s2 = propSchematic.getHeight();
                boolean bl = false;
                int widthLengthMax = Math.max(s, s2);
                Direction gutter = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
                Direction direction = gutter;
                int n5 = direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
                switch (n5) {
                    case 1: {
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        Integer n6 = xPos + this.nextInt((Random)sharedSeedRandom3, -width / 2, width / 2 - widthLengthMax);
                        int n7 = zPos - bedHouseLength / 2;
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        pair = new Pair<Integer, Integer>(n6, n7 - this.nextInt((Random)sharedSeedRandom3, widthLengthMax, topGutterWidth));
                        break;
                    }
                    case 2: {
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        Integer n8 = xPos + this.nextInt((Random)sharedSeedRandom3, -width / 2, width / 2 - widthLengthMax);
                        int n9 = zPos + bedHouseLength / 2;
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        pair = new Pair<Integer, Integer>(n8, n9 + this.nextInt((Random)sharedSeedRandom3, 0, bottomGutterWidth - widthLengthMax));
                        break;
                    }
                    case 3: {
                        int n10 = xPos - bedHouseWidth / 2;
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        Integer n11 = n10 - this.nextInt((Random)sharedSeedRandom3, widthLengthMax, leftGutterWidth);
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        pair = new Pair<Integer, Integer>(n11, zPos + this.nextInt((Random)sharedSeedRandom3, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    case 4: {
                        int n12 = xPos + bedHouseWidth / 2;
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        Integer n13 = n12 + this.nextInt((Random)sharedSeedRandom3, 0, rightGutterWidth - widthLengthMax);
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "random");
                        pair = new Pair<Integer, Integer>(n13, zPos + this.nextInt((Random)sharedSeedRandom3, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Got an invalid gutter " + gutter + ", should not be possible.");
                    }
                }
                Pair<Integer, Integer> pair2 = pair;
                int x = ((Number)pair2.component1()).intValue();
                int z = ((Number)pair2.component2()).intValue();
                SharedSeedRandom sharedSeedRandom4 = this.field_214631_d;
                Intrinsics.checkNotNullExpressionValue(sharedSeedRandom4, "random");
                SchematicStructurePiece prop22 = new SchematicStructurePiece(x, 0, z, (Random)sharedSeedRandom4, propSchematic, null, null, 96, null);
                cornerHeight1 = generator.func_222529_a(prop22.func_74874_b().field_78897_a, prop22.func_74874_b().field_78896_c, Heightmap.Type.WORLD_SURFACE_WG);
                int cornerHeight2 = generator.func_222529_a(prop22.func_74874_b().field_78893_d, prop22.func_74874_b().field_78896_c, Heightmap.Type.WORLD_SURFACE_WG);
                int cornerHeight3 = generator.func_222529_a(prop22.func_74874_b().field_78897_a, prop22.func_74874_b().field_78892_f, Heightmap.Type.WORLD_SURFACE_WG);
                int cornerHeight4 = generator.func_222529_a(prop22.func_74874_b().field_78893_d, prop22.func_74874_b().field_78892_f, Heightmap.Type.WORLD_SURFACE_WG);
                int n14 = 0;
                n14 = Math.min(cornerHeight1, cornerHeight2);
                int n15 = 0;
                n15 = Math.min(cornerHeight3, cornerHeight4);
                boolean bl2 = false;
                prop22.updateY(Math.min(n14, n15));
                this.field_75075_a.add(prop22);
            } while (ignored != numProps);
        }
        SharedSeedRandom sharedSeedRandom5 = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom5, "random");
        int numTrees = this.nextInt((Random)sharedSeedRandom5, 14, 20);
        int n16 = 0;
        if (n16 <= numTrees) {
            int ignored;
            do {
                Pair<Integer, Integer> pair;
                ignored = n16++;
                Schematic treeSchematic = ModSchematics.INSTANCE.getDARK_FOREST_TREES()[this.field_214631_d.nextInt(ModSchematics.INSTANCE.getDARK_FOREST_TREES().length)];
                int approximateTrunkWidth = 4;
                short x = treeSchematic.getWidth();
                short s = treeSchematic.getHeight();
                boolean prop22 = false;
                int widthLengthMax = Math.max(x, s);
                Direction gutter = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
                Direction prop22 = gutter;
                cornerHeight1 = prop22 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[prop22.ordinal()];
                switch (cornerHeight1) {
                    case 1: {
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        Integer n17 = xPos + this.nextInt((Random)cornerHeight2, -width / 2, width / 2 - widthLengthMax);
                        int n18 = zPos - bedHouseLength / 2;
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        pair = new Pair<Integer, Integer>(n17, n18 - this.nextInt((Random)cornerHeight2, approximateTrunkWidth + widthLengthMax / 2, bottomGutterWidth));
                        break;
                    }
                    case 2: {
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        Integer n19 = xPos + this.nextInt((Random)cornerHeight2, -width / 2, width / 2 - widthLengthMax);
                        int n20 = zPos + bedHouseLength / 2;
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        pair = new Pair<Integer, Integer>(n19, n20 + this.nextInt((Random)cornerHeight2, approximateTrunkWidth - widthLengthMax / 2, topGutterWidth - widthLengthMax));
                        break;
                    }
                    case 3: {
                        int n21 = xPos - bedHouseWidth / 2;
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        Integer n22 = n21 - this.nextInt((Random)cornerHeight2, approximateTrunkWidth + widthLengthMax / 2, leftGutterWidth);
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        pair = new Pair<Integer, Integer>(n22, zPos + this.nextInt((Random)cornerHeight2, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    case 4: {
                        int n23 = xPos + bedHouseWidth / 2;
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        Integer n24 = n23 + this.nextInt((Random)cornerHeight2, approximateTrunkWidth - widthLengthMax / 2, rightGutterWidth - widthLengthMax);
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "random");
                        pair = new Pair<Integer, Integer>(n24, zPos + this.nextInt((Random)cornerHeight2, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Got an invalid gutter " + gutter + ", should not be possible.");
                    }
                }
                Pair<Integer, Integer> pair3 = pair;
                int x2 = ((Number)pair3.component1()).intValue();
                int z = ((Number)pair3.component2()).intValue();
                SharedSeedRandom cornerHeight3 = this.field_214631_d;
                Intrinsics.checkNotNullExpressionValue(cornerHeight3, "random");
                SchematicStructurePiece tree = new SchematicStructurePiece(x2, 0, z, (Random)cornerHeight3, treeSchematic, null, null, 96, null);
                int trunkHeight1 = generator.func_222529_a(x2 + approximateTrunkWidth, z + approximateTrunkWidth, Heightmap.Type.WORLD_SURFACE_WG);
                int trunkHeight2 = generator.func_222529_a(x2 + approximateTrunkWidth, z - approximateTrunkWidth, Heightmap.Type.WORLD_SURFACE_WG);
                int trunkHeight3 = generator.func_222529_a(x2 - approximateTrunkWidth, z + approximateTrunkWidth, Heightmap.Type.WORLD_SURFACE_WG);
                int trunkHeight4 = generator.func_222529_a(x2 - approximateTrunkWidth, z - approximateTrunkWidth, Heightmap.Type.WORLD_SURFACE_WG);
                int trunkHeightCenter = generator.func_222529_a(x2, z, Heightmap.Type.WORLD_SURFACE_WG);
                int n25 = 0;
                n25 = Math.min(trunkHeight1, trunkHeight2);
                int n26 = 0;
                n26 = Math.min(trunkHeight3, trunkHeight4);
                boolean bl = false;
                n25 = Math.min(n25, n26);
                n26 = 0;
                tree.updateY(Math.min(n25, trunkHeightCenter) - 5);
                this.field_75075_a.add(tree);
            } while (ignored != numTrees);
        }
        this.func_202500_a();
    }

    private final int nextInt(Random $this$nextInt, int min, int max) {
        boolean bl = max > min;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return $this$nextInt.nextInt(max - min) + min;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/darkforest/DarkForestStructureStart$Companion;", "", "()V", "MAX_PROPS", "", "MAX_TREES", "MIN_PROPS", "MIN_TREES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.NORTH.ordinal()] = 1;
            nArray[Direction.SOUTH.ordinal()] = 2;
            nArray[Direction.WEST.ordinal()] = 3;
            nArray[Direction.EAST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

