/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event.register;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.constants.ModSpellDeliveryMethods;
import com.davidm1a2.afraidofthedark.common.constants.ModSpellEffects;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.AOESpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.ISpellDeliveryEffectApplicator;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.helper.TargetType;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/register/SpellEffectOverrideRegister;", "", "()V", "commonSetupEvent", "", "event", "Lnet/minecraftforge/fml/event/lifecycle/FMLCommonSetupEvent;", "registerAoeFixes", "registerAoeFreezeFix", "registerAoeTeleportFix", "afraidofthedark"})
public final class SpellEffectOverrideRegister {
    @SubscribeEvent
    public final void commonSetupEvent(@NotNull FMLCommonSetupEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.enqueueWork(() -> SpellEffectOverrideRegister.commonSetupEvent$lambda-0(this));
    }

    private final void registerAoeFixes() {
        ISpellDeliveryEffectApplicator customAOEApplicator2 = new ISpellDeliveryEffectApplicator(){

            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                Intrinsics.checkNotNullParameter(state, "state");
                Intrinsics.checkNotNullParameter(effect, "effect");
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                Intrinsics.checkNotNull(spellComponentInstance);
                SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
                SpellDeliveryMethod deliveryMethod = deliveryInstance.getComponent();
                if (deliveryMethod instanceof AOESpellDeliveryMethod) {
                    double radius = ((AOESpellDeliveryMethod)deliveryMethod).getRadius(deliveryInstance);
                    if (((AOESpellDeliveryMethod)deliveryMethod).getTargetType(deliveryInstance) == TargetType.ENTITY) {
                        return false;
                    }
                    boolean bl = false;
                    double d = Math.sqrt(radius);
                    boolean bl2 = false;
                    int maxExplosions = RangesKt.coerceIn((int)Math.ceil(d), 1, Integer.MAX_VALUE);
                    BlockPos basePos = new BlockPos(state.getPosition());
                    DeliveryTransitionStateBuilder transitionBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withWorld((World)state.getWorld()).withCasterEntity(state.getCasterEntity());
                    int explosionCount = 0;
                    while (explosionCount < maxExplosions) {
                        double randomZ;
                        double randomY;
                        double randomX = Random.Default.nextDouble(radius * (double)2) - radius;
                        BlockPos aoePos = basePos.func_177963_a(randomX, randomY = Random.Default.nextDouble(radius * (double)2) - radius, randomZ = Random.Default.nextDouble(radius * (double)2) - radius);
                        if (!(aoePos.func_177951_i((Vector3i)basePos) < radius * radius)) continue;
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = transitionBuilder.withPosition(new Vector3d((double)aoePos.func_177958_n(), (double)aoePos.func_177956_o(), (double)aoePos.func_177952_p()));
                        Intrinsics.checkNotNullExpressionValue(aoePos, "aoePos");
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder2 = deliveryTransitionStateBuilder.withBlockPosition(aoePos);
                        Vector3d vector3d = new Vector3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b();
                        Intrinsics.checkNotNullExpressionValue(vector3d, "Vector3d(\n                                                Math.random() - 0.5,\n                                                Math.random() - 0.5,\n                                                Math.random() - 0.5\n                                            ).normalize()");
                        SpellEffect.procEffect$default(effect.getComponent(), deliveryTransitionStateBuilder2.withDirection(vector3d).build(), effect, false, 4, null);
                        int n = explosionCount;
                        explosionCount = n + 1;
                    }
                }
                return true;
            }
        };
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getEXPLOSION(), customAOEApplicator2);
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getPOTION_EFFECT(), customAOEApplicator2);
    }

    private final void registerAoeTeleportFix() {
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getTELEPORT(), new ISpellDeliveryEffectApplicator(){

            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                Intrinsics.checkNotNullParameter(state, "state");
                Intrinsics.checkNotNullParameter(effect, "effect");
                ServerWorld world = state.getWorld();
                Entity spellCaster = state.getCasterEntity();
                if (spellCaster != null) {
                    SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                    Intrinsics.checkNotNull(spellComponentInstance);
                    SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
                    double radius = ((AOESpellDeliveryMethod)deliveryInstance.getComponent()).getRadius(deliveryInstance);
                    Vector3d center = state.getPosition();
                    int n = 0;
                    do {
                        int i = n++;
                        Vector3d teleportPos = center.func_72441_c(Random.Default.nextDouble(radius * (double)2) - radius, Random.Default.nextDouble(radius * (double)2) - radius, Random.Default.nextDouble(radius * (double)2) - radius);
                        BlockPos blockPos = new BlockPos(teleportPos);
                        BlockState blockState = world.func_180495_p(blockPos);
                        if (!blockState.isAir((IBlockReader)world, blockPos)) continue;
                        Intrinsics.checkNotNullExpressionValue(teleportPos, "teleportPos");
                        RegistryKey registryKey = spellCaster.field_70170_p.func_234923_W_();
                        Intrinsics.checkNotNullExpressionValue(registryKey, "spellCaster.level.dimension()");
                        AOTDSpellEffect.Companion.createParticlesAt(1, 3, teleportPos, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getENDER());
                        world.func_184148_a(null, teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 2.5f, 1.0f);
                        spellCaster.func_225653_b_(teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c);
                        registryKey = spellCaster.field_70170_p.func_234923_W_();
                        Intrinsics.checkNotNullExpressionValue(registryKey, "spellCaster.level.dimension()");
                        AOTDSpellEffect.Companion.createParticlesAt(1, 3, teleportPos, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getENDER());
                        world.func_184148_a(null, teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 2.5f, 1.0f);
                        break;
                    } while (n <= 19);
                }
                return true;
            }
        });
    }

    private final void registerAoeFreezeFix() {
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getFREEZE(), new ISpellDeliveryEffectApplicator(){

            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                Intrinsics.checkNotNullParameter(state, "state");
                Intrinsics.checkNotNullParameter(effect, "effect");
                ServerWorld world = state.getWorld();
                Vector3d centerPosition = state.getPosition();
                BlockPos centerBlockPosition = state.getBlockPosition();
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                Intrinsics.checkNotNull(spellComponentInstance);
                SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
                AOESpellDeliveryMethod deliveryMethodAOE = (AOESpellDeliveryMethod)deliveryInstance.getComponent();
                if (deliveryMethodAOE.getTargetType(deliveryInstance) == TargetType.ENTITY) {
                    return false;
                }
                double radius = deliveryMethodAOE.getRadius(deliveryInstance);
                boolean bl = false;
                int blockRadius = (int)Math.ceil(radius);
                double threshhold = 0.5;
                int n = -blockRadius;
                int n2 = blockRadius + 1;
                if (n < n2) {
                    do {
                        int x = n++;
                        int n3 = -blockRadius;
                        int n4 = blockRadius + 1;
                        if (n3 >= n4) continue;
                        do {
                            int y = n3++;
                            int n5 = -blockRadius;
                            int n6 = blockRadius + 1;
                            if (n5 >= n6) continue;
                            do {
                                int z = n5++;
                                BlockPos blockLocation = centerBlockPosition.func_177982_a(x, y, z);
                                Vector3d location = centerPosition.func_72441_c((double)x, (double)y, (double)z);
                                double distance = centerPosition.func_72438_d(location);
                                if (!(distance < radius + threshhold) || !(distance > radius - threshhold)) continue;
                                BlockState blockState = world.func_180495_p(blockLocation);
                                if (!world.func_175623_d(blockLocation)) continue;
                                world.func_180501_a(blockLocation, Blocks.field_150403_cj.func_176223_P(), 18);
                                Intrinsics.checkNotNullExpressionValue(location, "location");
                                RegistryKey registryKey = state.getWorld().func_234923_W_();
                                Intrinsics.checkNotNullExpressionValue(registryKey, "state.world.dimension()");
                                AOTDSpellEffect.Companion.createParticlesAround(0, 1, location, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getFREEZE(), 0.5);
                            } while (n5 < n6);
                        } while (n3 < n4);
                    } while (n < n2);
                }
                return true;
            }
        });
    }

    private static final void commonSetupEvent$lambda-0(SpellEffectOverrideRegister this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.registerAoeFixes();
        this$0.registerAoeTeleportFix();
        this$0.registerAoeFreezeFix();
    }
}

