/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.enaria;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.entity.enaria.FollowPlayerGoal;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.ArmthrowChannel;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.AutoattackChannel;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.SpellChannel;
import com.davidm1a2.afraidofthedark.common.entity.enaria.animation.WalkChannel;
import com.davidm1a2.afraidofthedark.common.entity.enaria.fight.EnariaFight;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.IMCAnimatedModel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.AnimationHandler;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.Channel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.tileEntity.EnariaSpawnerTileEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0001=B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\t\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016J\f\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\b\u0010)\u001a\u00020\fH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020-H\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u0010/\u001a\u00020&H\u0016J\b\u00102\u001a\u00020\u0010H\u0016J\b\u00103\u001a\u00020\u0010H\u0016J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u00105\u001a\u00020\u001bH\u0014J\u0010\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0019*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EnariaEntity;", "Lnet/minecraft/entity/MobEntity;", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/IMCAnimatedModel;", "world", "Lnet/minecraft/world/World;", "spawnerTilePos", "Lnet/minecraft/util/math/BlockPos;", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "entityType", "Lnet/minecraft/entity/EntityType;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "animHandler", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "bossInfo", "Lnet/minecraft/world/server/ServerBossInfo;", "canMove", "", "getCanMove", "()Z", "setCanMove", "(Z)V", "fight", "Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/EnariaFight;", "lastHit", "", "kotlin.jvm.PlatformType", "addAdditionalSaveData", "", "compound", "Lnet/minecraft/nbt/CompoundNBT;", "baseTick", "canBreatheUnderwater", "canRide", "entityIn", "Lnet/minecraft/entity/Entity;", "checkDespawn", "die", "cause", "Lnet/minecraft/util/DamageSource;", "getAddEntityPacket", "Lnet/minecraft/network/IPacket;", "getAnimationHandler", "getDisplayName", "Lnet/minecraft/util/text/ITextComponent;", "getWaterSlowDown", "", "hurt", "source", "rawAmount", "isInvulnerableTo", "isPushable", "isPushedByFluid", "readAdditionalSaveData", "registerGoals", "removeWhenFarAway", "distanceToClosestPlayer", "", "startSeenByPlayer", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "stopSeenByPlayer", "Companion", "afraidofthedark"})
public final class EnariaEntity
extends MobEntity
implements IMCAnimatedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationHandler animHandler;
    @NotNull
    private final ServerBossInfo bossInfo;
    private EnariaFight fight;
    private int lastHit;
    private BlockPos spawnerTilePos;
    private boolean canMove;
    private static final double MOVE_SPEED = 0.6;
    private static final double FOLLOW_RANGE = 64.0;
    private static final double MAX_HEALTH = 1000.0;
    private static final double ATTACK_DAMAGE = 12.0;
    private static final double KNOCKBACK_RESISTANCE = 0.5;
    private static final int MAX_DAMAGE_IN_1_HIT = 10;

    public EnariaEntity(@NotNull EntityType<? extends EnariaEntity> entityType, @NotNull World world) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(world, "world");
        super(entityType, world);
        Channel[] channelArray = new Channel[]{new WalkChannel("walk", 59.0f, 59, ChannelMode.LINEAR), new ArmthrowChannel("armthrow", 61.0f, 61, ChannelMode.LINEAR), new AutoattackChannel("autoattack", 70.0f, 51, ChannelMode.LINEAR), new SpellChannel("spell", 50.0f, 121, ChannelMode.LINEAR)};
        this.animHandler = new AnimationHandler(channelArray);
        channelArray = new ServerBossInfo((ITextComponent)new StringTextComponent("placeholder"), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
        if (channelArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.server.ServerBossInfo");
        }
        this.bossInfo = (ServerBossInfo)channelArray;
        this.spawnerTilePos = BlockPos.field_177992_a;
        this.canMove = true;
        this.func_200203_b((ITextComponent)new StringTextComponent("Enaria"));
        this.bossInfo.func_186739_a(this.func_145748_c_());
        this.field_70728_aV = 300;
    }

    public final boolean getCanMove() {
        return this.canMove;
    }

    public final void setCanMove(boolean bl) {
        this.canMove = bl;
    }

    public EnariaEntity(@NotNull World world, @NotNull BlockPos spawnerTilePos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(spawnerTilePos, "spawnerTilePos");
        this(ModEntities.INSTANCE.getENARIA(), world);
        if (!world.field_72995_K) {
            this.fight = new EnariaFight(this, spawnerTilePos);
            this.spawnerTilePos = spawnerTilePos;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowPlayerGoal(this, 8.0, 128.0, 64.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 100.0f));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            if ((this.func_213322_ci().field_72450_a > 0.05 || this.func_213322_ci().field_72449_c > 0.05 || this.func_213322_ci().field_72450_a < -0.05 || this.func_213322_ci().field_72449_c < -0.05) && !this.animHandler.isAnimationActive("spell") && !this.animHandler.isAnimationActive("autoattack") && !this.animHandler.isAnimationActive("armthrow") && !this.animHandler.isAnimationActive("walk")) {
                AnimationHandler.playAnimation$default(this.animHandler, "walk", 0.0f, 2, null);
            }
        } else {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (!this.field_70729_aU) {
                EnariaFight enariaFight = this.fight;
                if (enariaFight == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("fight");
                    throw null;
                }
                enariaFight.tick(this.field_70173_aa);
            }
        }
    }

    public boolean func_70097_a(@NotNull DamageSource source, float rawAmount) {
        Intrinsics.checkNotNullParameter(source, "source");
        if (!this.field_70170_p.field_72995_K) {
            long timeBetweenHits = System.currentTimeMillis() - (long)this.lastHit;
            this.lastHit = (int)timeBetweenHits;
            float amount = rawAmount;
            if (amount == Float.MAX_VALUE) {
                return super.func_70097_a(source, amount);
            }
            if (amount > 10.0f) {
                amount = 10.0f;
            }
            if (source instanceof EntityDamageSource) {
                Entity damageSource = ((EntityDamageSource)source).func_76346_g();
                if (damageSource instanceof PlayerEntity && !CapabilityExtensionsKt.getResearch((PlayerEntity)damageSource).canResearch(ModResearches.INSTANCE.getENARIA()) && !CapabilityExtensionsKt.getResearch((PlayerEntity)damageSource).isResearched(ModResearches.INSTANCE.getENARIA())) {
                    ((PlayerEntity)damageSource).func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.enaria.dont_understand"), ((PlayerEntity)damageSource).func_110124_au());
                    return false;
                }
                if (StringsKt.equals(source.field_76373_n, "silver_damage", true)) {
                    float f = 1.0f;
                    float f2 = (float)timeBetweenHits / 1000.0f;
                    boolean bl = false;
                    float amountModifier = Math.min(f, f2);
                    return super.func_70097_a(source, amount * amountModifier);
                }
            }
        }
        return super.func_70097_a(DamageSource.field_76377_j, 1.0f);
    }

    public void func_70645_a(@NotNull DamageSource cause) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            EnariaFight enariaFight = this.fight;
            if (enariaFight == null) {
                Intrinsics.throwUninitializedPropertyAccessException("fight");
                throw null;
            }
            enariaFight.end();
            TileEntity spawnerTileEntity = this.field_70170_p.func_175625_s(this.spawnerTilePos);
            if (spawnerTileEntity instanceof EnariaSpawnerTileEntity) {
                ((EnariaSpawnerTileEntity)spawnerTileEntity).endFight();
            }
        }
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        ITextComponent iTextComponent = this.func_200201_e();
        Intrinsics.checkNotNull(iTextComponent);
        ITextComponent iTextComponent2 = iTextComponent;
        return iTextComponent2;
    }

    @Override
    @NotNull
    public AnimationHandler getAnimationHandler() {
        return this.animHandler;
    }

    public void func_184178_b(@NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter(player, "player");
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter(player, "player");
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_189749_co() {
        return 0.0f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(@NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter(entityIn, "entityIn");
        return false;
    }

    public void func_70623_bb() {
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_180431_b(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter(source, "source");
        if (Intrinsics.areEqual(source, DamageSource.field_76379_h)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        IPacket iPacket = NetworkHooks.getEntitySpawningPacket((Entity)((Entity)this));
        Intrinsics.checkNotNullExpressionValue(iPacket, "getEntitySpawningPacket(this)");
        return iPacket;
    }

    public void func_70037_a(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        super.func_70037_a(compound);
        this.lastHit = compound.func_74762_e("last_hit");
        this.spawnerTilePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("spawner_tile_pos"));
        if (!this.field_70170_p.field_72995_K) {
            Object object = this.spawnerTilePos;
            Intrinsics.checkNotNullExpressionValue(object, "this.spawnerTilePos");
            this.fight = new EnariaFight(this, (BlockPos)object);
            object = this.fight;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException("fight");
                throw null;
            }
            Object object2 = object;
            object = compound.func_74775_l("fight");
            Intrinsics.checkNotNullExpressionValue(object, "compound.getCompound(\"fight\")");
            ((EnariaFight)object2).deserializeNBT((CompoundNBT)object);
        }
    }

    public void func_213281_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        super.func_213281_b(compound);
        compound.func_74768_a("last_hit", this.lastHit);
        compound.func_218657_a("spawner_tile_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.spawnerTilePos));
        if (!this.field_70170_p.field_72995_K) {
            EnariaFight enariaFight = this.fight;
            if (enariaFight == null) {
                Intrinsics.throwUninitializedPropertyAccessException("fight");
                throw null;
            }
            compound.func_218657_a("fight", (INBT)enariaFight.serializeNBT());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/EnariaEntity$Companion;", "", "()V", "ATTACK_DAMAGE", "", "FOLLOW_RANGE", "KNOCKBACK_RESISTANCE", "MAX_DAMAGE_IN_1_HIT", "", "MAX_HEALTH", "MOVE_SPEED", "buildAttributeModifiers", "Lnet/minecraft/entity/ai/attributes/AttributeModifierMap$MutableAttribute;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeModifierMap.MutableAttribute buildAttributeModifiers() {
            AttributeModifierMap.MutableAttribute mutableAttribute = LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 1000.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233823_f_, 12.0);
            Intrinsics.checkNotNullExpressionValue(mutableAttribute, "createLivingAttributes()\n                .add(Attributes.MAX_HEALTH, MAX_HEALTH)\n                .add(Attributes.FOLLOW_RANGE, FOLLOW_RANGE)\n                .add(Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_RESISTANCE)\n                .add(Attributes.MOVEMENT_SPEED, MOVE_SPEED)\n                .add(Attributes.ATTACK_DAMAGE, ATTACK_DAMAGE)");
            return mutableAttribute;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

