/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.dimension;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IslandData;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/dimension/IslandUtility;", "", "()V", "findValidSpawnLocation", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/World;", "blockPos", "searchDistance", "", "getOrAssignPlayerPositionalIndex", "islandData", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/dimension/IslandData;", "isValidSpawnLocation", "", "afraidofthedark"})
public final class IslandUtility {
    @NotNull
    public static final IslandUtility INSTANCE = new IslandUtility();

    private IslandUtility() {
    }

    public final int getOrAssignPlayerPositionalIndex(@NotNull World world, @NotNull IslandData islandData) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(islandData, "islandData");
        if (islandData.getPositionalIndex() == -1) {
            int playersNewPositionalIndex = CapabilityExtensionsKt.getIslandVisitors(world).addAndGetNewVisitor();
            islandData.setPositionalIndex(playersNewPositionalIndex);
        }
        return islandData.getPositionalIndex();
    }

    @Nullable
    public final BlockPos findValidSpawnLocation(@NotNull World world, @NotNull BlockPos blockPos, int searchDistance) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        int xCenter = blockPos.func_177958_n();
        int yCenter = blockPos.func_177956_o();
        int zCenter = blockPos.func_177952_p();
        int n = xCenter - searchDistance / 2;
        int n2 = xCenter + searchDistance / 2;
        if (n < n2) {
            do {
                int x = n++;
                int n3 = yCenter - searchDistance / 2;
                int n4 = yCenter + searchDistance / 2;
                if (n3 >= n4) continue;
                do {
                    int y = n3++;
                    int n5 = zCenter - searchDistance / 2;
                    int n6 = zCenter + searchDistance / 2;
                    if (n5 >= n6) continue;
                    do {
                        int z;
                        if (!this.isValidSpawnLocation(world, new BlockPos(x, y, z = n5++))) continue;
                        return new BlockPos(x, y, z);
                    } while (n5 < n6);
                } while (n3 < n4);
            } while (n < n2);
        }
        return null;
    }

    public final boolean isValidSpawnLocation(@NotNull World world, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        BlockState bottomBlock = world.func_180495_p(blockPos);
        Material bottomBlockMaterial = bottomBlock.func_185904_a();
        if (bottomBlockMaterial.func_76220_a() && bottomBlockMaterial.func_76230_c() && !Intrinsics.areEqual(bottomBlock.func_177230_c(), ModBlocks.INSTANCE.getVOID_CHEST_PORTAL())) {
            BlockState blockUpOne = world.func_180495_p(blockPos.func_177984_a());
            BlockState blockUpTwo = world.func_180495_p(blockPos.func_177981_b(2));
            return !Intrinsics.areEqual(blockUpOne.func_177230_c(), ModBlocks.INSTANCE.getVOID_CHEST_PORTAL()) && !Intrinsics.areEqual(blockUpTwo.func_177230_c(), ModBlocks.INSTANCE.getVOID_CHEST_PORTAL()) && !blockUpOne.func_185904_a().func_76230_c() && !blockUpTwo.func_185904_a().func_76230_c();
        }
        return false;
    }
}

