/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.world.structure;

import com.davidm1a2.afraidofthedark.common.capabilities.world.structure.StructureGridPos;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "", "blockSize", "", "nextSizeDown", "(Ljava/lang/String;IILcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;)V", "getBlockSize", "()I", "chunkSize", "getChunkSize", "getNextSizeDown", "()Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "toAbsoluteGridPos", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridPos;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "toRelativeGridPos", "SIZE_16", "SIZE_32", "SIZE_64", "SIZE_128", "SIZE_256", "Companion", "afraidofthedark"})
public final class StructureGridSize
extends Enum<StructureGridSize> {
    @NotNull
    public static final Companion Companion;
    private final int blockSize;
    @Nullable
    private final StructureGridSize nextSizeDown;
    private final int chunkSize;
    @NotNull
    private static final StructureGridSize LARGEST_GRID_SIZE;
    public static final /* enum */ StructureGridSize SIZE_16;
    public static final /* enum */ StructureGridSize SIZE_32;
    public static final /* enum */ StructureGridSize SIZE_64;
    public static final /* enum */ StructureGridSize SIZE_128;
    public static final /* enum */ StructureGridSize SIZE_256;
    private static final /* synthetic */ StructureGridSize[] $VALUES;

    private StructureGridSize(int blockSize, StructureGridSize nextSizeDown) {
        this.blockSize = blockSize;
        this.nextSizeDown = nextSizeDown;
        this.chunkSize = this.blockSize / 16;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    @Nullable
    public final StructureGridSize getNextSizeDown() {
        return this.nextSizeDown;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    @NotNull
    public final StructureGridPos toAbsoluteGridPos(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter(chunkPos, "chunkPos");
        int xChunkPos = chunkPos.field_77276_a < 0 ? chunkPos.field_77276_a - this.chunkSize + 1 : chunkPos.field_77276_a;
        int zChunkPos = chunkPos.field_77275_b < 0 ? chunkPos.field_77275_b - this.chunkSize + 1 : chunkPos.field_77275_b;
        return new StructureGridPos(xChunkPos / this.chunkSize, zChunkPos / this.chunkSize, this);
    }

    @NotNull
    public final StructureGridPos toRelativeGridPos(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter(chunkPos, "chunkPos");
        StructureGridPos absoluteGridPos = this.toAbsoluteGridPos(chunkPos);
        int maxChunkSize = StructureGridSize.LARGEST_GRID_SIZE.chunkSize / this.chunkSize;
        return new StructureGridPos(Math.floorMod(absoluteGridPos.getX(), maxChunkSize), Math.floorMod(absoluteGridPos.getZ(), maxChunkSize), this);
    }

    public static StructureGridSize[] values() {
        StructureGridSize[] structureGridSizeArray = $VALUES;
        return Arrays.copyOf(structureGridSizeArray, structureGridSizeArray.length);
    }

    public static StructureGridSize valueOf(String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return Enum.valueOf(StructureGridSize.class, value);
    }

    /*
     * WARNING - void declaration
     */
    static {
        StructureGridSize[] structureGridSizeArray;
        SIZE_16 = new StructureGridSize(16, null);
        SIZE_32 = new StructureGridSize(32, SIZE_16);
        SIZE_64 = new StructureGridSize(64, SIZE_32);
        SIZE_128 = new StructureGridSize(128, SIZE_64);
        SIZE_256 = new StructureGridSize(256, SIZE_128);
        $VALUES = structureGridSizeArray = new StructureGridSize[]{StructureGridSize.SIZE_16, StructureGridSize.SIZE_32, StructureGridSize.SIZE_64, StructureGridSize.SIZE_128, StructureGridSize.SIZE_256};
        Companion = new Companion(null);
        StructureGridSize[] $this$maxByOrNull$iv = StructureGridSize.values();
        boolean $i$f$maxByOrNull = false;
        StructureGridSize[] structureGridSizeArray2 = $this$maxByOrNull$iv;
        boolean bl = false;
        if (structureGridSizeArray2.length == 0) {
            structureGridSizeArray = null;
        } else {
            Object maxElem$iv = $this$maxByOrNull$iv[0];
            int lastIndex$iv = ArraysKt.getLastIndex($this$maxByOrNull$iv);
            if (lastIndex$iv == 0) {
                structureGridSizeArray = maxElem$iv;
            } else {
                StructureGridSize[] it = maxElem$iv;
                int n = 0;
                int maxValue$iv = it.getBlockSize();
                n = 1;
                int n2 = lastIndex$iv;
                if (n <= n2) {
                    while (true) {
                        void i$iv;
                        StructureGridSize e$iv;
                        StructureGridSize it2 = e$iv = $this$maxByOrNull$iv[i$iv];
                        boolean bl2 = false;
                        int v$iv = it2.getBlockSize();
                        if (maxValue$iv < v$iv) {
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        }
                        if (i$iv == n2) break;
                        ++i$iv;
                    }
                }
                structureGridSizeArray = structureGridSizeArray2;
            }
        }
        StructureGridSize[] structureGridSizeArray3 = structureGridSizeArray;
        Intrinsics.checkNotNull(structureGridSizeArray3);
        LARGEST_GRID_SIZE = structureGridSizeArray3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize$Companion;", "", "()V", "LARGEST_GRID_SIZE", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "getLARGEST_GRID_SIZE", "()Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StructureGridSize getLARGEST_GRID_SIZE() {
            return LARGEST_GRID_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

