/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.player.spell;

import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/PlayerSpellManagerStorage;", "Lnet/minecraftforge/common/capabilities/Capability$IStorage;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/IPlayerSpellManager;", "()V", "readNBT", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "instance", "side", "Lnet/minecraft/util/Direction;", "nbt", "Lnet/minecraft/nbt/INBT;", "writeNBT", "Companion", "afraidofthedark"})
public final class PlayerSpellManagerStorage
implements Capability.IStorage<IPlayerSpellManager> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();
    @NotNull
    private static final String NBT_SPELLS_LIST = "spells";
    @NotNull
    private static final String NBT_KEYBINDS_LIST = "keybinds";
    @NotNull
    private static final String NBT_KEYBIND = "keybind";
    @NotNull
    private static final String NBT_KEYBIND_SPELL_UUID = "keybind_spell_uuid";

    @NotNull
    public INBT writeNBT(@NotNull Capability<IPlayerSpellManager> capability, @NotNull IPlayerSpellManager instance, @Nullable Direction side) {
        Intrinsics.checkNotNullParameter(capability, "capability");
        Intrinsics.checkNotNullParameter(instance, "instance");
        CompoundNBT compound = new CompoundNBT();
        ListNBT spellsNBT = new ListNBT();
        for (Spell spell : instance.getSpells()) {
            spellsNBT.add((Object)spell.serializeNBT());
        }
        compound.func_218657_a(NBT_SPELLS_LIST, (INBT)spellsNBT);
        ListNBT keybindingsNBT = new ListNBT();
        for (Spell spell : instance.getSpells()) {
            String keybinding = instance.getKeybindingForSpell(spell);
            if (keybinding == null) continue;
            CompoundNBT keybindCompound = new CompoundNBT();
            keybindCompound.func_218657_a(NBT_KEYBIND_SPELL_UUID, (INBT)NBTUtil.func_240626_a_((UUID)spell.getId()));
            keybindCompound.func_74778_a(NBT_KEYBIND, keybinding);
            keybindingsNBT.add((Object)keybindCompound);
        }
        compound.func_218657_a(NBT_KEYBINDS_LIST, (INBT)keybindingsNBT);
        return (INBT)compound;
    }

    /*
     * WARNING - void declaration
     */
    public void readNBT(@NotNull Capability<IPlayerSpellManager> capability, @NotNull IPlayerSpellManager instance, @Nullable Direction side, @NotNull INBT nbt) {
        Intrinsics.checkNotNullParameter(capability, "capability");
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        if (nbt instanceof CompoundNBT) {
            void $this$associateByTo$iv$iv;
            Object spell;
            int n = 0;
            ListNBT spellsNBT = ((CompoundNBT)nbt).func_150295_c(NBT_SPELLS_LIST, 10);
            int n2 = spellsNBT.size();
            if (n < n2) {
                do {
                    int i = n++;
                    CompoundNBT spellNBT = spellsNBT.func_150305_b(i);
                    Intrinsics.checkNotNullExpressionValue(spellNBT, "spellNBT");
                    spell = new Spell(spellNBT);
                    instance.addOrUpdateSpell((Spell)spell);
                } while (n < n2);
            }
            Iterable $this$associateBy$iv = instance.getSpells();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            spell = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Spell spell2 = (Spell)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                UUID uUID = it.getId();
                map.put(uUID, element$iv$iv);
            }
            Map idToSpell = destination$iv$iv;
            int n3 = 0;
            ListNBT keybindingsNBT = ((CompoundNBT)nbt).func_150295_c(NBT_KEYBINDS_LIST, 10);
            int n4 = keybindingsNBT.size();
            if (n3 < n4) {
                do {
                    int i = n3++;
                    CompoundNBT keybindingNBT = keybindingsNBT.func_150305_b(i);
                    INBT iNBT = keybindingNBT.func_74781_a(NBT_KEYBIND_SPELL_UUID);
                    Intrinsics.checkNotNull(iNBT);
                    UUID spellUUID = NBTUtil.func_186860_b((INBT)iNBT);
                    String keybind = keybindingNBT.func_74779_i(NBT_KEYBIND);
                    Intrinsics.checkNotNullExpressionValue(keybind, NBT_KEYBIND);
                    Spell spell3 = (Spell)idToSpell.get(spellUUID);
                    Intrinsics.checkNotNull(spell3);
                    instance.keybindSpell(keybind, spell3);
                } while (n3 < n4);
            }
        } else {
            logger.error("Attempted to deserialize an NBTBase that was not an NBTTagCompound!");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/PlayerSpellManagerStorage$Companion;", "", "()V", "NBT_KEYBIND", "", "NBT_KEYBINDS_LIST", "NBT_KEYBIND_SPELL_UUID", "NBT_SPELLS_LIST", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

