/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.block;

import com.davidm1a2.afraidofthedark.common.block.core.AOTDTileEntityBlock;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.tileEntity.VoidChestTileEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006$"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/VoidChestBlock;", "Lcom/davidm1a2/afraidofthedark/common/block/core/AOTDTileEntityBlock;", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/Block;", "Lnet/minecraft/block/BlockState;", "getRenderShape", "Lnet/minecraft/block/BlockRenderType;", "state", "getShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "world", "Lnet/minecraft/world/IBlockReader;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "context", "Lnet/minecraft/util/math/shapes/ISelectionContext;", "getStateForPlacement", "Lnet/minecraft/item/BlockItemUseContext;", "newBlockEntity", "Lnet/minecraft/tileentity/TileEntity;", "use", "Lnet/minecraft/util/ActionResultType;", "worldIn", "Lnet/minecraft/world/World;", "pos", "playerIn", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "result", "Lnet/minecraft/util/math/BlockRayTraceResult;", "Companion", "afraidofthedark"})
public final class VoidChestBlock
extends AOTDTileEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final DirectionProperty FACING_PROPERTY = HorizontalBlock.field_185512_D;
    private static final VoxelShape VOID_CHEST_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public VoidChestBlock() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 50.0f).harvestLevel(2).harvestTool(ToolType.PICKAXE).func_235861_h_();
        Intrinsics.checkNotNullExpressionValue(properties, "of(Material.STONE)\n        .strength(4.0f, 50.0f)\n        .harvestLevel(2)\n        .harvestTool(ToolType.PICKAXE)\n        .requiresCorrectToolForDrops()");
        super("void_chest", properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING_PROPERTY, (Comparable)Direction.NORTH));
    }

    @NotNull
    public BlockRenderType func_149645_b(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader world, @NotNull BlockPos blockPos, @NotNull ISelectionContext context) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(context, "context");
        VoxelShape voxelShape = VOID_CHEST_SHAPE;
        Intrinsics.checkNotNullExpressionValue(voxelShape, "VOID_CHEST_SHAPE");
        return voxelShape;
    }

    @Nullable
    public BlockState func_196258_a(@NotNull BlockItemUseContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING_PROPERTY, (Comparable)context.func_195992_f().func_176734_d());
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull PlayerEntity playerIn, @NotNull Hand hand, @NotNull BlockRayTraceResult result) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(worldIn, "worldIn");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(playerIn, "playerIn");
        Intrinsics.checkNotNullParameter(hand, "hand");
        Intrinsics.checkNotNullParameter(result, "result");
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof VoidChestTileEntity) {
            if (CapabilityExtensionsKt.getResearch(playerIn).isResearched(ModResearches.INSTANCE.getVOID_CHEST())) {
                ((VoidChestTileEntity)tileEntity).interact(playerIn);
            } else if (!worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.void_chest.dont_understand"), playerIn.func_110124_au());
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Property[] propertyArray = new Property[]{(Property)FACING_PROPERTY};
        builder.func_206894_a(propertyArray);
    }

    @NotNull
    public TileEntity func_196283_a_(@NotNull IBlockReader world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return new VoidChestTileEntity();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/VoidChestBlock$Companion;", "", "()V", "FACING_PROPERTY", "Lnet/minecraft/state/DirectionProperty;", "kotlin.jvm.PlatformType", "VOID_CHEST_SHAPE", "Lnet/minecraft/util/math/shapes/VoxelShape;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

