/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.fontLibrary.TrueTypeFont;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponentWithEvents;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/TextBoxComponent;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDGuiComponentWithEvents;", "prefSize", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "font", "Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont;", "textAlignment", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/TextAlignment;", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont;Lcom/davidm1a2/afraidofthedark/client/gui/layout/TextAlignment;)V", "<set-?>", "", "overflowText", "getOverflowText", "()Ljava/lang/String;", "text", "getTextAlignment", "()Lcom/davidm1a2/afraidofthedark/client/gui/layout/TextAlignment;", "textColor", "Ljava/awt/Color;", "getTextColor", "()Ljava/awt/Color;", "setTextColor", "(Ljava/awt/Color;)V", "textLines", "", "draw", "", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "getText", "invalidate", "setText", "afraidofthedark"})
public final class TextBoxComponent
extends AOTDGuiComponentWithEvents {
    @NotNull
    private final TrueTypeFont font;
    @NotNull
    private final TextAlignment textAlignment;
    @NotNull
    private List<String> textLines;
    @NotNull
    private String text;
    @NotNull
    private Color textColor;
    @NotNull
    private String overflowText;

    public TextBoxComponent(@NotNull Dimensions prefSize, @NotNull TrueTypeFont font, @NotNull TextAlignment textAlignment) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter((Object)textAlignment, "textAlignment");
        super(null, prefSize, null, null, null, null, 61, null);
        this.font = font;
        this.textAlignment = textAlignment;
        boolean bl = false;
        this.textLines = new ArrayList();
        this.text = "";
        this.textColor = new Color(255, 255, 255, 255);
        this.overflowText = "";
    }

    public /* synthetic */ TextBoxComponent(Dimensions dimensions, TrueTypeFont trueTypeFont, TextAlignment textAlignment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dimensions = new Dimensions(1.0, 1.0, false, 4, null);
        }
        if ((n & 4) != 0) {
            textAlignment = TextAlignment.ALIGN_LEFT;
        }
        this(dimensions, trueTypeFont, textAlignment);
    }

    @NotNull
    public final TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    @NotNull
    public final Color getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.textColor = color;
    }

    @NotNull
    public final String getOverflowText() {
        return this.overflowText;
    }

    @Override
    public void draw(@NotNull MatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        if (this.isVisible() && this.getInBounds()) {
            float yCoord = this.getY();
            for (String line : this.textLines) {
                float f;
                int lineWidth = this.font.getWidth(line);
                int lineHeight = this.font.getHeight(line);
                float f2 = this.getX();
                TextAlignment textAlignment = this.textAlignment;
                int n = WhenMappings.$EnumSwitchMapping$0[textAlignment.ordinal()];
                switch (n) {
                    case 1: {
                        f = lineWidth;
                        break;
                    }
                    case 2: {
                        f = (float)lineWidth / 2.0f;
                        break;
                    }
                    default: {
                        f = 0.0f;
                    }
                }
                float xCoord = f2 + f;
                this.font.drawString(xCoord, yCoord, line, this.textAlignment, this.textColor);
                yCoord += (float)lineHeight;
            }
        }
    }

    public final void setText(@NotNull String text) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(text, "text");
        this.text = text;
        this.textLines.clear();
        StringTokenizer words = new StringTokenizer(text, " ");
        Object currentLineText = "";
        while (words.hasMoreTokens()) {
            String word = words.nextToken();
            object = word;
            Intrinsics.checkNotNullExpressionValue(object, "word");
            word = StringsKt.replace$default((String)object, "\t", "   ", false, 4, null);
            if (this.font.getWidth((String)currentLineText + ' ' + word) > this.getWidth()) {
                this.textLines.add((String)currentLineText);
                object = word;
                Intrinsics.checkNotNullExpressionValue(object, "word");
                currentLineText = object;
                continue;
            }
            object = (CharSequence)currentLineText;
            bl = false;
            if (object.length() > 0) {
                currentLineText = Intrinsics.stringPlus((String)currentLineText, " ");
            }
            currentLineText = Intrinsics.stringPlus((String)currentLineText, word);
        }
        this.textLines.add((String)currentLineText);
        this.overflowText = "";
        int textHeight = this.font.getHeight(CollectionsKt.joinToString$default(this.textLines, "\n", null, null, 0, null, null, 62, null));
        while (textHeight > this.getHeight()) {
            object = this.textLines;
            bl = false;
            if (!(!object.isEmpty())) break;
            object = this;
            ((TextBoxComponent)object).overflowText = ((TextBoxComponent)object).overflowText + CollectionsKt.removeLast(this.textLines) + '\n';
            textHeight = this.font.getHeight(CollectionsKt.joinToString$default(this.textLines, "\n", null, null, 0, null, null, 62, null));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setText(this.text);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlignment.values().length];
            nArray[TextAlignment.ALIGN_RIGHT.ordinal()] = 1;
            nArray[TextAlignment.ALIGN_CENTER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

