/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.events.MouseDragEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.StackPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ScrollPane;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/StackPane;", "scrollWidthRatio", "", "scrollHeightRatio", "persistentOffset", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;", "(DDLcom/davidm1a2/afraidofthedark/client/gui/layout/Position;)V", "mouseHeld", "", "originalGuiOffsetX", "originalGuiOffsetY", "originalXPosition", "", "originalYPosition", "scrollHeight", "getScrollHeight", "()D", "setScrollHeight", "(D)V", "scrollWidth", "getScrollWidth", "setScrollWidth", "checkOutOfBounds", "", "getCurrentOffset", "getInternalHeight", "getInternalWidth", "negotiateDimensions", "width", "height", "afraidofthedark"})
public class ScrollPane
extends StackPane {
    private final double scrollWidthRatio;
    private final double scrollHeightRatio;
    @Nullable
    private final Position persistentOffset;
    private double originalGuiOffsetX;
    private double originalGuiOffsetY;
    private int originalXPosition;
    private int originalYPosition;
    private boolean mouseHeld;
    private double scrollWidth;
    private double scrollHeight;

    public ScrollPane(double scrollWidthRatio, double scrollHeightRatio, @Nullable Position persistentOffset) {
        super(null, null, null, null, null, null, true, 63, null);
        this.scrollWidthRatio = scrollWidthRatio;
        this.scrollHeightRatio = scrollHeightRatio;
        this.persistentOffset = persistentOffset;
        this.originalXPosition = -1;
        this.originalYPosition = -1;
        this.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (this.isHovered()) {
                    if (it.getEventType() == MouseEvent.EventType.Click && it.getClickedButton() == 0) {
                        originalXPosition = it.getMouseX();
                        originalYPosition = it.getMouseY();
                        originalGuiOffsetX = this.getGuiOffsetX();
                        originalGuiOffsetY = this.getGuiOffsetY();
                        mouseHeld = true;
                    }
                    if (it.getEventType() == MouseEvent.EventType.Release && it.getClickedButton() == 0) {
                        mouseHeld = false;
                    }
                }
            }
        });
        this.addMouseDragListener((Function1<? super MouseDragEvent, Unit>)new Function1<MouseDragEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseDragEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (this.isHovered() && it.getClickedButton() == 0 && mouseHeld) {
                    this.setGuiOffsetX(originalGuiOffsetX + (double)(it.getMouseX() - originalXPosition));
                    this.setGuiOffsetY(originalGuiOffsetY + (double)(it.getMouseY() - originalYPosition));
                    this.checkOutOfBounds();
                    this.invalidate();
                }
            }
        });
    }

    public /* synthetic */ ScrollPane(double d, double d2, Position position, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            position = null;
        }
        this(d, d2, position);
    }

    public final double getScrollWidth() {
        return this.scrollWidth;
    }

    public final void setScrollWidth(double d) {
        this.scrollWidth = d;
    }

    public final double getScrollHeight() {
        return this.scrollHeight;
    }

    public final void setScrollHeight(double d) {
        this.scrollHeight = d;
    }

    @Override
    public double getInternalWidth() {
        return this.scrollWidth - this.getPadding().getAbsoluteOuter(this).getWidth();
    }

    @Override
    public double getInternalHeight() {
        return this.scrollHeight - this.getPadding().getAbsoluteOuter(this).getHeight();
    }

    public void checkOutOfBounds() {
        if (this.getGuiOffsetX() < (double)this.getWidth() - this.scrollWidth) {
            this.setGuiOffsetX((double)this.getWidth() - this.scrollWidth);
        }
        if (this.getGuiOffsetY() < (double)this.getHeight() - this.scrollHeight) {
            this.setGuiOffsetY((double)this.getHeight() - this.scrollHeight);
        }
        if (this.getGuiOffsetX() > 0.0) {
            this.setGuiOffsetX(0.0);
        }
        if (this.getGuiOffsetY() > 0.0) {
            this.setGuiOffsetY(0.0);
        }
    }

    @Override
    public void negotiateDimensions(double width, double height) {
        super.negotiateDimensions(width, height);
        this.scrollWidth = (double)this.getWidth() * this.scrollWidthRatio;
        this.scrollHeight = (double)this.getHeight() * this.scrollHeightRatio;
        if (this.persistentOffset != null) {
            this.setGuiOffsetX(this.persistentOffset.getAbsolute(this).getX());
            this.setGuiOffsetY(this.persistentOffset.getAbsolute(this).getY());
        }
    }

    @NotNull
    public final Position getCurrentOffset() {
        return new Position(this.getGuiOffsetX(), this.getGuiOffsetY(), false);
    }
}

