/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.screens;

import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.fontLibrary.TrueTypeFont;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.davidm1a2.afraidofthedark.client.gui.screens.AOTDScreen;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ButtonPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.TextFieldPane;
import com.davidm1a2.afraidofthedark.client.settings.ClientData;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.item.JournalItem;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/screens/BloodStainedJournalSignScreen;", "Lcom/davidm1a2/afraidofthedark/client/gui/screens/AOTDScreen;", "()V", "nameSignField", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/TextFieldPane;", "drawGradientBackground", "", "inventoryToCloseGuiScreen", "afraidofthedark"})
public final class BloodStainedJournalSignScreen
extends AOTDScreen {
    @NotNull
    private final TextFieldPane nameSignField;

    public BloodStainedJournalSignScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.afraidofthedark.blood_stained_journal_sign"), false, 2, null);
        this.getContentPane().setPadding(new Spacing(0.08, false, 2, null));
        ImagePane background = new ImagePane(new ResourceLocation("afraidofthedark:textures/gui/journal_sign/blood_stained_journal.png"), ImagePane.DispMode.FIT_TO_PARENT);
        background.setGravity(Gravity.CENTER);
        this.getContentPane().add(background);
        Dimensions dimensions = new Dimensions(0.6, 0.15, false, 4, null);
        Position position = new Position(0.0, -0.1, false, 4, null);
        TrueTypeFont trueTypeFont = ClientData.INSTANCE.getOrCreate(45.0f);
        this.nameSignField = new TextFieldPane(position, dimensions, trueTypeFont);
        this.nameSignField.setTextColor(new Color(255, 0, 0));
        this.nameSignField.setGravity(Gravity.CENTER);
        background.add(this.nameSignField);
        ButtonPane signButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/journal_sign/sign_button.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/journal_sign/sign_button_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.5, 0.1, false, 4, null), new Position(0.0, 0.1, false, 4, null), ClientData.INSTANCE.getOrCreate(55.0f), 124, null);
        signButton.setText("Sign");
        signButton.setTextColor(new Color(255, 0, 0));
        signButton.setTextAlignment(TextAlignment.ALIGN_CENTER);
        signButton.setGravity(Gravity.CENTER);
        signButton.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click) {
                    if (it.getSource().isHovered() && it.getClickedButton() == 0) {
                        IAOTDPlayerBasics playerBasics = CapabilityExtensionsKt.getBasics((PlayerEntity)this.getEntityPlayer());
                        if (Intrinsics.areEqual(nameSignField.getText(), this.getEntityPlayer().func_146103_bH().getName())) {
                            if (!CapabilityExtensionsKt.hasStartedAOTD((PlayerEntity)this.getEntityPlayer())) {
                                playerBasics.startAOTD((PlayerEntity)this.getEntityPlayer());
                                ItemStack mainHand = this.getEntityPlayer().func_184614_ca();
                                ItemStack offHand = this.getEntityPlayer().func_184614_ca();
                                if (mainHand.func_77973_b() instanceof JournalItem) {
                                    Item item = mainHand.func_77973_b();
                                    if (item == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.item.JournalItem");
                                    }
                                    JournalItem journalItem = (JournalItem)item;
                                    Intrinsics.checkNotNullExpressionValue(mainHand, "mainHand");
                                    journalItem.setOwner(mainHand, this.getEntityPlayer().func_146103_bH().getName());
                                } else if (offHand.func_77973_b() instanceof JournalItem) {
                                    Item item = offHand.func_77973_b();
                                    if (item == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.item.JournalItem");
                                    }
                                    JournalItem journalItem = (JournalItem)item;
                                    Intrinsics.checkNotNullExpressionValue(offHand, "offHand");
                                    journalItem.setOwner(offHand, this.getEntityPlayer().func_146103_bH().getName());
                                }
                                this.getEntityPlayer().func_184185_a(ModSounds.INSTANCE.getJOURNAL_SIGN(), 4.0f, 1.0f);
                                this.getEntityPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.journal.sign.successful"), this.getEntityPlayer().func_110124_au());
                            }
                        } else if (!CapabilityExtensionsKt.hasStartedAOTD((PlayerEntity)this.getEntityPlayer())) {
                            this.getEntityPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.journal.sign.unsuccessful"), this.getEntityPlayer().func_110124_au());
                            this.func_231175_as__();
                        }
                        this.func_231175_as__();
                    }
                    it.consume();
                }
            }
        });
        background.add(signButton);
    }

    @Override
    public boolean drawGradientBackground() {
        return true;
    }

    @Override
    public boolean inventoryToCloseGuiScreen() {
        return !this.nameSignField.isFocused();
    }
}

