/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.events;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.player.PlayerHandler;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getWorld().field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PlayerHandler playerHandler = PlayerHandler.getFromPlayer(player);
            if (playerHandler == null || playerHandler.getHasInfo().booleanValue()) {
                return;
            }
            PlayerEventHandler.downloadProfile(playerHandler);
        }
    }

    public static void downloadProfile(final PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MinecraftCapes.getLogger().debug("Getting profile for {}", new Object[]{playerHandler.getPlayerUUID()});
                    URL url = new URL("https://minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
                    HttpURLConnection httpurlconnection = (HttpURLConnection)url.openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        InputStreamReader reader = new InputStreamReader(httpurlconnection.getInputStream(), "UTF-8");
                        ProfileResult profileResult = (ProfileResult)new Gson().fromJson((Reader)reader, ProfileResult.class);
                        ((Reader)reader).close();
                        playerHandler.setHasInfo(true);
                        playerHandler.setHasCapeGlint(profileResult.capeGlint);
                        playerHandler.setUpsideDown(profileResult.upsideDown);
                        if (profileResult.textures.get("cape") != null) {
                            playerHandler.applyCape((String)profileResult.textures.get("cape"));
                        }
                        if (profileResult.textures.get("ears") != null) {
                            playerHandler.applyEars((String)profileResult.textures.get("ears"));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private Map<String, String> textures = null;

        ProfileResult() {
        }
    }
}

