/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.helpers;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.Validate;

public class ScheduleTask {
    private static ScheduleTask instance;
    private final Queue<FutureTask<?>> scheduledTasks = Queues.newArrayDeque();

    public ScheduleTask() {
        instance = this;
    }

    public ListenableFuture<Object> addScheduledTask(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return this.addScheduledTask(Executors.callable(runnableToSchedule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> addScheduledTask(Callable<V> callableToSchedule) {
        Validate.notNull(callableToSchedule);
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callableToSchedule);
        Queue<FutureTask<?>> queue = this.scheduledTasks;
        synchronized (queue) {
            this.scheduledTasks.add((FutureTask<?>)listenablefuturetask);
            return listenablefuturetask;
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        while (!this.scheduledTasks.isEmpty()) {
            FutureTask<?> task = this.scheduledTasks.poll();
            task.run();
        }
    }

    public static ScheduleTask getInstance() {
        return instance;
    }
}

