/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.common.handlers;

import com.shinoow.darknesslib.api.DarknessLibAPI;
import com.shinoow.grue.Grue;
import com.shinoow.grue.common.entity.EntityGrue;
import com.shinoow.grue.common.entity.cap.GrueCapabilityProvider;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.integrations.gamestages.GameStagesHandler;
import com.shinoow.grue.common.network.PacketDispatcher;
import com.shinoow.grue.common.network.client.GrueTimerMessage;
import com.shinoow.grue.common.util.DimensionData;
import java.util.Arrays;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class GrueEventHandler {
    @SubscribeEvent
    public void spawnGrue(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving().field_70128_L || event.getEntityLiving().field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (player.func_175149_v()) {
                return;
            }
            if (player.func_184218_aH() && DarknessLibAPI.getInstance().isVehicle(player.func_184187_bx())) {
                return;
            }
            IGrueTimerCapability cap = (IGrueTimerCapability)player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
            DimensionData data = Grue.getDimensionConfig(player.field_71093_bK);
            if (data.shouldUseGracePeriod() && cap.getGracePeriodTimer() > 0) {
                cap.decrementGracePeriodTimer();
            } else if (this.isWhitelisted(player.field_71093_bK) && this.isWhitelisted(player.field_70170_p.func_180494_b(player.func_180425_c())) || Grue.whitelist_override.contains(player.field_71093_bK) || Grue.biome_whitelist_override.contains(player.field_70170_p.func_180494_b(player.func_180425_c()))) {
                int light;
                int n = light = Grue.dynLightPausesTimer ? DarknessLibAPI.getInstance().getLight((Entity)player, true) : DarknessLibAPI.getInstance().getLightWithAdditions(player, true);
                if (light <= data.getMaxLight() && light >= data.getMinLight() && GameStagesHandler.shouldGrueSpawn(player)) {
                    if (this.waterCheck(player) && (Grue.dynLightPausesTimer && !DarknessLibAPI.getInstance().isIlluminatedDynamically(player) || !Grue.dynLightPausesTimer) && this.isCorrectMoonPhase(player.field_70170_p, data.getMoonPhases()) && (data.isSingleGrue() && player.field_70170_p.func_72872_a(EntityGrue.class, player.func_174813_aQ().func_186662_g(10.0)).isEmpty() || !data.isSingleGrue())) {
                        cap.incrementTimer();
                        if (cap.getTimer() % 40 == 0) {
                            player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_whisper, SoundCategory.HOSTILE, 2.0f, 1.0f);
                        }
                        if (cap.getTimer() % 40 == 0) {
                            PacketDispatcher.sendTo(new GrueTimerMessage(player), (EntityPlayerMP)player);
                        }
                        if (cap.getTimer() >= data.getSpawnTimer() * 20 - 40 && this.flyingCloseEnough(player)) {
                            if (!cap.hasSpawnPosition()) {
                                cap.setSpawnPosition(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                            }
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 10));
                            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 200, 10));
                            if (cap.getTimer() % 4 == 0) {
                                player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_spawn, SoundCategory.HOSTILE, 2.0f, 1.0f);
                            }
                        }
                        if (cap.getTimer() >= data.getSpawnTimer() * 20 && this.flyingCloseEnough(player)) {
                            if (cap.getTimer() - 20 >= data.getSpawnTimer() * 20) {
                                player.field_70170_p.func_184133_a(null, player.func_180425_c(), Grue.grue_spawn, SoundCategory.HOSTILE, 2.0f, 1.0f);
                            }
                            cap.resetTimer();
                            EntityGrue grue = new EntityGrue(player.field_70170_p);
                            grue.func_82149_j((Entity)player);
                            grue.func_70107_b(this.stuff(data.shouldSpawnAtPlayer() ? player.field_70165_t : cap.getSpawnX()), data.shouldSpawnAtPlayer() ? player.field_70163_u : cap.getSpawnY(), this.stuff(data.shouldSpawnAtPlayer() ? player.field_70161_v : cap.getSpawnZ()));
                            cap.resetSpawnPosition();
                            player.field_70170_p.func_72838_d((Entity)grue);
                        }
                    }
                } else if ((light > data.getMaxLight() || light < data.getMinLight()) && cap.getTimer() > 0) {
                    cap.decrementTimer();
                    if (cap.getTimer() % 10 == 0 || cap.getTimer() == 1) {
                        PacketDispatcher.sendTo(new GrueTimerMessage(player), (EntityPlayerMP)player);
                    }
                }
            }
        }
    }

    private boolean flyingCloseEnough(EntityPlayer player) {
        if (Grue.flyHeight <= 0) {
            return true;
        }
        if (player.field_71075_bZ.field_75100_b || !player.field_70122_E) {
            Vec3d v = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            RayTraceResult mop = player.field_70170_p.func_72901_a(v, new Vec3d(player.field_70165_t, player.field_70163_u - 3.0, player.field_70161_v), true);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                return v.field_72448_b - mop.field_72307_f.field_72448_b <= (double)Grue.flyHeight;
            }
            return false;
        }
        return true;
    }

    private double stuff(double d0) {
        double d1 = MathHelper.func_76128_c((double)d0);
        if (d1 > d0) {
            return d1 - 0.5;
        }
        return d1 + 0.5;
    }

    private boolean isWhitelisted(int dim) {
        if (!Grue.useWhitelist) {
            return true;
        }
        if (!Grue.useBlacklist) {
            return Arrays.stream(Grue.dimWhitelist).anyMatch(id -> id == dim);
        }
        return Arrays.stream(Grue.dimWhitelist).noneMatch(id -> id == dim);
    }

    private boolean isWhitelisted(Biome biome) {
        return Grue.biome_whitelist.isEmpty() || Grue.useBiomeBlacklist ? !Grue.biome_whitelist.contains(biome) : Grue.biome_whitelist.contains(biome);
    }

    private boolean isCorrectMoonPhase(World world, double[] moonPhases) {
        if (!world.field_73011_w.func_76569_d() || world.func_72935_r() || moonPhases.length == 0) {
            return true;
        }
        for (double phase : moonPhases) {
            if ((double)world.func_130001_d() != phase) continue;
            return true;
        }
        return false;
    }

    private boolean waterCheck(EntityPlayer player) {
        boolean ret = player.field_70170_p.func_180495_p(player.func_180425_c()).func_185904_a() == Material.field_151586_h && player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b()).func_185904_a() != Material.field_151586_h && player.field_70170_p.func_180495_p(player.func_180425_c().func_177984_a()) == Blocks.field_150350_a.func_176223_P();
        return player.func_70090_H() && player.func_70086_ai() == 300 && ret || !player.func_70090_H();
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("grue", "gruetimer"), (ICapabilityProvider)new GrueCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        DimensionData data = Grue.getDimensionConfig(event.toDim);
        if (data.shouldUseGracePeriod()) {
            IGrueTimerCapability cap = (IGrueTimerCapability)event.player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
            cap.setGracePeriodTimer(data.getGracePeriod() * 20);
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            ((IGrueTimerCapability)event.getEntityPlayer().getCapability(GrueCapabilityProvider.GRUE_TIMER, null)).copy((IGrueTimerCapability)event.getOriginal().getCapability(GrueCapabilityProvider.GRUE_TIMER, null));
        }
    }
}

