/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GatekeeperHouseStructure
extends GelJigsawStructure {
    public GatekeeperHouseStructure(Codec<VillageConfig> config) {
        super(config, 0, true, true);
        this.setSpawnList(EntityClassification.MONSTER, (List)ImmutableList.of());
    }

    public double getProbability() {
        return 0.85;
    }

    public int getSpacing() {
        return 18;
    }

    public int getOffset() {
        return this.getSpacing() / 3;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)World.field_234918_g_.func_240901_a_());
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
            super(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(templateManager, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            GatekeeperEntity entity;
            if (key.equals("gatekeeper")) {
                this.setAir((IWorld)world, pos);
                entity = (GatekeeperEntity)this.createEntity(SkiesEntityTypes.GATEKEEPER, world, pos, this.field_214834_c);
                entity.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.homePos = pos;
                world.func_217376_c((Entity)entity);
            }
            if (key.equals("pig")) {
                this.setAir((IWorld)world, pos);
                entity = (PigEntity)this.createEntity(EntityType.field_200784_X, world, pos, this.field_214834_c);
                entity.func_213386_a(world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                world.func_217376_c((Entity)entity);
            }
        }

        public IStructurePieceType func_214807_k() {
            return SkiesStructures.GATEKEEPER_HOUSE.getPieceType();
        }
    }
}

