/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class BlindingDungeonStructure
extends GelStructure<NoFeatureConfig> {
    public BlindingDungeonStructure(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.setSpawnList(EntityClassification.MONSTER, (List)ImmutableList.of());
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom rand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPosIn, NoFeatureConfig config) {
        ChunkPos chunkPos = this.func_236392_a_(this.getSeparationSettings(), seed, rand, chunkPosX, chunkPosZ);
        for (Biome biome : biomeProvider.func_225530_a_(chunkPos.field_77276_a * 16 + 8, chunkGen.func_230356_f_(), chunkPos.field_77275_b * 16 + 8, 18)) {
            if (biome.func_242440_e().func_242493_a((Structure)this)) continue;
            return false;
        }
        if (chunkPos.field_77276_a == chunkPosX && chunkPos.field_77275_b == chunkPosZ) {
            rand.func_202427_a(seed, chunkPosX, chunkPosZ, this.getSeed());
            return rand.nextDouble() < this.getProbability() && BlindingDungeonStructure.getHighestY(chunkGen, chunkPos.field_77276_a, chunkPos.field_77275_b) >= 60;
        }
        return false;
    }

    public static int getHighestY(ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        int width = 18;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                y = Math.max(y, chunkGen.func_222529_a(x + i * width, z + j * width, Heightmap.Type.WORLD_SURFACE_WG));
            }
        }
        return y;
    }
}

