/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CaveWallFeature
extends AbstractCaveFeature<Config> {
    public CaveWallFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        int width = rand.nextInt(6) + 5;
        int height = rand.nextInt(6) + 5;
        int depth = rand.nextInt(6) + 5;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z)) continue;
                    BlockPos offsetPos = pos.func_177982_a(x, y, z);
                    boolean airInOneDir = world.func_175623_d(offsetPos.func_177978_c()) || world.func_175623_d(offsetPos.func_177968_d()) || world.func_175623_d(offsetPos.func_177974_f()) || world.func_175623_d(offsetPos.func_177976_e()) || world.func_175623_d(offsetPos.func_177977_b());
                    BlockState state = world.func_180495_p(offsetPos);
                    if (!SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains(state.func_177230_c()) || state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151598_x || world.func_175623_d(offsetPos.func_177984_a()) || !airInOneDir) continue;
                    if (rand.nextFloat() < 0.3f) {
                        this.func_230367_a_((IWorldWriter)world, offsetPos, config.accentBlock);
                        continue;
                    }
                    this.func_230367_a_((IWorldWriter)world, offsetPos, config.mainBlock);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        return world.func_175623_d(pos.func_177984_a());
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("main_block").forGetter(config -> config.mainBlock), (App)BlockState.field_235877_b_.fieldOf("accent_block").forGetter(config -> config.accentBlock)).apply((Applicative)instance, Config::new));
        public final BlockState mainBlock;
        public final BlockState accentBlock;

        public Config(BlockState mainBlock, BlockState accentBlock) {
            this.mainBlock = mainBlock;
            this.accentBlock = accentBlock;
        }

        public Config(BlockState mainBlock) {
            this(mainBlock, mainBlock);
        }
    }
}

