/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class AbstractCaveFeature<FC extends IFeatureConfig>
extends Feature<FC>
implements IStructureRestricted {
    public AbstractCaveFeature(Codec<FC> codec) {
        super(codec);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, FC config) {
        if (world instanceof ISeedReader) {
            int surfaceY = chunkGen.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE);
            if (pos.func_177956_o() + this.getMaxHeight(config) < surfaceY - 5 && this.isValidPos(world, chunkGen, rand, pos, config) && this.shouldGenerate(world, pos)) {
                return this.generate(world, chunkGen, rand, pos, config);
            }
        }
        return false;
    }

    public abstract boolean generate(ISeedReader var1, ChunkGenerator var2, Random var3, BlockPos var4, FC var5);

    public abstract boolean isValidPos(ISeedReader var1, ChunkGenerator var2, Random var3, BlockPos var4, FC var5);

    public int getMaxHeight(FC config) {
        return 2;
    }

    @Override
    public boolean isAllowedInside(Structure<?> structure) {
        return structure != SkiesStructures.POISON_DUNGEON.getStructure();
    }
}

