/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features.cave;

import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveSpawnerFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class EverbrightCaveSpawnerFeature
extends AbstractCaveSpawnerFeature {
    public EverbrightCaveSpawnerFeature(Codec<NoFeatureConfig> codec) {
        super(codec, new Simple(), new Room(), new Mineshaft());
    }

    private static class Mineshaft
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Mineshaft() {
            super(SkiesEntityTypes.SHRUMPTY, "everbright_mineshaft");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.turquoise_stone && rand.nextFloat() < 0.25f) {
                return SkiesBlocks.turquoise_cobblestone.func_176223_P();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERBRIGHT_CAVE_SPAWNER;
        }
    }

    private static class Room
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Room() {
            super(SkiesEntityTypes.ARMORED_FROST_SPIRIT, "everbright_room");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.turquoise_stonebrick) {
                if (rand.nextFloat() < 0.6f) {
                    if (rand.nextFloat() < 0.85f) {
                        return SkiesBlocks.cracked_turquoise_stonebrick.func_176223_P();
                    }
                    return SkiesBlocks.chiseled_turquoise_stonebrick.func_176223_P();
                }
                return originalState;
            }
            if (originalState.func_177230_c() == SkiesBlocks.turquoise_stonebrick_slab && rand.nextFloat() < 0.5f) {
                return (BlockState)((BlockState)SkiesBlocks.cracked_turquoise_stonebrick_slab.func_176223_P().func_206870_a((Property)SlabBlock.field_196505_a, originalState.func_177229_b((Property)SlabBlock.field_196505_a))).func_206870_a((Property)SlabBlock.field_204512_b, originalState.func_177229_b((Property)SlabBlock.field_204512_b));
            }
            if (originalState.func_177230_c() == SkiesBlocks.turquoise_stonebrick_stairs && rand.nextFloat() < 0.5f) {
                return (BlockState)((BlockState)((BlockState)((BlockState)SkiesBlocks.cracked_turquoise_stonebrick_stairs.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, originalState.func_177229_b((Property)StairsBlock.field_176309_a))).func_206870_a((Property)StairsBlock.field_176308_b, originalState.func_177229_b((Property)StairsBlock.field_176308_b))).func_206870_a((Property)StairsBlock.field_176310_M, originalState.func_177229_b((Property)StairsBlock.field_176310_M))).func_206870_a((Property)StairsBlock.field_204513_t, originalState.func_177229_b((Property)StairsBlock.field_204513_t));
            }
            if (originalState.func_177230_c() == SkiesBlocks.frose && (double)rand.nextFloat() < 0.75) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERBRIGHT_CAVE_SPAWNER;
        }
    }

    private static class Simple
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Simple() {
            super(SkiesEntityTypes.ARMORED_FROST_SPIRIT, "everbright_simple");
        }

        @Override
        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.func_177230_c() == SkiesBlocks.turquoise_stone && rand.nextFloat() < 0.64f) {
                return SkiesBlocks.cracked_turquoise_stonebrick.func_176223_P();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERBRIGHT_CAVE_SPAWNER;
        }
    }
}

