/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.blocks.natural.BrumbleVineTopBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BrumbleVineFeature
extends Feature<NoFeatureConfig> {
    public BrumbleVineFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        this.placeVine(world, pos, rand, 10);
        int extraVines = rand.nextInt(2) + 2;
        for (int i = 0; i < extraVines; ++i) {
            this.placeVine(world, pos.func_177982_a(rand.nextInt(11) - 5, 0, rand.nextInt(11) - 5), rand, rand.nextInt(3) + 2);
        }
        return true;
    }

    private void placeVine(ISeedReader world, BlockPos pos, Random rand, int minHeight) {
        int height;
        pos = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos);
        int maxHeight = rand.nextInt(5) + minHeight;
        for (height = 0; height < world.func_181545_F() && height < maxHeight; ++height) {
        }
        for (int y = 0; y < height; ++y) {
            BlockState vineState;
            BlockPos offsetPos = pos.func_177981_b(y);
            BlockState top = (BlockState)SkiesBlocks.brumble_vine_top.func_176223_P().func_206870_a((Property)BrumbleVineTopBlock.field_235502_d_, (Comparable)Integer.valueOf(25));
            BlockState blockState = vineState = y == height - 1 ? top : SkiesBlocks.brumble_vine.func_176223_P();
            if (world.func_180495_p(offsetPos).func_177230_c() != Blocks.field_150355_j || !vineState.func_196955_c((IWorldReader)world, offsetPos)) {
                if (world.func_180495_p(offsetPos.func_177977_b()).func_177230_c() != SkiesBlocks.brumble_vine) break;
                world.func_180501_a(offsetPos.func_177977_b(), top, 2);
                break;
            }
            world.func_180501_a(offsetPos, vineState, 2);
        }
    }
}

