/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright;

import com.legacy.blue_skies.client.audio.ambient.SkiesWeatherAmbientSounds;
import com.legacy.blue_skies.client.audio.ambient.SnowstormAmbientSoundHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.IWeatherRenderHandler;

public class BrightWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private int rendererUpdateCount;
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private ISound snowWind;
    private IAmbientSoundHandler ambientSoundHandler;
    public static final BrightWeatherRenderer INSTANCE = new BrightWeatherRenderer();

    public BrightWeatherRenderer() {
        this.ambientSoundHandler = new SnowstormAmbientSoundHandler(Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().func_147118_V());
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc, LightTexture lightmapIn, double xIn, double yIn, double zIn) {
        this.renderRainSnow(partialTicks, mc, xIn, yIn, zIn);
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        this.playWeatherSounds(mc);
    }

    public void onUpdate() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++this.rendererUpdateCount;
        }
    }

    protected void renderRainSnow(float partialTicks, Minecraft mc, double xIn, double yIn, double zIn) {
        LightTexture lightmapIn = mc.field_71460_t.func_228384_l_();
        float f = mc.field_71441_e.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            lightmapIn.func_205109_c();
            ClientWorld world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)xIn);
            int j = MathHelper.func_76128_c((double)yIn);
            int k = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int l = 5;
            if (Minecraft.func_71375_t()) {
                l = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int i1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainXCoords[l1] * 0.5;
                    double d1 = (double)this.rainYCoords[l1] * 0.5;
                    blockpos$mutable.func_181079_c(k1, 0, j1);
                    Biome biome = world.func_226691_t_((BlockPos)blockpos$mutable);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int i2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutable).func_177956_o();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761);
                    blockpos$mutable.func_181079_c(k1, j2, j1);
                    float f2 = biome.func_225486_c((BlockPos)blockpos$mutable);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            i1 = 0;
                            mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = this.rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)k1 + 0.5f) - xIn;
                        double d4 = (double)((float)j1 + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutable.func_181079_c(k1, l2, j1);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        i1 = 1;
                        mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float f6 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.005 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.0);
                    double d3 = (double)((float)k1 + 0.5f) - xIn;
                    double d5 = (double)((float)j1 + 0.5f) - zIn;
                    float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutable.func_181079_c(k1, l2, j1);
                    int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockpos$mutable);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = (k3 & 0xFFFF) * 3;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)k2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn + d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn + d1 + 0.5).func_225583_a_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    bufferbuilder.func_225582_a_((double)k1 - xIn - d0 + 0.5, (double)j2 - yIn, (double)j1 - zIn - d1 + 0.5).func_225583_a_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                }
            }
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmapIn.func_205108_b();
        }
    }

    private void playWeatherSounds(Minecraft mc) {
        mc.field_71441_e.field_73012_v.setSeed((long)this.rendererUpdateCount * 312987231L);
        Entity entity = mc.func_175606_aa();
        BlockPos blockpos = entity.func_233580_cy_();
        SoundHandler soundHandler = mc.func_147118_V();
        ClientWorld world = mc.field_71441_e;
        if (mc.field_71441_e.func_72896_J() && mc.field_71441_e.func_226691_t_(blockpos).func_201851_b() == Biome.RainType.SNOW && mc.field_71439_g != null) {
            boolean shouldPlay;
            this.ambientSoundHandler.func_204253_a();
            boolean shouldStopPlaying = world.func_226658_a_(LightType.SKY, blockpos) <= 0;
            boolean bl = shouldPlay = world.func_72896_J() && world.func_226691_t_(blockpos).func_201851_b() != Biome.RainType.NONE && !shouldStopPlaying;
            if (shouldPlay && (this.snowWind != null && !soundHandler.func_215294_c(this.snowWind) || this.snowWind == null && !soundHandler.func_215294_c(this.snowWind))) {
                this.snowWind = new SkiesWeatherAmbientSounds.SnowWindSound(mc.field_71439_g);
                soundHandler.func_147682_a(this.snowWind);
            }
        }
    }
}

