/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world;

import com.legacy.blue_skies.util.MLSimplexNoise;
import com.legacy.blue_skies.world.general_features.carver.SkyNoiseCarver;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.carver.ConfiguredCarver;

public class SkiesNoiseChunkGenerator
extends NoiseChunkGenerator {
    public static final Codec<SkiesNoiseChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(chunkGen -> chunkGen.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(chunkGen -> chunkGen.field_236084_w_), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(chunkGen -> chunkGen.field_236080_h_)).apply((Applicative)instance, instance.stable(SkiesNoiseChunkGenerator::new)));
    public final MLSimplexNoise caveNoise;
    public final long field_236084_w_;

    public SkiesNoiseChunkGenerator(BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> dimSettings) {
        super(biomeProvider, seed, dimSettings);
        this.field_236084_w_ = seed;
        this.caveNoise = new MLSimplexNoise(seed);
    }

    public void func_230350_a_(long seed, BiomeManager biomeManager, IChunk chunk, GenerationStage.Carving carvingStage) {
        BiomeManager biomeManagerSource = biomeManager.func_226835_a_(this.field_222542_c);
        SharedSeedRandom sharedSeedRand = new SharedSeedRandom();
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        BiomeGenerationSettings biomeGenSettings = this.field_222542_c.func_225526_b_(chunkPos.field_77276_a << 2, 0, chunkPos.field_77275_b << 2).func_242440_e();
        BitSet carvingMask = ((ChunkPrimer)chunk).func_230345_b_(carvingStage);
        for (int xOffset = chunkX - 8; xOffset <= chunkX + 8; ++xOffset) {
            for (int zOffset = chunkZ - 8; zOffset <= chunkZ + 8; ++zOffset) {
                List carvers = biomeGenSettings.func_242489_a(carvingStage);
                ListIterator carverIterator = carvers.listIterator();
                while (carverIterator.hasNext()) {
                    int index = carverIterator.nextIndex();
                    ConfiguredCarver configuredCarver = (ConfiguredCarver)((Supplier)carverIterator.next()).get();
                    sharedSeedRand.func_202425_c(seed + (long)index, xOffset, zOffset);
                    if (configuredCarver.field_222732_a instanceof SkyNoiseCarver) {
                        if (xOffset - chunkX != 0 || zOffset - chunkZ != 0) continue;
                        ((SkyNoiseCarver)configuredCarver.field_222732_a).carve(chunk, (Random)sharedSeedRand, chunkX, chunkZ, this.caveNoise);
                        continue;
                    }
                    if (!configuredCarver.func_222730_a((Random)sharedSeedRand, xOffset, zOffset)) continue;
                    configuredCarver.func_227207_a_(chunk, arg_0 -> ((BiomeManager)biomeManagerSource).func_226836_a_(arg_0), (Random)sharedSeedRand, this.func_230356_f_(), xOffset, zOffset, chunkX, chunkZ, carvingMask);
                }
            }
        }
    }
}

