/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entity;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkyChestTileEntity
extends ChestTileEntity {
    private static final Map<Block, Supplier<SkyChestTileEntity>> CHEST_TILE_MAP = new HashMap<Block, Supplier<SkyChestTileEntity>>(){
        private static final long serialVersionUID = 1330864239328322882L;
        {
            this.put(SkiesBlocks.bluebright_chest, BluebrightChestTileEntity::new);
            this.put(SkiesBlocks.starlit_chest, StarlitChestTileEntity::new);
            this.put(SkiesBlocks.frostbright_chest, FrostbrightChestTileEntity::new);
            this.put(SkiesBlocks.lunar_chest, LunarChestTileEntity::new);
            this.put(SkiesBlocks.dusk_chest, DuskChestTileEntity::new);
            this.put(SkiesBlocks.maple_chest, MapleChestTileEntity::new);
            this.put(SkiesBlocks.cherry_chest, CherryChestTileEntity::new);
        }
    };
    private final TranslationTextComponent localizedName;

    public SkyChestTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.localizedName = new TranslationTextComponent("block.blue_skies." + typeIn.getRegistryName().func_110623_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public static SkyChestTileEntity getFromBlock(Block blockIn) {
        return CHEST_TILE_MAP.get(blockIn).get();
    }

    protected ITextComponent func_213907_g() {
        return this.localizedName;
    }

    public static class CherryChestTileEntity
    extends SkyChestTileEntity {
        public CherryChestTileEntity() {
            super(SkiesTileEntityTypes.CHERRY_CHEST);
        }
    }

    public static class MapleChestTileEntity
    extends SkyChestTileEntity {
        public MapleChestTileEntity() {
            super(SkiesTileEntityTypes.MAPLE_CHEST);
        }
    }

    public static class DuskChestTileEntity
    extends SkyChestTileEntity {
        public DuskChestTileEntity() {
            super(SkiesTileEntityTypes.DUSK_CHEST);
        }
    }

    public static class LunarChestTileEntity
    extends SkyChestTileEntity {
        public LunarChestTileEntity() {
            super(SkiesTileEntityTypes.LUNAR_CHEST);
        }
    }

    public static class FrostbrightChestTileEntity
    extends SkyChestTileEntity {
        public FrostbrightChestTileEntity() {
            super(SkiesTileEntityTypes.FROSTBRIGHT_CHEST);
        }
    }

    public static class StarlitChestTileEntity
    extends SkyChestTileEntity {
        public StarlitChestTileEntity() {
            super(SkiesTileEntityTypes.STARLIT_CHEST);
        }
    }

    public static class BluebrightChestTileEntity
    extends SkyChestTileEntity {
        public BluebrightChestTileEntity() {
            super(SkiesTileEntityTypes.BLUEBRIGHT_CHEST);
        }
    }
}

