/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructureProcessors;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.BunkerPools;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.BunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHousePools;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseStructure;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillagePools;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageStructure;
import com.legacy.blue_skies.world.util.structure_processors.RemoveSnowStructureProcessor;
import com.legacy.structure_gel.registrars.GelStructureRegistrar;
import com.legacy.structure_gel.registrars.StructureRegistrar2;
import com.legacy.structure_gel.util.GelCollectors;
import com.legacy.structure_gel.util.RegistryHelper;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesStructures {
    public static final StructureRegistrar2<VillageConfig, BunkerStructure> BUNKER = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("everbright_dungeon"), (GelStructure)new BunkerStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), BunkerStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> BunkerPools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<NoFeatureConfig, EverbrightBlindingDungeonStructure> EVERBRIGHT_BLINDING_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("everbright_blinding_dungeon"), (GelStructure)new EverbrightBlindingDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), EverbrightBlindingDungeonPieces.Piece::new, (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<NoFeatureConfig, EverdawnBlindingDungeonStructure> EVERDAWN_BLINDING_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("everdawn_blinding_dungeon"), (GelStructure)new EverdawnBlindingDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), EverdawnBlindingDungeonPieces.Piece::new, (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<NoFeatureConfig, NatureDungeonStructure> NATURE_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("nature_dungeon"), (GelStructure)new NatureDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), (Map)ImmutableMap.of((Object)"main", NatureDungeonPieces.Piece::new, (Object)"garden", NatureDungeonPieces.GardenPiece::new, (Object)"stone_fill", NatureDungeonPieces.StoneFillPiece::new, (Object)"air_bubble", NatureDungeonPieces.AirBubblePiece::new), (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<NoFeatureConfig, PoisonDungeonStructure> POISON_DUNGEON = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("poison_dungeon"), (GelStructure)new PoisonDungeonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), PoisonDungeonPieces.Piece::new, (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<VillageConfig, GatekeeperHouseStructure> GATEKEEPER_HOUSE = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("gatekeeper_house"), (GelStructure)new GatekeeperHouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), GatekeeperHouseStructure.Piece::new, (Map)ImmutableMap.of((Object)"plains", (Object)new VillageConfig(() -> GatekeeperHousePools.PLAINS, 7), (Object)"snowy", (Object)new VillageConfig(() -> GatekeeperHousePools.SNOWY, 7), (Object)"mountain", (Object)new VillageConfig(() -> GatekeeperHousePools.MOUNTAIN, 7)), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<VillageConfig, SkiesVillageStructure> BLUE_SKIES_VILLAGE = GelStructureRegistrar.of((ResourceLocation)BlueSkies.locate("village"), (GelStructure)new SkiesVillageStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), SkiesVillageStructure.Piece::new, (Map)GelCollectors.mapOf(String.class, VillageConfig.class, (Object[])new Object[]{SkiesVillageBiomes.CALMING_SKIES.toString(), new VillageConfig(() -> SkiesVillagePools.CALMING_SKIES, 6), SkiesVillageBiomes.BRIGHTLANDS.toString(), new VillageConfig(() -> SkiesVillagePools.BRIGHTLANDS, 6), SkiesVillageBiomes.SLUSHLANDS.toString(), new VillageConfig(() -> SkiesVillagePools.SLUSHLANDS, 6), SkiesVillageBiomes.SHADED_WOODLANDS.toString(), new VillageConfig(() -> SkiesVillagePools.SHADED_WOODLANDS, 6), SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString(), new VillageConfig(() -> SkiesVillagePools.SUNSET_MAPLE_FOREST, 6), SkiesVillageBiomes.CRYSTAL_DUNES.toString(), new VillageConfig(() -> SkiesVillagePools.CRYSTAL_DUNES, 6)}), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static Structure<?>[] dungeons = new Structure[0];

    public static void init(RegistryEvent.Register<Structure<?>> event) {
        SkiesStructureProcessors.init();
        Processors.init();
        BunkerPools.init();
        RegistryHelper.handleRegistrar(BUNKER, (IForgeRegistry)event.getRegistry());
        RegistryHelper.handleRegistrar(EVERBRIGHT_BLINDING_DUNGEON, (IForgeRegistry)event.getRegistry());
        RegistryHelper.handleRegistrar(EVERDAWN_BLINDING_DUNGEON, (IForgeRegistry)event.getRegistry());
        RegistryHelper.handleRegistrar(NATURE_DUNGEON, (IForgeRegistry)event.getRegistry());
        RegistryHelper.handleRegistrar(POISON_DUNGEON, (IForgeRegistry)event.getRegistry());
        GatekeeperHousePools.init();
        RegistryHelper.handleRegistrar(GATEKEEPER_HOUSE, (IForgeRegistry)event.getRegistry());
        SkiesVillagePools.init();
        RegistryHelper.handleRegistrar(BLUE_SKIES_VILLAGE, (IForgeRegistry)event.getRegistry());
        dungeons = new Structure[]{EVERBRIGHT_BLINDING_DUNGEON.getStructure(), EVERDAWN_BLINDING_DUNGEON.getStructure(), NATURE_DUNGEON.getStructure(), POISON_DUNGEON.getStructure()};
    }

    public static class Processors {
        public static final StructureProcessorList DECAY_TURQUOISE_STONEBRICK = Processors.register("decay_turquoise_stonebrick", new StructureProcessorList((List)ImmutableList.of((Object)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.1f, SkiesBlocks.mossy_turquoise_stonebrick), (Object)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.2f, SkiesBlocks.cracked_turquoise_stonebrick))));
        public static final StructureProcessorList REMOVE_SNOW = Processors.register("remove_snow", RemoveSnowStructureProcessor.INSTANCE);
        public static final StructureProcessorList SWAP_PORTAL = Processors.register("swap_portal", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stonebrick, SkiesBlocks.turquoise_stonebrick));
        public static final StructureProcessorList MODIFY_GRASS = Processors.register("modify_grass", (StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150348_b), Blocks.field_150348_b.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150351_n), Blocks.field_150348_b.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150350_a), Blocks.field_150348_b.func_176223_P()))));
        public static final StructureProcessorList MODIFY_PATH = Processors.register("modify_path", (StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P()))));
        public static final StructureProcessorList SWAP_PORTAL_MODIFY_GRASS = Processors.register("swap_portal_modify_grass", RegistryHelper.combineProcessors((StructureProcessorList[])new StructureProcessorList[]{SWAP_PORTAL, MODIFY_GRASS}));
        public static final StructureProcessorList SWAP_PORTAL_REMOVE_SNOW = Processors.register("swap_portal_remove_snow", RegistryHelper.combineProcessors((StructureProcessorList[])new StructureProcessorList[]{SWAP_PORTAL, REMOVE_SNOW}));
        public static final StructureProcessorList CALMING_SKIES_STREET = Processors.register("calming_skies_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.bluebright_planks));
        public static final StructureProcessorList BRIGHTLANDS_STREET = Processors.register("brightlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.starlit_planks));
        public static final StructureProcessorList SLUSHLANDS_STREET = Processors.register("slushlands_street", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.frostbright_planks, 0.2f, SkiesBlocks.stripped_frostbright_wood));
        public static final StructureProcessorList SHADED_WOODLANDS_STREET = Processors.register("shaded_woodlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_planks));
        public static final StructureProcessorList SUNSET_MAPLE_FOREST_STREET = Processors.register("sunset_maple_forest_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.maple_planks));
        public static final StructureProcessorList CRYSTAL_DUNES = Processors.register("crystal_dunes_street", new StructureProcessorList((List)ImmutableList.of()));

        public static void init() {
        }

        private static StructureProcessorList register(String key, StructureProcessor processor) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessor)processor);
        }

        private static StructureProcessorList register(String key, StructureProcessorList processorList) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessorList)processorList);
        }

        private static RuleStructureProcessor makeVillagePath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial) {
            return new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(path), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), bridgeMaterial.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(path, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, grassBlock.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(grassBlock), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(dirt), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), bridgeMaterial.func_176223_P())));
        }
    }
}

