/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.legacy.blue_skies.blocks.natural.BrewberryBushBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.world.everbright.EverbrightCanyonWorldCarver;
import com.legacy.blue_skies.world.everbright.EverbrightCaveWorldCarver;
import com.legacy.blue_skies.world.everbright.gen.features.BluebrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.BrumbleFeature;
import com.legacy.blue_skies.world.everbright.gen.features.BrumbleVineFeature;
import com.legacy.blue_skies.world.everbright.gen.features.ChilledLilyFeature;
import com.legacy.blue_skies.world.everbright.gen.features.FallenLogFeature;
import com.legacy.blue_skies.world.everbright.gen.features.FrostbrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.OceanSpikeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.PatchySnowFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SeaMossFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SkyIceAndSnowFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SmallPineTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SnowcapMushroomFeature;
import com.legacy.blue_skies.world.everbright.gen.features.StarlitTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.cave.EverbrightCaveSpawnerFeature;
import com.legacy.blue_skies.world.everbright.gen.features.cave.GiantCaveIcicleFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.CrescentFruitTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.CrystalizedTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.DuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.GlimmerReedFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LargeDuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LunarTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MapleTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MoonlitWaterLilyFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MoonstoneSpikeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.ReservoirTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.ShortMoonstoneSpikeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveCrystalFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveMagmaFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.CaveWallCrystalFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.EverdawnCaveSpawnerFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.cave.LunarLavaSpireFeature;
import com.legacy.blue_skies.world.general_features.BushFeature;
import com.legacy.blue_skies.world.general_features.CherryTreeFeature;
import com.legacy.blue_skies.world.general_features.LargeRockFeature;
import com.legacy.blue_skies.world.general_features.SkyLakesFeature;
import com.legacy.blue_skies.world.general_features.carver.SkyCanyonWorldCarver;
import com.legacy.blue_skies.world.general_features.carver.SkyCaveWorldCarver;
import com.legacy.blue_skies.world.general_features.carver.SkyNoiseCarver;
import com.legacy.blue_skies.world.general_features.carver.UnderwaterSkiesCanyonWorldCarver;
import com.legacy.blue_skies.world.general_features.carver.UnderwaterSkiesCaveWorldCarver;
import com.legacy.blue_skies.world.general_features.cave.CaveGrassFeature;
import com.legacy.blue_skies.world.general_features.cave.CavePlantFeature;
import com.legacy.blue_skies.world.general_features.cave.CaveVineFeature;
import com.legacy.blue_skies.world.general_features.cave.CaveWallFeature;
import com.legacy.blue_skies.world.general_features.cave.SkyDripstoneFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.EmptyCarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesFeatures {
    private static IForgeRegistry<Feature<?>> registry;
    public static final TreeFeature BLUEBRIGHT_TREE;
    public static final TreeFeature STARLIT_TREE;
    public static final TreeFeature FROSTBRIGHT_TREE;
    public static final TreeFeature FROSTBRIGHT_TREE_UNNATURAL;
    public static final TreeFeature LUNAR_TREE;
    public static final TreeFeature DUSK_TREE;
    public static final TreeFeature LARGE_DUSK_TREE;
    public static final TreeFeature LARGE_DUSK_TREE_UNNATURAL;
    public static final TreeFeature MAPLE_TREE;
    public static final TreeFeature MAPLE_TREE_UNNATURAL;
    public static final TreeFeature CRESCENT_FRUIT_TREE;
    public static final TreeFeature CHERRY_TREE;
    public static final TreeFeature NATURE_CHERRY_TREE;
    public static final TreeFeature SMALL_BLUEBRIGHT_TREE;
    public static final TreeFeature SMALL_STARLIT_TREE;
    public static final TreeFeature SMALL_FROSTBRIGHT_TREE;
    public static final TreeFeature RESERVOIR_TREE;
    public static final TreeFeature CRYSTALIZED_TREE;
    public static final TreeFeature GROWN_CRYSTALIZED_TREE;
    public static final TreeFeature SNOWCAP_MUSHROOM;
    public static final Feature<NoFeatureConfig> CHILLED_LILY;
    public static final Feature<MoonstoneSpikeFeature.Config> MOONSTONE_SPIKE;
    public static final Feature<BlockStateFeatureConfig> EVERBRIGHT_LAKE;
    public static final Feature<BlockStateFeatureConfig> EVERDAWN_LAKE;
    public static final Feature<OreFeatureConfig> ORE;
    public static final Feature<BushFeature.Config> BUSH;
    public static final Feature<FallenLogFeature.Config> FALLEN_LOG;
    public static final Feature<BlockStateFeatureConfig> LARGE_ROCK;
    public static final Feature<NoFeatureConfig> SEA_MOSS;
    public static final Feature<NoFeatureConfig> GLIMMER_REEDS;
    public static final Feature<NoFeatureConfig> MOONLIT_WATER_LILIES;
    public static final Feature<NoFeatureConfig> OCEAN_SPIKE;
    public static final Feature<NoFeatureConfig> BRUMBLE;
    public static final Feature<NoFeatureConfig> BRUMBLE_VINE;
    public static final Feature<NoFeatureConfig> SHORT_MOONSTONE_SPIKE;
    public static final Feature<NoFeatureConfig> PATCHY_SNOW;
    public static final Feature<NoFeatureConfig> ICE_AND_SNOW_NO_PATH;
    public static final Feature<NoFeatureConfig> LUNAR_LAVA_SPIRE;
    public static final Feature<CaveVineFeature.Config> CAVE_VINE;
    public static final Feature<CaveGrassFeature.Config> CAVE_GRASS;
    public static final Feature<CaveWallFeature.Config> CAVE_WALL;
    public static final Feature<SkyDripstoneFeature.Config> DRIPSTONE;
    public static final Feature<NoFeatureConfig> MOONSTONE_CAVE_CRYSTAL;
    public static final Feature<CavePlantFeature.Config> CAVE_PLANT;
    public static final Feature<CaveWallCrystalFeature.Config> CAVE_WALL_CRYSTAL;
    public static final Feature<NoFeatureConfig> CAVE_MAGMA;
    public static final Feature<NoFeatureConfig> GIANT_CAVE_ICICLE;
    public static final Feature<NoFeatureConfig> EVERBRIGHT_CAVE_SPAWNER;
    public static final Feature<NoFeatureConfig> EVERDAWN_CAVE_SPAWNER;

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        registry = event.getRegistry();
        SkiesFeatures.register("bluebright_tree", BLUEBRIGHT_TREE);
        SkiesFeatures.register("starlit_tree", STARLIT_TREE);
        SkiesFeatures.register("frostbright_tree", FROSTBRIGHT_TREE);
        SkiesFeatures.register("frostbright_tree_unnatural", FROSTBRIGHT_TREE_UNNATURAL);
        SkiesFeatures.register("lunar_tree", LUNAR_TREE);
        SkiesFeatures.register("dusk_tree", DUSK_TREE);
        SkiesFeatures.register("large_dusk_tree", LARGE_DUSK_TREE);
        SkiesFeatures.register("large_dusk_tree_unnatural", LARGE_DUSK_TREE_UNNATURAL);
        SkiesFeatures.register("maple_tree", MAPLE_TREE);
        SkiesFeatures.register("maple_tree_unnatural", MAPLE_TREE_UNNATURAL);
        SkiesFeatures.register("crescent_fruit_tree", CRESCENT_FRUIT_TREE);
        SkiesFeatures.register("cherry_tree", CHERRY_TREE);
        SkiesFeatures.register("nature_cherry_tree", NATURE_CHERRY_TREE);
        SkiesFeatures.register("small_bluebright_tree", SMALL_BLUEBRIGHT_TREE);
        SkiesFeatures.register("small_starlit_tree", SMALL_STARLIT_TREE);
        SkiesFeatures.register("small_frostbright_tree", SMALL_FROSTBRIGHT_TREE);
        SkiesFeatures.register("reservoir_tree", RESERVOIR_TREE);
        SkiesFeatures.register("crystalized_tree", CRYSTALIZED_TREE);
        SkiesFeatures.register("snowcap_mushroom", SNOWCAP_MUSHROOM);
        SkiesFeatures.register("chilled_lily", CHILLED_LILY);
        SkiesFeatures.register("moonstone_spike", MOONSTONE_SPIKE);
        SkiesFeatures.register("short_moonstone_spike", SHORT_MOONSTONE_SPIKE);
        SkiesFeatures.register("everbright_lake", EVERBRIGHT_LAKE);
        SkiesFeatures.register("everdawn_lake", EVERDAWN_LAKE);
        SkiesFeatures.register("bush", BUSH);
        SkiesFeatures.register("fallen_log", FALLEN_LOG);
        SkiesFeatures.register("large_rock", LARGE_ROCK);
        SkiesFeatures.register("glimmer_reeds", GLIMMER_REEDS);
        SkiesFeatures.register("moonlit_water_lilies", MOONLIT_WATER_LILIES);
        SkiesFeatures.register("sea_moss", SEA_MOSS);
        SkiesFeatures.register("ocean_spike", OCEAN_SPIKE);
        SkiesFeatures.register("brumble", BRUMBLE);
        SkiesFeatures.register("brumble_vine", BRUMBLE_VINE);
        SkiesFeatures.register("patchy_snow", PATCHY_SNOW);
        SkiesFeatures.register("ice_and_snow_no_path", ICE_AND_SNOW_NO_PATH);
        SkiesFeatures.register("lunar_lava_spire", LUNAR_LAVA_SPIRE);
        SkiesFeatures.register("cave_vine", CAVE_VINE);
        SkiesFeatures.register("cave_grass", CAVE_GRASS);
        SkiesFeatures.register("cave_wall", CAVE_WALL);
        SkiesFeatures.register("dripstone", DRIPSTONE);
        SkiesFeatures.register("moonstone_cave_crystal", MOONSTONE_CAVE_CRYSTAL);
        SkiesFeatures.register("cave_plant", CAVE_PLANT);
        SkiesFeatures.register("cave_wall_crystal", CAVE_WALL_CRYSTAL);
        SkiesFeatures.register("cave_magma", CAVE_MAGMA);
        SkiesFeatures.register("giant_cave_icicle", GIANT_CAVE_ICICLE);
        SkiesFeatures.register("everbright_cave_spawner", EVERBRIGHT_CAVE_SPAWNER);
        SkiesFeatures.register("everdawn_cave_spawner", EVERDAWN_CAVE_SPAWNER);
    }

    private static void register(String key, Feature<?> feature) {
        SkiesRegistry.register(registry, key, feature);
    }

    static {
        BLUEBRIGHT_TREE = new BluebrightTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 5);
        STARLIT_TREE = new StarlitTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
        FROSTBRIGHT_TREE = new FrostbrightTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true);
        FROSTBRIGHT_TREE_UNNATURAL = new FrostbrightTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false);
        LUNAR_TREE = new LunarTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 5);
        DUSK_TREE = new DuskTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 5);
        LARGE_DUSK_TREE = new LargeDuskTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true);
        LARGE_DUSK_TREE_UNNATURAL = new LargeDuskTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false);
        MAPLE_TREE = new MapleTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true);
        MAPLE_TREE_UNNATURAL = new MapleTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false);
        CRESCENT_FRUIT_TREE = new CrescentFruitTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
        CHERRY_TREE = new CherryTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false);
        NATURE_CHERRY_TREE = new CherryTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true);
        SMALL_BLUEBRIGHT_TREE = new SmallPineTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 3, SkiesBlocks.bluebright_leaves.func_176223_P(), SkiesBlocks.bluebright_log.func_176223_P());
        SMALL_STARLIT_TREE = new SmallPineTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 5, SkiesBlocks.starlit_leaves.func_176223_P(), SkiesBlocks.starlit_log.func_176223_P());
        SMALL_FROSTBRIGHT_TREE = new SmallPineTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 6, SkiesBlocks.frostbright_leaves.func_176223_P(), SkiesBlocks.frostbright_log.func_176223_P());
        RESERVOIR_TREE = new ReservoirTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, 7);
        CRYSTALIZED_TREE = new CrystalizedTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, true);
        GROWN_CRYSTALIZED_TREE = new CrystalizedTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_, false);
        SNOWCAP_MUSHROOM = new SnowcapMushroomFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
        CHILLED_LILY = new ChilledLilyFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        MOONSTONE_SPIKE = new MoonstoneSpikeFeature(MoonstoneSpikeFeature.Config.CODEC);
        EVERBRIGHT_LAKE = new SkyLakesFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_, false);
        EVERDAWN_LAKE = new SkyLakesFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_, true);
        ORE = Feature.field_202290_aj;
        BUSH = new BushFeature(BushFeature.Config.CODEC);
        FALLEN_LOG = new FallenLogFeature(FallenLogFeature.Config.CODEC);
        LARGE_ROCK = new LargeRockFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_);
        SEA_MOSS = new SeaMossFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GLIMMER_REEDS = new GlimmerReedFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        MOONLIT_WATER_LILIES = new MoonlitWaterLilyFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        OCEAN_SPIKE = new OceanSpikeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        BRUMBLE = new BrumbleFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        BRUMBLE_VINE = new BrumbleVineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        SHORT_MOONSTONE_SPIKE = new ShortMoonstoneSpikeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        PATCHY_SNOW = new PatchySnowFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        ICE_AND_SNOW_NO_PATH = new SkyIceAndSnowFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        LUNAR_LAVA_SPIRE = new LunarLavaSpireFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        CAVE_VINE = new CaveVineFeature(CaveVineFeature.Config.CODEC);
        CAVE_GRASS = new CaveGrassFeature(CaveGrassFeature.Config.CODEC);
        CAVE_WALL = new CaveWallFeature(CaveWallFeature.Config.CODEC);
        DRIPSTONE = new SkyDripstoneFeature(SkyDripstoneFeature.Config.CODEC);
        MOONSTONE_CAVE_CRYSTAL = new CaveCrystalFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        CAVE_PLANT = new CavePlantFeature(CavePlantFeature.Config.CODEC);
        CAVE_WALL_CRYSTAL = new CaveWallCrystalFeature(CaveWallCrystalFeature.Config.CODEC);
        CAVE_MAGMA = new CaveMagmaFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GIANT_CAVE_ICICLE = new GiantCaveIcicleFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        EVERBRIGHT_CAVE_SPAWNER = new EverbrightCaveSpawnerFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        EVERDAWN_CAVE_SPAWNER = new EverdawnCaveSpawnerFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    }

    public static class Carvers {
        public static final Set<Block> CARVABLE_BLOCKS = ImmutableSet.of((Object)SkiesBlocks.turquoise_stone, (Object)SkiesBlocks.lunar_stone, (Object)SkiesBlocks.turquoise_dirt, (Object)SkiesBlocks.lunar_dirt, (Object)SkiesBlocks.turquoise_grass_block, (Object)SkiesBlocks.lunar_grass_block, (Object[])new Block[]{SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone, Blocks.field_150351_n, Blocks.field_150433_aE, Blocks.field_150348_b, Blocks.field_150403_cj, Blocks.field_150432_aD});
        public static final Set<Block> CARVABLE_SEA_BLOCKS = (Set)Streams.concat((Stream[])new Stream[]{CARVABLE_BLOCKS.stream(), ImmutableSet.of((Object)Blocks.field_150355_j, (Object)Blocks.field_150353_l, (Object)Blocks.field_150343_Z, (Object)Blocks.field_150350_a, (Object)Blocks.field_201941_jj).stream()}).collect(ImmutableSet.toImmutableSet());
        public static final WorldCarver<EmptyCarverConfig> SKY_NOISE_CARVER = new SkyNoiseCarver((Codec<EmptyCarverConfig>)EmptyCarverConfig.field_236237_b_, 90);
        public static final WorldCarver<EmptyCarverConfig> EVERBRIGHT_NOISE_CARVER = new SkyNoiseCarver(EmptyCarverConfig.field_236237_b_, 90){

            @Override
            protected BlockState getStateForPlace(Random rand, int y) {
                if (y <= 10) {
                    return y == 10 && rand.nextFloat() < 0.4f ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
                }
                return field_222715_g;
            }
        };
        public static final WorldCarver<ProbabilityConfig> EVERBRIGHT_CAVE_CARVER = new EverbrightCaveWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256);
        public static final WorldCarver<ProbabilityConfig> EVERBRIGHT_CANYON_CARVER = new EverbrightCanyonWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        public static final WorldCarver<ProbabilityConfig> SKY_CAVE_CARVER = new SkyCaveWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256);
        public static final WorldCarver<ProbabilityConfig> SKY_CANYON_CARVER = new SkyCanyonWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        public static final WorldCarver<ProbabilityConfig> UNDERWATER_SKY_CAVE_CARVER = new UnderwaterSkiesCaveWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        public static final WorldCarver<ProbabilityConfig> UNDERWATER_SKY_CANYON_CARVER = new UnderwaterSkiesCanyonWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);

        public static void init(RegistryEvent.Register<WorldCarver<?>> event) {
            SkiesRegistry.register(event.getRegistry(), "everbright_noise_carver", EVERBRIGHT_NOISE_CARVER);
            SkiesRegistry.register(event.getRegistry(), "sky_noise_carver", SKY_NOISE_CARVER);
            SkiesRegistry.register(event.getRegistry(), "everbright_cave_carver", EVERBRIGHT_CAVE_CARVER);
            SkiesRegistry.register(event.getRegistry(), "everbright_canyon_carver", EVERBRIGHT_CANYON_CARVER);
            SkiesRegistry.register(event.getRegistry(), "sky_cave_carver", SKY_CAVE_CARVER);
            SkiesRegistry.register(event.getRegistry(), "sky_canyon_carver", SKY_CANYON_CARVER);
            SkiesRegistry.register(event.getRegistry(), "underwater_sky_cave_carver", UNDERWATER_SKY_CAVE_CARVER);
            SkiesRegistry.register(event.getRegistry(), "underwater_sky_canyon_carver", UNDERWATER_SKY_CANYON_CARVER);
        }
    }

    public static class Configs {
        public static final Set<BlockState> EVERBRIGHT_CHERRY_GRASS_STATES = PointOfInterestType.func_221042_a((Block)SkiesBlocks.turquoise_cherry_grass_block);
        public static final BlockClusterFeatureConfig TALL_TURQUOISE_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SkiesBlocks.tall_turquoise_grass.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227315_a_(64).func_227317_b_().func_227322_d_();
        public static final BlockClusterFeatureConfig SNOWCAP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SkiesBlocks.snowcap_mushroom.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227315_a_(64).func_227317_b_().func_227322_d_();
        public static final BlockClusterFeatureConfig CAMELLIA_CONFIG = Configs.simpleConfig(SkiesBlocks.camellia.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig SNOWBLOOM_CONFIG = Configs.simpleConfig(SkiesBlocks.snowbloom.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig BREWBERRY_CONFIG = Configs.simpleConfig((BlockState)SkiesBlocks.brewberry_bush.func_176223_P().func_206870_a((Property)BrewberryBushBlock.MATURE, (Comparable)Boolean.valueOf(true)), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig BRITTLEBUSH_CONFIG = Configs.simpleConfig(SkiesBlocks.brittlebush.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig POLAR_POSY_CONFIG = Configs.simpleConfig(SkiesBlocks.polar_posy.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig CHILLWEED_CONFIG = Configs.simpleConfig(SkiesBlocks.chillweed.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig SEA_MOSS_CONFIG = Configs.simpleConfig(SkiesBlocks.sea_moss.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig SNOWCAP_PINHEAD_CONFIG = Configs.simpleConfig(SkiesBlocks.snowcap_pinhead.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig MIDDAY_BAYHOP_CONFIG = Configs.simpleConfig(SkiesBlocks.midday_bayhop.func_176223_P(), 64).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig TALL_LUNAR_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SkiesBlocks.tall_lunar_grass.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        public static final BlockClusterFeatureConfig MOONLIT_BLOOM_CONFIG = Configs.simpleConfig(SkiesBlocks.moonlit_bloom.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig BANEFUL_MUSHROOM_CONFIG = Configs.simpleConfig(SkiesBlocks.baneful_mushroom.func_176223_P(), 16).func_227322_d_();
        public static final BlockClusterFeatureConfig BLAZE_BUD_CONFIG = Configs.simpleConfig(SkiesBlocks.blaze_bud.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig CRYSTAL_FLOWER_CONFIG = Configs.simpleConfig(SkiesBlocks.crystal_flower.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig FLARE_FLORET_CONFIG = Configs.simpleConfig(SkiesBlocks.flare_floret.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig MUCKWEED_CONFIG = Configs.simpleConfig(SkiesBlocks.muckweed.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig LUCENTROOT_CONFIG = Configs.simpleConfig(SkiesBlocks.lucentroot.func_176223_P(), 16).func_227322_d_();
        public static final BlockClusterFeatureConfig NIGHTCRESS_CONFIG = Configs.simpleConfig(SkiesBlocks.nightcress.func_176223_P(), 64).func_227322_d_();
        public static final BlockClusterFeatureConfig LUNAR_GRASS_MUCKWEED_MIX_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SkiesBlocks.lunar_grass.func_176223_P(), 3).func_227407_a_(SkiesBlocks.muckweed.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
        public static final BlockClusterFeatureConfig FlARE_BLAZE_LUCENTROOT_MIX_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SkiesBlocks.flare_floret.func_176223_P(), 2).func_227407_a_(SkiesBlocks.blaze_bud.func_176223_P(), 2).func_227407_a_(SkiesBlocks.lucentroot.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig MOONLIT_BLOOM_NIGHTCRESS_LUCENTROOT_MIX_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SkiesBlocks.moonlit_bloom.func_176223_P(), 2).func_227407_a_(SkiesBlocks.nightcress.func_176223_P(), 2).func_227407_a_(SkiesBlocks.lucentroot.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig BRISK_MEADOW_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SkiesBlocks.briskbloom.func_176223_P(), 5).func_227407_a_(SkiesBlocks.chillweed.func_176223_P(), 1).func_227407_a_(SkiesBlocks.brittlebush.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(80).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig SHADED_WOODLANDS_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SkiesBlocks.moonlit_bloom.func_176223_P(), 2).func_227407_a_(SkiesBlocks.nightcress.func_176223_P(), 2).func_227407_a_(SkiesBlocks.lucentroot.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(8).func_227322_d_();
        public static final BlockClusterFeatureConfig TURQUOISE_GRASS = Configs.simpleConfig(SkiesBlocks.turquoise_grass.func_176223_P(), 32).func_227319_b_(EVERBRIGHT_CHERRY_GRASS_STATES).func_227322_d_();
        public static final BlockClusterFeatureConfig LUNAR_GRASS = Configs.simpleConfig(SkiesBlocks.lunar_grass.func_176223_P(), 32).func_227322_d_();
        public static final BlockClusterFeatureConfig CRYSTALLIZED_GRASS = Configs.simpleConfig(SkiesBlocks.crystallized_grass.func_176223_P(), 32).func_227322_d_();
        public static final BlockClusterFeatureConfig LIGHT_CRYSTALLIZED_GRASS = Configs.simpleConfig(SkiesBlocks.crystallized_grass.func_176223_P(), 16).func_227322_d_();
        public static final RuleTest TURQUOISE_RULE_TEST = new BlockMatchRuleTest(SkiesBlocks.turquoise_stone);
        public static final RuleTest LUNAR_RULE_TEST = new BlockMatchRuleTest(SkiesBlocks.lunar_stone);

        public static BlockClusterFeatureConfig.Builder simpleConfig(BlockState state, int tries) {
            return new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(state), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(tries);
        }
    }
}

