/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.BossItemEntity;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.CrynocerousEntity;
import com.legacy.blue_skies.entities.hostile.DiophydeProwlerEntity;
import com.legacy.blue_skies.entities.hostile.EmberbackEntity;
import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.InfestedSwarmerEntity;
import com.legacy.blue_skies.entities.hostile.NyctoflyEntity;
import com.legacy.blue_skies.entities.hostile.PolargeistEntity;
import com.legacy.blue_skies.entities.hostile.SeclamEntity;
import com.legacy.blue_skies.entities.hostile.ShrumptyEntity;
import com.legacy.blue_skies.entities.hostile.SpewterEntity;
import com.legacy.blue_skies.entities.hostile.StoneletEntity;
import com.legacy.blue_skies.entities.hostile.VenomSpiderEntity;
import com.legacy.blue_skies.entities.hostile.WhistleshellCrabEntity;
import com.legacy.blue_skies.entities.hostile.boss.AlchemistEntity;
import com.legacy.blue_skies.entities.hostile.boss.ArachnarchEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.NestedSpiderEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.StrangeLightningEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.passive.AzulfoEntity;
import com.legacy.blue_skies.entities.passive.CosmicFoxEntity;
import com.legacy.blue_skies.entities.passive.CrogreEntity;
import com.legacy.blue_skies.entities.passive.CrystalCamelEntity;
import com.legacy.blue_skies.entities.passive.FireflyEntity;
import com.legacy.blue_skies.entities.passive.ReindeerEntity;
import com.legacy.blue_skies.entities.passive.ShadeMonitorEntity;
import com.legacy.blue_skies.entities.passive.SlivEntity;
import com.legacy.blue_skies.entities.passive.SnowOwlEntity;
import com.legacy.blue_skies.entities.passive.StardustRamEntity;
import com.legacy.blue_skies.entities.passive.fish.CharscaleMokiEntity;
import com.legacy.blue_skies.entities.passive.fish.GrittleFlatfishEntity;
import com.legacy.blue_skies.entities.passive.fish.HorizofinTunidEntity;
import com.legacy.blue_skies.entities.passive.fish.JellyDrifterEntity;
import com.legacy.blue_skies.entities.passive.fish.MunicipalMonkfishEntity;
import com.legacy.blue_skies.entities.projectile.EntLeafEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.entities.projectile.SeedBombEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.projectile.VenomBombEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

public class SkiesEntityTypes {
    public static final EntityType<AzulfoEntity> AZULFO = SkiesEntityTypes.buildEntity("azulfo", EntityType.Builder.func_220322_a(AzulfoEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.0f, 2.3f));
    public static final EntityType<StardustRamEntity> STARDUST_RAM = SkiesEntityTypes.buildEntity("stardust_ram", EntityType.Builder.func_220322_a(StardustRamEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 1.7f));
    public static final EntityType<ReindeerEntity> REINDEER = SkiesEntityTypes.buildEntity("reindeer", EntityType.Builder.func_220322_a(ReindeerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3f, 1.5f));
    public static final EntityType<JellyDrifterEntity> JELLY_DRIFTER = SkiesEntityTypes.buildEntity("jelly_drifter", EntityType.Builder.func_220322_a(JellyDrifterEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.6f, 1.2f));
    public static final EntityType<SnowOwlEntity> SNOW_OWL = SkiesEntityTypes.buildEntity("snow_owl", EntityType.Builder.func_220322_a(SnowOwlEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.5f, 0.9f));
    public static final EntityType<FrostSpiritEntity> FROST_SPIRIT = SkiesEntityTypes.buildEntity("frost_spirit", EntityType.Builder.func_220322_a(FrostSpiritEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.6f, 0.6f));
    public static final EntityType<GrittleFlatfishEntity> GRITTLE_FLATFISH = SkiesEntityTypes.buildEntity("grittle_flatfish", EntityType.Builder.func_220322_a(GrittleFlatfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(1.0f, 0.7f));
    public static final EntityType<MunicipalMonkfishEntity> MUNICIPAL_MONKFISH = SkiesEntityTypes.buildEntity("municipal_monkfish", EntityType.Builder.func_220322_a(MunicipalMonkfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.3f));
    public static final EntityType<ArmoredFrostSpiritEntity> ARMORED_FROST_SPIRIT = SkiesEntityTypes.buildEntity("armored_frost_spirit", EntityType.Builder.func_220322_a(ArmoredFrostSpiritEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<CrynocerousEntity> CRYNOCEROUS = SkiesEntityTypes.buildEntity("crynocerous", EntityType.Builder.func_220322_a(CrynocerousEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.0f, 2.3f));
    public static final EntityType<PolargeistEntity> POLARGEIST = SkiesEntityTypes.buildEntity("polargeist", EntityType.Builder.func_220322_a(PolargeistEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.6f, 1.6f));
    public static final EntityType<StoneletEntity> STONELET = SkiesEntityTypes.buildEntity("stonelet", EntityType.Builder.func_220322_a(StoneletEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.3f, 2.0f));
    public static final EntityType<WhistleshellCrabEntity> WHISTLESHELL_CRAB = SkiesEntityTypes.buildEntity("whistleshell_crab", EntityType.Builder.func_220322_a(WhistleshellCrabEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.8f, 0.8f));
    public static final EntityType<ShrumptyEntity> SHRUMPTY = SkiesEntityTypes.buildEntity("shrumpty", EntityType.Builder.func_220322_a(ShrumptyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.3f));
    public static final EntityType<DiophydeProwlerEntity> DIOPHYDE_PROWLER = SkiesEntityTypes.buildEntity("diophyde_prowler", EntityType.Builder.func_220322_a(DiophydeProwlerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.6f, 1.6f));
    public static final EntityType<SeclamEntity> SECLAM = SkiesEntityTypes.buildEntity("seclam", EntityType.Builder.func_220322_a(SeclamEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.6f, 0.8f));
    public static final EntityType<FireflyEntity> FIREFLY = SkiesEntityTypes.buildEntity("firefly", EntityType.Builder.func_220322_a(FireflyEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.7f, 0.6f));
    public static final EntityType<CosmicFoxEntity> COSMIC_FOX = SkiesEntityTypes.buildEntity("cosmic_fox", EntityType.Builder.func_220322_a(CosmicFoxEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.75f));
    public static final EntityType<CrystalCamelEntity> CRYSTAL_CAMEL = SkiesEntityTypes.buildEntity("crystal_camel", EntityType.Builder.func_220322_a(CrystalCamelEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.5f, 2.2f));
    public static final EntityType<ShadeMonitorEntity> SHADE_MONITOR = SkiesEntityTypes.buildEntity("shade_monitor", EntityType.Builder.func_220322_a(ShadeMonitorEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.8f, 1.0f));
    public static final EntityType<SlivEntity> SLIV = SkiesEntityTypes.buildEntity("sliv", EntityType.Builder.func_220322_a(SlivEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 0.2f));
    public static final EntityType<CrogreEntity> CROGRE = SkiesEntityTypes.buildEntity("crogre", EntityType.Builder.func_220322_a(CrogreEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3f, 0.8f));
    public static final EntityType<CharscaleMokiEntity> CHARSCALE_MOKI = SkiesEntityTypes.buildEntity("charscale_moki", EntityType.Builder.func_220322_a(CharscaleMokiEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.3f));
    public static final EntityType<HorizofinTunidEntity> HORIZOFIN_TUNID = SkiesEntityTypes.buildEntity("horizofin_tunid", EntityType.Builder.func_220322_a(HorizofinTunidEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.3f));
    public static final EntityType<NyctoflyEntity> NYCTOFLY = SkiesEntityTypes.buildEntity("nyctofly", EntityType.Builder.func_220322_a(NyctoflyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 0.8f));
    public static final EntityType<VenomSpiderEntity> VENOM_SPIDER = SkiesEntityTypes.buildEntity("venom_spider", EntityType.Builder.func_220322_a(VenomSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f));
    public static final EntityType<VenomSpitEntity> VENOM_SPIT = SkiesEntityTypes.buildEntity("venom_spit", EntityType.Builder.func_220322_a(VenomSpitEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(VenomSpitEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));
    public static final EntityType<EmberbackEntity> EMBERBACK = SkiesEntityTypes.buildEntity("emberback", EntityType.Builder.func_220322_a(EmberbackEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f).func_220320_c());
    public static final EntityType<InfestedSwarmerEntity> INFESTED_SWARMER = SkiesEntityTypes.buildEntity("infested_swarmer", EntityType.Builder.func_220322_a(InfestedSwarmerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.7f, 0.9f));
    public static final EntityType<SummonerEntity> SUMMONER = SkiesEntityTypes.buildEntity("summoner", EntityType.Builder.func_220322_a(SummonerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.0f).func_220320_c());
    public static final EntityType<ArtificialGolemEntity> ARTIFICIAL_GOLEM = SkiesEntityTypes.buildEntity("artificial_golem", EntityType.Builder.func_220322_a(ArtificialGolemEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 2.1f).func_220320_c());
    public static final EntityType<StrangeLightningEntity> STRANGE_LIGHTNING = SkiesEntityTypes.buildEntity("strange_lightning", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(StrangeLightningEntity::new).func_220321_a(0.0f, 0.0f));
    public static final EntityType<FluctuantSphereEntity> FLUCTUANT_SPHERE = SkiesEntityTypes.buildEntity("fluctuant_sphere", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(FluctuantSphereEntity::new).func_220320_c().setShouldReceiveVelocityUpdates(true).func_220321_a(0.7f, 0.7f));
    public static final EntityType<AlchemistEntity> ALCHEMIST = SkiesEntityTypes.buildEntity("alchemist", EntityType.Builder.func_220322_a(AlchemistEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.0f).func_220320_c());
    public static final EntityType<DecayingSpikeEntity> DECAYING_SPIKE = SkiesEntityTypes.buildEntity("decaying_spike", EntityType.Builder.func_220322_a(DecayingSpikeEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(DecayingSpikeEntity::new).setShouldReceiveVelocityUpdates(true).func_220320_c().func_220321_a(1.0f, 1.0f));
    public static final EntityType<StarlitCrusherEntity> STARLIT_CRUSHER = SkiesEntityTypes.buildEntity("starlit_crusher", EntityType.Builder.func_220322_a(StarlitCrusherEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.6f, 3.2f));
    public static final EntityType<EntRootEntity> ENT_ROOT = SkiesEntityTypes.buildEntity("ent_root", EntityType.Builder.func_220322_a(EntRootEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.8f));
    public static final EntityType<EntWallEntity> ENT_WALL = SkiesEntityTypes.buildEntity("ent_wall", EntityType.Builder.func_220322_a(EntWallEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.8f));
    public static final EntityType<EntLeafEntity> ENT_LEAF = SkiesEntityTypes.buildEntity("ent_leaf", EntityType.Builder.func_220322_a(EntLeafEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3f, 0.1f));
    public static final EntityType<SpewterEntity> SPEWTER = SkiesEntityTypes.buildEntity("spewter", EntityType.Builder.func_220322_a(SpewterEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 1.2f));
    public static final EntityType<SeedBombEntity> SEED_BOMB = SkiesEntityTypes.buildEntity("seed_bomb", EntityType.Builder.func_220322_a(SeedBombEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(SeedBombEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));
    public static final EntityType<ArachnarchEntity> ARACHNARCH = SkiesEntityTypes.buildEntity("arachnarch", EntityType.Builder.func_220322_a(ArachnarchEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(3.0f, 1.7f).func_220320_c());
    public static final EntityType<VenomBombEntity> VENOM_BOMB = SkiesEntityTypes.buildEntity("venom_bomb", EntityType.Builder.func_220322_a(VenomBombEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(VenomBombEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));
    public static final EntityType<NestedSpiderEntity> NESTED_SPIDER = SkiesEntityTypes.buildEntity("nested_spider", EntityType.Builder.func_220322_a(NestedSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 0.5f));
    public static final EntityType<GatekeeperEntity> GATEKEEPER = SkiesEntityTypes.buildEntity("gatekeeper", EntityType.Builder.func_220322_a(GatekeeperEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f));
    public static final EntityType<SpearEntity> SPEAR = SkiesEntityTypes.buildEntity("spear", EntityType.Builder.func_220322_a(SpearEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(SpearEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<SupporterPetEntity> SUPPORTER_PET = SkiesEntityTypes.buildEntity("supporter_pet", EntityType.Builder.func_220322_a(SupporterPetEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220320_c().func_220321_a(0.8f, 0.8f));
    public static final EntityType<BossItemEntity> BOSS_ITEM = SkiesEntityTypes.buildEntity("boss_item", EntityType.Builder.func_220322_a(BossItemEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(BossItemEntity::new).func_233606_a_(6).func_233608_b_(20).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        SkiesRegistry.register(event.getRegistry(), "azulfo", AZULFO);
        SkiesRegistry.register(event.getRegistry(), "stardust_ram", STARDUST_RAM);
        SkiesRegistry.register(event.getRegistry(), "reindeer", REINDEER);
        SkiesRegistry.register(event.getRegistry(), "frost_spirit", FROST_SPIRIT);
        SkiesRegistry.register(event.getRegistry(), "grittle_flatfish", GRITTLE_FLATFISH);
        SkiesRegistry.register(event.getRegistry(), "municipal_monkfish", MUNICIPAL_MONKFISH);
        SkiesRegistry.register(event.getRegistry(), "armored_frost_spirit", ARMORED_FROST_SPIRIT);
        SkiesRegistry.register(event.getRegistry(), "crynocerous", CRYNOCEROUS);
        SkiesRegistry.register(event.getRegistry(), "jelly_drifter", JELLY_DRIFTER);
        SkiesRegistry.register(event.getRegistry(), "snow_owl", SNOW_OWL);
        SkiesRegistry.register(event.getRegistry(), "polargeist", POLARGEIST);
        SkiesRegistry.register(event.getRegistry(), "stonelet", STONELET);
        SkiesRegistry.register(event.getRegistry(), "whistleshell_crab", WHISTLESHELL_CRAB);
        SkiesRegistry.register(event.getRegistry(), "shrumpty", SHRUMPTY);
        SkiesRegistry.register(event.getRegistry(), "diophyde_prowler", DIOPHYDE_PROWLER);
        SkiesRegistry.register(event.getRegistry(), "seclam", SECLAM);
        SkiesRegistry.register(event.getRegistry(), "firefly", FIREFLY);
        SkiesRegistry.register(event.getRegistry(), "cosmic_fox", COSMIC_FOX);
        SkiesRegistry.register(event.getRegistry(), "crystal_camel", CRYSTAL_CAMEL);
        SkiesRegistry.register(event.getRegistry(), "shade_monitor", SHADE_MONITOR);
        SkiesRegistry.register(event.getRegistry(), "sliv", SLIV);
        SkiesRegistry.register(event.getRegistry(), "crogre", CROGRE);
        SkiesRegistry.register(event.getRegistry(), "charscale_moki", CHARSCALE_MOKI);
        SkiesRegistry.register(event.getRegistry(), "horizofin_tunid", HORIZOFIN_TUNID);
        SkiesRegistry.register(event.getRegistry(), "nyctofly", NYCTOFLY);
        SkiesRegistry.register(event.getRegistry(), "venom_spider", VENOM_SPIDER);
        SkiesRegistry.register(event.getRegistry(), "venom_spit", VENOM_SPIT);
        SkiesRegistry.register(event.getRegistry(), "emberback", EMBERBACK);
        SkiesRegistry.register(event.getRegistry(), "infested_swarmer", INFESTED_SWARMER);
        SkiesRegistry.register(event.getRegistry(), "gatekeeper", GATEKEEPER);
        SkiesRegistry.register(event.getRegistry(), "summoner", SUMMONER);
        SkiesRegistry.register(event.getRegistry(), "artificial_golem", ARTIFICIAL_GOLEM);
        SkiesRegistry.register(event.getRegistry(), "strange_lightning", STRANGE_LIGHTNING);
        SkiesRegistry.register(event.getRegistry(), "fluctuant_sphere", FLUCTUANT_SPHERE);
        SkiesRegistry.register(event.getRegistry(), "alchemist", ALCHEMIST);
        SkiesRegistry.register(event.getRegistry(), "decaying_spike", DECAYING_SPIKE);
        SkiesRegistry.register(event.getRegistry(), "starlit_crusher", STARLIT_CRUSHER);
        SkiesRegistry.register(event.getRegistry(), "ent_root", ENT_ROOT);
        SkiesRegistry.register(event.getRegistry(), "ent_wall", ENT_WALL);
        SkiesRegistry.register(event.getRegistry(), "ent_leaf", ENT_LEAF);
        SkiesRegistry.register(event.getRegistry(), "spewter", SPEWTER);
        SkiesRegistry.register(event.getRegistry(), "seed_bomb", SEED_BOMB);
        SkiesRegistry.register(event.getRegistry(), "arachnarch", ARACHNARCH);
        SkiesRegistry.register(event.getRegistry(), "venom_bomb", VENOM_BOMB);
        SkiesRegistry.register(event.getRegistry(), "nested_spider", NESTED_SPIDER);
        SkiesRegistry.register(event.getRegistry(), "spear", SPEAR);
        SkiesRegistry.register(event.getRegistry(), "supporter_pet", SUPPORTER_PET);
        SkiesRegistry.register(event.getRegistry(), "boss_item", BOSS_ITEM);
        SpawnConditions.registerSpawnConditions();
    }

    public static void onAttributesRegistered(EntityAttributeCreationEvent event) {
        event.put(AZULFO, AzulfoEntity.registerAttributes().func_233813_a_());
        event.put(STARDUST_RAM, StardustRamEntity.registerAttributes().func_233813_a_());
        event.put(REINDEER, ReindeerEntity.registerAttributes().func_233813_a_());
        event.put(JELLY_DRIFTER, JellyDrifterEntity.registerAttributes().func_233813_a_());
        event.put(SNOW_OWL, SnowOwlEntity.registerAttributes().func_233813_a_());
        event.put(GRITTLE_FLATFISH, GrittleFlatfishEntity.registerAttributes().func_233813_a_());
        event.put(MUNICIPAL_MONKFISH, AbstractFishEntity.func_234176_m_().func_233813_a_());
        event.put(CRYSTAL_CAMEL, CrystalCamelEntity.registerAttributes().func_233813_a_());
        event.put(COSMIC_FOX, CosmicFoxEntity.registerAttributes().func_233813_a_());
        event.put(FIREFLY, FireflyEntity.registerAttributes().func_233813_a_());
        event.put(SHADE_MONITOR, ShadeMonitorEntity.registerAttributes().func_233813_a_());
        event.put(SLIV, SlivEntity.registerAttributes().func_233813_a_());
        event.put(CROGRE, CrogreEntity.registerAttributes().func_233813_a_());
        event.put(CHARSCALE_MOKI, AbstractFishEntity.func_234176_m_().func_233813_a_());
        event.put(HORIZOFIN_TUNID, AbstractFishEntity.func_234176_m_().func_233813_a_());
        event.put(ARMORED_FROST_SPIRIT, ArmoredFrostSpiritEntity.registerAttributes().func_233813_a_());
        event.put(CRYNOCEROUS, CrynocerousEntity.registerAttributes().func_233813_a_());
        event.put(POLARGEIST, PolargeistEntity.registerAttributes().func_233813_a_());
        event.put(FROST_SPIRIT, FrostSpiritEntity.registerAttributes().func_233813_a_());
        event.put(WHISTLESHELL_CRAB, WhistleshellCrabEntity.registerAttributes().func_233813_a_());
        event.put(SHRUMPTY, ShrumptyEntity.registerAttributes().func_233813_a_());
        event.put(DIOPHYDE_PROWLER, DiophydeProwlerEntity.registerAttributes().func_233813_a_());
        event.put(SECLAM, SeclamEntity.registerAttributes().func_233813_a_());
        event.put(NYCTOFLY, NyctoflyEntity.registerAttributes().func_233813_a_());
        event.put(VENOM_SPIDER, VenomSpiderEntity.registerAttributes().func_233813_a_());
        event.put(EMBERBACK, EmberbackEntity.registerAttributes().func_233813_a_());
        event.put(INFESTED_SWARMER, InfestedSwarmerEntity.registerAttributes().func_233813_a_());
        event.put(GATEKEEPER, GatekeeperEntity.registerAttributes().func_233813_a_());
        event.put(SUMMONER, SummonerEntity.registerAttributes().func_233813_a_());
        event.put(ARTIFICIAL_GOLEM, ArtificialGolemEntity.registerAttributes().func_233813_a_());
        event.put(STARLIT_CRUSHER, StarlitCrusherEntity.registerAttributes().func_233813_a_());
        event.put(STONELET, StoneletEntity.registerAttributes().func_233813_a_());
        event.put(ENT_WALL, EntWallEntity.registerAttributes().func_233813_a_());
        event.put(SPEWTER, SpewterEntity.registerAttributes().func_233813_a_());
        event.put(ALCHEMIST, AlchemistEntity.registerAttributes().func_233813_a_());
        event.put(ARACHNARCH, ArachnarchEntity.registerAttributes().func_233813_a_());
        event.put(NESTED_SPIDER, NestedSpiderEntity.registerAttributes().func_233813_a_());
        event.put(SUPPORTER_PET, SupporterPetEntity.registerAttributes().func_233813_a_());
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(BlueSkies.find(key));
    }

    public static class SpawnConditions {
        private static void registerSpawnConditions() {
            EntitySpawnPlacementRegistry.func_209343_a(AZULFO, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(STARDUST_RAM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(REINDEER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(JELLY_DRIFTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, JellyDrifterEntity::spawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SNOW_OWL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, SnowOwlEntity::spawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(GRITTLE_FLATFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
            EntitySpawnPlacementRegistry.func_209343_a(MUNICIPAL_MONKFISH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
            EntitySpawnPlacementRegistry.func_209343_a(CRYSTAL_CAMEL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(COSMIC_FOX, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(FIREFLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::mobSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SHADE_MONITOR, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SLIV, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(CROGRE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::animalSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(CHARSCALE_MOKI, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
            EntitySpawnPlacementRegistry.func_209343_a(HORIZOFIN_TUNID, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
            EntitySpawnPlacementRegistry.func_209343_a(ARMORED_FROST_SPIRIT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(CRYNOCEROUS, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(POLARGEIST, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(WHISTLESHELL_CRAB, (EntitySpawnPlacementRegistry.PlacementType)SpawnPlacementTypes.ON_GROUND_OR_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::waterBeachMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SHRUMPTY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(DIOPHYDE_PROWLER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::surfaceBrightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SECLAM, (EntitySpawnPlacementRegistry.PlacementType)SpawnPlacementTypes.ON_GROUND_OR_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR, SpawnConditions::oceanFloorMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(NYCTOFLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(VENOM_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(EMBERBACK, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(INFESTED_SWARMER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, InfestedSwarmerEntity::swarmerSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(GATEKEEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::mobSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SUMMONER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(ARTIFICIAL_GOLEM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(STARLIT_CRUSHER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(STONELET, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(SPEWTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::brightMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(ALCHEMIST, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(ARACHNARCH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
            EntitySpawnPlacementRegistry.func_209343_a(NESTED_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SpawnConditions::dawnMonsterSpawnConditions);
        }

        public static boolean animalSpawnConditions(EntityType<? extends AnimalEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            return (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.crystal_sand) && world.func_226659_b_(pos, 0) > 8;
        }

        public static boolean mobSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            return (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.crystal_sand) && world.func_226659_b_(pos, 0) > 8 && pos.func_177956_o() >= 60;
        }

        public static boolean brightMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            int addedChance = reason == SpawnReason.SPAWNER ? 50 : (world.func_226658_a_(LightType.SKY, pos) <= 0 && pos.func_177956_o() < world.func_181545_F() ? 50 : 150);
            return MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand) && world.func_175659_aa() != Difficulty.PEACEFUL && rand.nextInt(addedChance) == 0;
        }

        public static boolean dawnMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            int addedChance = reason == SpawnReason.SPAWNER ? 50 : (world.func_226658_a_(LightType.SKY, pos) <= 0 && pos.func_177956_o() < world.func_181545_F() ? 50 : 150);
            return MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand) && world.func_175659_aa() != Difficulty.PEACEFUL && rand.nextInt(addedChance) == 0;
        }

        public static boolean surfaceBrightMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            return SpawnConditions.brightMonsterSpawnConditions(type, world, reason, pos, rand) && (pos.func_177956_o() >= world.func_181545_F() || world.func_226660_f_(pos));
        }

        public static boolean undergroundDawnMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            return SpawnConditions.dawnMonsterSpawnConditions(type, world, reason, pos, rand) && pos.func_177956_o() < world.func_181545_F() && !world.func_226660_f_(pos);
        }

        public static boolean waterBeachMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            return SpawnConditions.brightMonsterSpawnConditions(type, world, reason, pos, rand) && world.func_175710_j(pos) || SpawnConditions.oceanFloorMonsterSpawnConditions(type, world, reason, pos, rand);
        }

        public static boolean oceanFloorMonsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
            int addedChance = reason == SpawnReason.SPAWNER ? 50 : 120;
            return rand.nextInt(addedChance) == 0 && (world.func_201671_F(pos) || world.func_201671_F(pos.func_177977_b()));
        }
    }

    public static class SpawnPlacementTypes {
        private static TriPredicate<IWorldReader, BlockPos, EntityType<? extends MobEntity>> onGroundInWaterPredicate = (worldIn, pos, entityTypeIn) -> {
            BlockState blockstate = worldIn.func_180495_p(pos);
            FluidState fluidstate = worldIn.func_204610_c(pos);
            BlockPos blockpos = pos.func_177984_a();
            BlockPos blockpos1 = pos.func_177977_b();
            boolean inWater = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && worldIn.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a) && !worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos);
            boolean onLand = WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)pos, (BlockState)blockstate, (FluidState)fluidstate, (EntityType)entityTypeIn) && WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)blockpos, (BlockState)worldIn.func_180495_p(blockpos), (FluidState)worldIn.func_204610_c(blockpos), (EntityType)entityTypeIn);
            return inWater || onLand;
        };
        private static final EntitySpawnPlacementRegistry.PlacementType ON_GROUND_OR_WATER = EntitySpawnPlacementRegistry.PlacementType.create((String)BlueSkies.find("on_ground_or_water"), onGroundInWaterPredicate);
    }
}

