/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.util.PreparedFood;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.InstantEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class FoodPrepUtils {
    public static final String INGREDIENTS_KEY = "Ingredients";
    public static final String TOTAL_HUNGER_KEY = "Total_Hunger";
    public static final String SATURATION_KEY = "Saturation";
    public static final String USES_KEY = "Uses";
    public static final String MAX_USES_KEY = "MaxUses";
    public static final String EFFECTS_KEY = "Effects";

    public static void serialize(CompoundNBT itemNbt, PreparedFood preparedFood) {
        ListNBT ingredients = new ListNBT();
        preparedFood.getIngredients().forEach(i -> ingredients.add((Object)i.func_77955_b(new CompoundNBT())));
        itemNbt.func_218657_a(INGREDIENTS_KEY, (INBT)ingredients);
        itemNbt.func_74768_a(TOTAL_HUNGER_KEY, preparedFood.getTotalHunger());
        itemNbt.func_74776_a(SATURATION_KEY, preparedFood.getSaturation());
        itemNbt.func_74768_a(USES_KEY, preparedFood.getUses());
        itemNbt.func_74768_a(MAX_USES_KEY, preparedFood.getMaxUses());
        ListNBT effects = new ListNBT();
        preparedFood.getEffects().forEach(e -> effects.add((Object)e.func_82719_a(new CompoundNBT())));
        itemNbt.func_218657_a(EFFECTS_KEY, (INBT)effects);
    }

    public static PreparedFood deserialize(@Nullable CompoundNBT itemNbt) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        int totalHunger = 1;
        int uses = 1;
        int maxUses = 1;
        float saturation = 0.0f;
        if (itemNbt != null) {
            if (itemNbt.func_74764_b(INGREDIENTS_KEY)) {
                itemNbt.func_150295_c(INGREDIENTS_KEY, 10).forEach(nbt -> {
                    ItemStack ingredient = null;
                    try {
                        ingredient = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
                    }
                    catch (Exception e) {
                        BlueSkies.LOGGER.warn((Object)e);
                    }
                    if (ingredient != null) {
                        ingredients.add(ingredient);
                    }
                });
            }
            if (itemNbt.func_74764_b(EFFECTS_KEY)) {
                itemNbt.func_150295_c(EFFECTS_KEY, 10).forEach(nbt -> {
                    EffectInstance effect = null;
                    try {
                        effect = EffectInstance.func_82722_b((CompoundNBT)((CompoundNBT)nbt));
                    }
                    catch (Exception e) {
                        BlueSkies.LOGGER.warn((Object)e);
                    }
                    if (effect != null) {
                        effects.add(effect);
                    }
                });
            }
            if (itemNbt.func_74764_b(TOTAL_HUNGER_KEY)) {
                totalHunger = itemNbt.func_74762_e(TOTAL_HUNGER_KEY);
            }
            if (itemNbt.func_74764_b(USES_KEY)) {
                uses = itemNbt.func_74762_e(USES_KEY);
            }
            if (itemNbt.func_74764_b(MAX_USES_KEY)) {
                maxUses = itemNbt.func_74762_e(MAX_USES_KEY);
            }
            if (itemNbt.func_74764_b(SATURATION_KEY)) {
                saturation = itemNbt.func_74760_g(SATURATION_KEY);
            }
        }
        return new PreparedFood(ingredients, effects, totalHunger, uses, maxUses, saturation);
    }

    public static int getUses(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(USES_KEY)) {
            return tag.func_74762_e(USES_KEY);
        }
        return FoodPrepUtils.getMaxUses(stack);
    }

    public static int getMaxUses(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(MAX_USES_KEY)) {
            return tag.func_74762_e(MAX_USES_KEY);
        }
        return 1;
    }

    public static ItemStack createFood(IInventory inventory) {
        int i;
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slotStack = inventory.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (!FoodPrepUtils.isValidIngredient(slotStack)) {
                return ItemStack.field_190927_a;
            }
            ingredients.add(slotStack);
        }
        if (ingredients.size() < 3) {
            return ItemStack.field_190927_a;
        }
        int p = 0;
        for (i = 0; i < ingredients.size(); ++i) {
            if (((ItemStack)ingredients.get(i)).func_77973_b() == Items.field_151068_bn) {
                ++p;
            }
            if (p <= 2) continue;
            return ItemStack.field_190927_a;
        }
        int totalHunger = FoodPrepUtils.getTotalHunger(ingredients);
        int maxUses = FoodPrepUtils.getMaxUses(totalHunger);
        ItemStack stack = new ItemStack((IItemProvider)SkiesItems.prepared_food);
        FoodPrepUtils.serialize(stack.func_196082_o(), new PreparedFood(ingredients, FoodPrepUtils.getEffects(ingredients, maxUses), totalHunger, maxUses, maxUses, FoodPrepUtils.getSaturation(ingredients)));
        return stack;
    }

    public static boolean isValidIngredient(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() || item == Items.field_151068_bn || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof FlowerBlock;
    }

    public static void causeInstability(PreparedFood preparedFood, LivingEntity entity) {
        int potionCount = 0;
        for (ItemStack item : preparedFood.getIngredients()) {
            if (item.func_77973_b() != Items.field_151068_bn) continue;
            ++potionCount;
        }
        if (!entity.field_70170_p.field_72995_K && potionCount >= 2) {
            ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
            if ((double)entity.func_70681_au().nextFloat() < 0.333) {
                effects.add(new EffectInstance(Effects.field_76436_u, 180, entity.func_70681_au().nextBoolean() ? 1 : 0));
            } else {
                effects.add(new EffectInstance(entity.func_70681_au().nextBoolean() ? Effects.field_76431_k : Effects.field_76421_d, 150, entity.func_70681_au().nextBoolean() ? 1 : 0));
            }
            if (entity.func_70681_au().nextBoolean()) {
                if (entity.func_70681_au().nextBoolean()) {
                    effects.add(new EffectInstance(Effects.field_76433_i, 1, entity.func_70681_au().nextBoolean() ? 1 : 0));
                } else {
                    effects.add(new EffectInstance(Effects.field_82731_v, 200, entity.func_70681_au().nextBoolean() ? 1 : 0));
                }
            }
            effects.forEach(arg_0 -> ((LivingEntity)entity).func_195064_c(arg_0));
        }
    }

    private static int getTotalHunger(List<ItemStack> ingredients) {
        double hunger = 0.0;
        ArrayList<Item> usedIngredients = new ArrayList<Item>();
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.func_222117_E()) continue;
            hunger += (double)ingredient.func_77973_b().func_219967_s().func_221466_a() + (!usedIngredients.contains(ingredient.func_77973_b()) ? 2.5 : 0.0);
            usedIngredients.add(ingredient.func_77973_b());
        }
        return (int)Math.max(1.0, hunger);
    }

    private static int getMaxUses(int totalHunger) {
        return Math.max(1, Math.round((float)totalHunger / 6.0f));
    }

    private static float getSaturation(List<ItemStack> ingredients) {
        float saturation = 0.0f;
        float count = 0.0f;
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.func_222117_E()) continue;
            saturation += ingredient.func_77973_b().func_219967_s().func_221469_b();
            count += 1.0f;
        }
        return Math.max(0.1f, count == 0.0f ? 0.1f : saturation / count);
    }

    private static List<EffectInstance> getEffects(List<ItemStack> ingredients, int maxUses) {
        LinkedHashMap<Effect, EffectInstance> effectMap = new LinkedHashMap<Effect, EffectInstance>();
        boolean brewberryFlag = false;
        for (ItemStack ingredient : ingredients) {
            if (ingredient.func_77973_b() instanceof BlockItem && ((BlockItem)ingredient.func_77973_b()).func_179223_d() instanceof FlowerBlock) {
                FlowerBlock flower = (FlowerBlock)((BlockItem)ingredient.func_77973_b()).func_179223_d();
                Effect flowerEffect = flower.func_220094_d();
                int flowerDuration = flower.func_220095_e();
                FoodPrepUtils.addEffect(effectMap, new EffectInstance(flowerEffect, flowerDuration));
            }
            if (ingredient.func_222117_E()) {
                for (EffectInstance effect : ingredient.func_77973_b().func_219967_s().func_221464_f().stream().map(Pair::getFirst).collect(Collectors.toList())) {
                    FoodPrepUtils.addEffect(effectMap, effect);
                }
            }
            if (ingredient.func_77973_b() == Items.field_151068_bn) {
                PotionUtils.func_185185_a((CompoundNBT)ingredient.func_196082_o()).forEach(e -> FoodPrepUtils.addEffect(effectMap, e));
            }
            if (ingredient.func_77973_b() != SkiesItems.brewberry) continue;
            brewberryFlag = true;
        }
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (Map.Entry entry : effectMap.entrySet()) {
            EffectInstance effect;
            effect = (EffectInstance)entry.getValue();
            if (effect.func_188419_a() instanceof InstantEffect && effect.func_188419_a() != Effects.field_76443_y) continue;
            float time = (float)effect.func_76459_b() / (float)maxUses;
            effects.add(new EffectInstance(effect.func_188419_a(), Math.round(time *= brewberryFlag ? 1.4f : 1.1f), effect.func_76458_c()));
        }
        return effects;
    }

    private static void addEffect(Map<Effect, EffectInstance> map, EffectInstance newEffect) {
        if (map.containsKey(newEffect.func_188419_a())) {
            EffectInstance oldEffect = map.get(newEffect.func_188419_a());
            if (newEffect.func_76458_c() > oldEffect.func_76458_c()) {
                int duration = (int)((float)newEffect.func_76459_b() + (float)oldEffect.func_76459_b() * ((float)(oldEffect.func_76458_c() + 1) / (float)(newEffect.func_76458_c() + 1)));
                map.put(newEffect.func_188419_a(), new EffectInstance(newEffect.func_188419_a(), duration, newEffect.func_76458_c()));
            } else if (newEffect.func_76458_c() < oldEffect.func_76458_c()) {
                int duration = (int)((float)oldEffect.func_76459_b() + (float)newEffect.func_76459_b() * ((float)(newEffect.func_76458_c() + 1) / (float)(oldEffect.func_76458_c() + 1)));
                map.put(newEffect.func_188419_a(), new EffectInstance(newEffect.func_188419_a(), duration, oldEffect.func_76458_c()));
            } else {
                int duration = oldEffect.func_76459_b() + newEffect.func_76459_b();
                map.put(newEffect.func_188419_a(), new EffectInstance(newEffect.func_188419_a(), duration, newEffect.func_76458_c()));
            }
        } else {
            map.put(newEffect.func_188419_a(), new EffectInstance(newEffect.func_188419_a(), newEffect.func_76459_b(), newEffect.func_76458_c()));
        }
    }

    public static enum FoodColor {
        BEEF(8079412, new IItemProvider[]{Items.field_151082_bd, Items.field_151083_be, Items.field_179561_bm, Items.field_179557_bn, Items.field_151078_bh}),
        LETTUCE(6991719, new IItemProvider[0]),
        CHEESE(15390090, new IItemProvider[]{Items.field_196089_aZ}),
        APPLE(15013926, new IItemProvider[]{Items.field_151034_e, Items.field_151127_ba, SkiesItems.cherry}),
        BREAD(10449954, new IItemProvider[]{Items.field_151025_P, Items.field_151106_aX}),
        PORK(11638883, new IItemProvider[]{Items.field_151147_al, Items.field_151157_am, Items.field_196086_aW, Items.field_196102_ba, SkiesItems.monitor_tail, SkiesItems.cooked_monitor_tail}),
        SALMON(11227435, new IItemProvider[]{Items.field_196087_aX, Items.field_196104_bb}),
        KELP(4472114, new IItemProvider[]{Items.field_222066_kO}),
        CHICKEN(12811088, new IItemProvider[]{Items.field_151076_bf, Items.field_151077_bg, Items.field_179558_bo, Items.field_179559_bp, Items.field_179560_bq, Items.field_151009_A, Items.field_222115_pz}),
        CARROT(14712350, new IItemProvider[]{Items.field_151172_bF, Items.field_196088_aY}),
        POTATO(12489280, new IItemProvider[]{Items.field_151174_bG, Items.field_151168_bH, Items.field_151170_bI, Items.field_151158_bO, SkiesItems.solnut}),
        BEET(11353666, new IItemProvider[]{Items.field_185164_cV, Items.field_185165_cW, SkiesItems.fiery_beans}),
        SWEET_BERRY(10032151, new IItemProvider[]{Items.field_222112_pR, SkiesItems.brewberry}),
        WINTER_LEAF(7193708, new IItemProvider[]{SkiesItems.winter_leaves, SkiesItems.municipal_monkfish, SkiesItems.cooked_municipal_monkfish}),
        CRYO_ROOT(7323079, new IItemProvider[]{SkiesItems.cryo_root}),
        SCALEFRUIT(13919381, new IItemProvider[]{Items.field_151070_bp, SkiesItems.scalefruit, SkiesItems.pink_brewberry}),
        PINE_FRUIT(4924430, new IItemProvider[]{SkiesItems.pine_fruit}),
        CRESCENT_FRUIT(13453571, new IItemProvider[]{SkiesItems.crescent_fruit}),
        CARABEEF(3490920, new IItemProvider[]{SkiesItems.carabeef, SkiesItems.cooked_carabeef, SkiesItems.venison, SkiesItems.cooked_venison}),
        GRITTLE_FLATFISH(5453392, new IItemProvider[]{SkiesItems.grittle_flatfish, SkiesItems.cooked_grittle_flatfish}),
        CHARSCALE(14978148, new IItemProvider[]{SkiesItems.charscale_moki, SkiesItems.cooked_charscale_moki}),
        PEPPER(8657439, new IItemProvider[]{SkiesItems.fiery_beans}),
        BACKBERRY(3945297, new IItemProvider[]{SkiesItems.black_brewberry}),
        CHORUS(9792434, new IItemProvider[]{Items.field_185161_cS}),
        GOLDEN(15577123, new IItemProvider[]{Items.field_151153_ao, Items.field_196100_at, Items.field_151150_bK, Items.field_226638_pX_, SkiesItems.horizofin_tunid, SkiesItems.cooked_horizofin_tunid});

        private static final HashMap<Item, FoodColor> COLORS;
        public final int color;
        public final Set<IItemProvider> foods;

        private FoodColor(int color, IItemProvider ... foods) {
            this.color = color;
            this.foods = new HashSet<IItemProvider>(Arrays.asList(foods));
        }

        public static FoodColor get(Item item) {
            if (COLORS.containsKey(item)) {
                return COLORS.get(item);
            }
            return BEEF;
        }

        public static void setupColors() {
            COLORS.clear();
            block2: for (Item item : ForgeRegistries.ITEMS) {
                try {
                    if (!FoodPrepUtils.isValidIngredient(new ItemStack((IItemProvider)item))) continue;
                    for (FoodColor color : FoodColor.values()) {
                        if (!color.foods.contains(item)) continue;
                        COLORS.put(item, color);
                        continue block2;
                    }
                    COLORS.put(item, FoodColor.values()[new Random(item.getRegistryName().hashCode()).nextInt(FoodColor.values().length)]);
                }
                catch (Exception exception) {}
            }
        }

        static {
            COLORS = new HashMap();
        }
    }
}

