/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.KnockbackEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrushingHammerItem
extends Item
implements IFalsiteItem {
    public static final int MAX_USE_TIME = 20;

    public CrushingHammerItem(Item.Properties builder) {
        super(builder);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 11.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-3.3f, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack useStack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (useStack.func_77973_b() == this && playerIn.func_184600_cs() == handIn) {
            playerIn.field_70170_p.func_217384_a(null, (Entity)playerIn, SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_HAMMER, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityIn, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        if (entityIn instanceof PlayerEntity && i >= 20 && entityIn.func_233570_aj_()) {
            PlayerEntity player = (PlayerEntity)entityIn;
            player.func_184811_cZ().func_185145_a((Item)this, 80);
            ItemStack itemstack = player.func_184586_b(player.func_184600_cs());
            itemstack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(player.func_184600_cs()));
            AxisAlignedBB hitbox = player.func_174813_aQ().func_72314_b(7.0, 1.0, 7.0);
            player.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_HAMMER_SMASH, 1.0f, 1.0f);
            player.func_226292_a_(player.func_184600_cs(), true);
            player.func_213293_j(player.func_213322_ci().func_82615_a(), 0.2, player.func_213322_ci().func_82616_c());
            player.field_70133_I = true;
            if (world instanceof ServerWorld) {
                for (int j = 0; j < 20; ++j) {
                    ((ServerWorld)world).func_195598_a((IParticleData)SkiesParticles.DUST, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 10, 0.0, 0.0, 0.0, 0.05);
                }
            }
            for (Entity entity : world.func_72839_b((Entity)player, hitbox)) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).func_233570_aj_() || !(living.func_110148_a(Attributes.field_233820_c_).func_111126_e() < 1.0) || !living.func_70097_a(EntityUtil.DamageSources.causeSlamDamage((Entity)player), 6.0f)) continue;
                living.func_213293_j(living.func_213322_ci().func_82615_a(), 0.7, living.func_213322_ci().func_82616_c());
                if (!(living instanceof PlayerEntity)) continue;
                ((PlayerEntity)living).field_70133_I = true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        lore.add((ITextComponent)new StringTextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.crushing_hammer")));
    }

    @Override
    public boolean isFalsiteCompatible(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof DamageEnchantment || enchantment instanceof KnockbackEnchantment) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

