/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.misc.SkyWebbingBlock;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.CapabilityProvider;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.events.SkiesHooks;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.SpawnParticlePacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.GeometryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkiesPlayerEvents {
    public static int spawnDimensionID = 0;

    @SubscribeEvent
    public static void onAdvancementGranted(AdvancementEvent event) {
        if (event.getAdvancement().func_192067_g().equals((Object)BlueSkies.locate("everbright/enter")) || event.getAdvancement().func_192067_g().equals((Object)BlueSkies.locate("everdawn/enter"))) {
            EntityUtil.sendJournalToast(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            SkiesPlayer.ifPresent(player, skiesPlayer -> {
                skiesPlayer.getArcInventory().getStacks().forEach(stack -> {
                    if (stack.func_77973_b() instanceof IArcItem) {
                        ((IArcItem)stack.func_77973_b()).onHit((ItemStack)stack, player, event);
                    }
                });
                float newHealth = skiesPlayer.getNatureHealth() - event.getAmount();
                skiesPlayer.setNatureHealth(Math.max(0.0f, newHealth));
                event.setAmount(newHealth < 0.0f ? newHealth * -1.0f : 0.0f);
            });
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !((Entity)event.getObject()).getCapability(SkiesPlayer.INSTANCE).isPresent()) {
            event.addCapability(BlueSkies.locate("player_capability"), new CapabilityProvider<SkiesPlayer>(new SkiesPlayer((PlayerEntity)event.getObject())));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void teleportToKeystone(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            SkiesPlayer.ifPresent((PlayerEntity)event.getEntity(), skiesPlayer -> {
                if (!skiesPlayer.getPlayer().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && SkiesPlayerEvents.inBossFight(skiesPlayer.getPlayer())) {
                    skiesPlayer.teleportToNearestKeystone();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            SkiesPlayer.ifPresent((PlayerEntity)event.getEntity(), skiesPlayer -> skiesPlayer.onDeath());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        ISkiesPlayer original = SkiesPlayer.get(event.getOriginal());
        ISkiesPlayer clone = SkiesPlayer.get(event.getPlayer());
        CompoundNBT compound = new CompoundNBT();
        if (original != null && clone != null) {
            if (event.isWasDeath()) {
                clone.syncDataToClient();
                original.writeAdditional(compound);
                clone.read(compound);
                if (!clone.getPlayer().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                    clone.getArcInventory().func_174888_l();
                }
            } else {
                original.writeAdditional(compound);
                clone.read(compound);
                clone.syncDataToClient();
            }
            if (original.getSupporterPet() != null) {
                original.getSupporterPet().func_70106_y();
                original.setSupporterPet(null);
            }
            clone.setSupporterPet(null);
            clone.checkAndSpawnPet();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> skiesPlayer.syncDataToClient());
        if (spawnDimensionID > 0 && spawnDimensionID <= 2) {
            MinecraftServer server = event.getPlayer().func_184102_h();
            if (server == null || !(event.getPlayer() instanceof ServerPlayerEntity)) {
                return;
            }
            ServerWorld transferWorld = server.func_71218_a(spawnDimensionID == 1 ? SkiesDimensions.EVERBRIGHT : SkiesDimensions.EVERDAWN);
            SkiesPlayerEvents.teleportSafely((ServerPlayerEntity)event.getPlayer(), transferWorld, event.getPlayer().func_233580_cy_());
            spawnDimensionID = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity != null && entity instanceof PlayerEntity) {
            SkiesPlayer.ifPresent((PlayerEntity)entity, skiesPlayer -> {
                skiesPlayer.getArcInventory().refreshArcs((PlayerEntity)entity);
                skiesPlayer.syncDataToClient();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> {
            if (skiesPlayer.getSupporterPet() != null) {
                skiesPlayer.setSupporterPet(null);
            }
            skiesPlayer.checkAndSpawnPet();
            skiesPlayer.syncDataToClient();
        });
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SkiesPlayer.ifPresent(event.getPlayer(), skiesPlayer -> skiesPlayer.syncDataToClient());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack heldItem = player.func_184586_b(hand);
        if (entity instanceof CowEntity && heldItem.func_77973_b() == SkiesItems.ventium_bucket && !player.field_71075_bZ.field_75098_d && !((CowEntity)entity).func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)SkiesItems.ventium_milk_bucket));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)SkiesItems.ventium_milk_bucket))) {
                player.func_71019_a(new ItemStack((IItemProvider)SkiesItems.ventium_milk_bucket), false);
            }
        }
        if (entity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)entity;
            if (player.func_225608_bj_() && heldItem.func_77973_b() == SkiesBlocks.bag_of_spoils.func_199767_j() && !player.func_184811_cZ().func_185141_a(heldItem.func_77973_b())) {
                if (player.field_70170_p.field_72995_K) {
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    return;
                }
                if (villager.func_213700_eh().func_221130_b() == SkiesVillagers.NIGHTWATCHER || EntityUtil.canEntitySeePos((LivingEntity)villager, player.func_233580_cy_())) {
                    if (entity.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)entity.field_70170_p).func_217489_a(IReputationType.field_221031_c, (Entity)player, (IReputationTracking)villager);
                        entity.field_70170_p.func_72960_a((Entity)villager, (byte)13);
                    }
                    entity.func_184185_a(SoundEvents.field_187913_gm, 1.0f, EntityUtil.getSoundPitchWithStart(entity.field_70170_p.field_73012_v, 1.0f));
                    player.func_226292_a_(hand, true);
                } else {
                    try {
                        CompoundNBT compoundnbt = heldItem.func_179543_a("BlockEntityTag");
                        NonNullList originalItems = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                        ArrayList trueItems = Lists.newArrayList();
                        if (compoundnbt == null) {
                            compoundnbt = new CompoundNBT();
                            ItemStackHelper.func_191281_a((CompoundNBT)compoundnbt, (NonNullList)originalItems, (boolean)false);
                            heldItem.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                        }
                        if (compoundnbt.func_150297_b("Items", 9)) {
                            ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)originalItems);
                            for (ItemStack itemstack : originalItems) {
                                if (itemstack.func_190926_b()) continue;
                                trueItems.add(itemstack);
                            }
                        }
                        if (trueItems.size() <= 5 && player.field_70170_p instanceof ServerWorld) {
                            List<ItemStack> gifts = SkiesPlayerEvents.getVillagerGifts(villager);
                            ItemStack gift = gifts.get(player.field_70170_p.field_73012_v.nextInt(gifts.size()));
                            boolean hasItem = false;
                            for (ItemStack stack : trueItems) {
                                if (stack == ItemStack.field_190927_a || stack.func_77973_b() != gift.func_77973_b() || stack.func_190916_E() >= stack.func_77976_d()) continue;
                                stack.func_190920_e(stack.func_190916_E() + 1);
                                hasItem = true;
                                break;
                            }
                            if (!hasItem && trueItems.size() < 5) {
                                originalItems.set(trueItems.size(), (Object)gift);
                            }
                            ItemStackHelper.func_191281_a((CompoundNBT)compoundnbt, (NonNullList)originalItems, (boolean)false);
                            heldItem.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                            if (!hasItem && trueItems.size() < 5 || hasItem) {
                                entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 0.8f);
                                player.func_226292_a_(hand, true);
                                player.func_195066_a(SkiesStats.VILLAGERS_PICKPOCKETED);
                                if (!player.func_184812_l_()) {
                                    player.func_184811_cZ().func_185145_a(heldItem.func_77973_b(), 120);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    private static List<ItemStack> getVillagerGifts(VillagerEntity villager) {
        if (villager.func_70631_g_()) {
            return ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_221620_aV));
        }
        VillagerProfession villagerprofession = villager.func_213700_eh().func_221130_b();
        if (GiveHeroGiftsTask.field_220403_a.containsKey(villagerprofession)) {
            LootTable loottable = villager.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a((ResourceLocation)GiveHeroGiftsTask.field_220403_a.get(villagerprofession));
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)villager.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)villager.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)villager).func_216023_a(villager.func_70681_au());
            return loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216264_e));
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151014_N), new ItemStack((IItemProvider)Items.field_151007_F), new ItemStack((IItemProvider)Items.field_221672_ax), new ItemStack((IItemProvider)Items.field_221582_j)});
    }

    private static ItemStack getSmeltedResult(ItemStack stack, World world) {
        ItemStack output = stack;
        Inventory iInventory = new Inventory(new ItemStack[]{stack});
        output = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)iInventory, world).map(arg_0 -> SkiesPlayerEvents.lambda$getSmeltedResult$8((IInventory)iInventory, arg_0)).orElse(stack);
        output.func_190920_e(stack.func_190916_E());
        return output;
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        Item playerItem = player.func_184614_ca().func_77973_b();
        if (SkiesItemTags.HORIZONITE_TOOLS.func_230235_a_((Object)playerItem)) {
            event.getTarget().func_70015_d(3);
        }
    }

    @SubscribeEvent
    public static void entityAttackedEvent(LivingAttackEvent event) {
        PlayerEntity player;
        Item playerItem;
        if (event.getSource().func_76364_f() instanceof PlayerEntity && (playerItem = (player = (PlayerEntity)event.getSource().func_76364_f()).func_184614_ca().func_77973_b()) == SkiesItems.debug_sword && !BlueSkies.SUPPORTERS.isDeveloper(player) && !BlueSkies.IDE) {
            BlueSkies.LOGGER.debug(player.func_200200_C_().func_150261_e() + " tried to use the debug sword.");
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        if (SkiesDimensions.inSkyDimension((Entity)event.getPlayer())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getPlacedBlock();
        PlayerEntity player = (PlayerEntity)event.getEntity();
        boolean inBossRoom = DungeonBalancingChecks.isPlacementInBossRoom(player.field_70170_p, pos);
        if (player.func_184812_l_() || !SkiesPlayerEvents.inBossFight(player) && !inBossRoom && DungeonBalancingChecks.playerCanPlaceInDungeon(player, pos, state.func_177230_c())) {
            return;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent(inBossRoom ? "gui.blue_skies.tooltip.boss_room_denied_interaction" : "gui.blue_skies.tooltip.progression_denied_interaction"), true);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void harvestCheck(PlayerEvent.HarvestCheck event) {
        Block block = event.getTargetBlock().func_177230_c();
        Item item = event.getPlayer().func_184614_ca().func_77973_b();
        if (item != null && SkiesHooks.webHarvestCheck(block, item)) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void destroyBlock(BlockEvent.BreakEvent event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ServerWorld world = (ServerWorld)event.getWorld();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Item item = player.func_184614_ca().func_77973_b();
        if (state.func_177230_c() instanceof SpawnerBlock && EntityUtil.isInDungeon((World)world, pos)) {
            event.setExpToDrop(3);
        }
        if (!player.func_184812_l_()) {
            boolean inBossRoom = DungeonBalancingChecks.isPlacementInBossRoom(player.field_70170_p, pos);
            if (!(state.func_177230_c() instanceof AbstractFireBlock) && (SkiesPlayerEvents.inBossFight(player) || inBossRoom || !DungeonBalancingChecks.playerCanBreakDungeon(player, pos))) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(inBossRoom ? "gui.blue_skies.tooltip.boss_room_denied_interaction" : "gui.blue_skies.tooltip.progression_denied_interaction"), true);
                event.setCanceled(true);
                return;
            }
            if (player.func_234569_d_(state)) {
                if (SkiesItemTags.HORIZONITE_TOOLS.func_230235_a_((Object)item)) {
                    List drops = Block.func_220077_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)player.func_184614_ca());
                    drops.forEach(itemStack -> {
                        ItemStack smeltedStack = SkiesPlayerEvents.getSmeltedResult(itemStack, (World)world.func_201672_e());
                        Block.func_180635_a((World)world.func_201672_e(), (BlockPos)pos, (ItemStack)smeltedStack);
                        if (smeltedStack != itemStack) {
                            PacketHandler.sendToAllClients(new SpawnParticlePacket(0, pos), (World)world.func_201672_e());
                        }
                    });
                    world.func_201672_e().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    return;
                }
                if (item == SkiesItems.ventium_shears) {
                    List drops = Block.func_220077_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)new ItemStack((IItemProvider)Items.field_151097_aZ));
                    drops.forEach(itemStack -> Block.func_180635_a((World)world.func_201672_e(), (BlockPos)pos, (ItemStack)itemStack));
                    world.func_201672_e().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    return;
                }
            }
            if (item != null && !item.getRegistryName().func_110624_b().contains("blue_skies") && item instanceof ToolItem && SkiesDimensions.inSkyDimension((Entity)player) && event.getState().getHarvestLevel() >= 1) {
                event.setCanceled(true);
                world.func_201672_e().func_175656_a(event.getPos(), Blocks.field_150350_a.func_176223_P());
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onBucketFill(FillBucketEvent event) {
        if (EntityUtil.isInDungeon(event.getWorld(), new BlockPos(event.getTarget().func_216347_e()))) {
            event.setCanceled(true);
        }
    }

    public static boolean inBossFight(PlayerEntity player) {
        AxisAlignedBB radiusCheck = new AxisAlignedBB(player.func_233580_cy_()).func_72314_b(25.0, 15.0, 25.0);
        List illagerBossList = player.field_70170_p.func_217357_a(SkiesIllagerBossEntity.class, radiusCheck);
        List bossList = player.field_70170_p.func_217357_a(SkiesBossEntity.class, radiusCheck);
        return !illagerBossList.isEmpty() || !bossList.isEmpty();
    }

    private static ServerPlayerEntity teleportSafely(ServerPlayerEntity player, ServerWorld transferWorld, BlockPos pos) {
        player.func_200619_a(transferWorld, (double)pos.func_177958_n(), 100.0, (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        int maxY = transferWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p());
        player.func_200619_a(transferWorld, (double)pos.func_177958_n(), (double)maxY, (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        return player;
    }

    private static /* synthetic */ ItemStack lambda$getSmeltedResult$8(IInventory iInventory, FurnaceRecipe furnaceRecipe) {
        return furnaceRecipe.func_77572_b(iInventory);
    }

    public static class DungeonBalancingChecks {
        public static final Set<Block> GENERIC_PLACEABLES = ImmutableSet.of((Object)Blocks.field_150478_aa, (Object)Blocks.field_235339_cQ_, (Object)SkiesBlocks.moonstone);
        public static final Set<Block> NATURE_BREAKABLES = ImmutableSet.of((Object)SkiesBlocks.starlit_chest, (Object)SkiesBlocks.cherry_chest, (Object)Blocks.field_150474_ac, (Object)Blocks.field_150478_aa, (Object)Blocks.field_235339_cQ_, (Object)SkiesBlocks.moonstone, (Object[])new Block[0]);
        public static final Set<Block> POISON_BREAKABLES = ImmutableSet.of((Object)SkiesBlocks.maple_chest, (Object)Blocks.field_150474_ac, (Object)Blocks.field_196553_aF, (Object)Blocks.field_150478_aa, (Object)Blocks.field_235339_cQ_, (Object)SkiesBlocks.moonstone, (Object[])new Block[0]);

        public static boolean playerCanPlaceInDungeon(PlayerEntity player, BlockPos pos, Block placingBlock) {
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (DungeonBalancingChecks.isPlacementInBossRoom(player.field_70170_p, pos)) {
                    return false;
                }
                if (skyPlayer.getBrightProgression() < 1 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || skyPlayer.getDawnProgression() < 1 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())) {
                    return placingBlock instanceof BedBlock;
                }
                if (skyPlayer.getBrightProgression() < 2 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.NATURE_DUNGEON.getStructure()) || pos.func_177956_o() < 64 && skyPlayer.getDawnProgression() < 2 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.POISON_DUNGEON.getStructure())) {
                    return placingBlock instanceof BedBlock || GENERIC_PLACEABLES.contains(placingBlock);
                }
                return true;
            });
        }

        public static boolean playerCanBreakDungeon(PlayerEntity player, BlockPos pos) {
            return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                if (DungeonBalancingChecks.isPlacementInBossRoom(player.field_70170_p, pos)) {
                    return false;
                }
                BlockState state = player.field_70170_p.func_180495_p(pos);
                if (skyPlayer.getBrightProgression() < 1 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || skyPlayer.getDawnProgression() < 1 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())) {
                    return state.func_177230_c() instanceof BedBlock;
                }
                if (skyPlayer.getBrightProgression() < 2 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.NATURE_DUNGEON.getStructure())) {
                    return state.func_177230_c() instanceof BedBlock || NATURE_BREAKABLES.contains(state.func_177230_c());
                }
                if (pos.func_177956_o() < 64 && skyPlayer.getDawnProgression() < 2 && EntityUtil.isPosInStructure(player.field_70170_p, pos, SkiesStructures.POISON_DUNGEON.getStructure())) {
                    return state.func_177230_c() instanceof BedBlock || state.func_177230_c() instanceof SkyWebbingBlock && (Boolean)state.func_177229_b((Property)SkyWebbingBlock.HAS_COLLISION) == false || POISON_BREAKABLES.contains(state.func_177230_c());
                }
                return true;
            });
        }

        public static boolean isPlacementInBossRoom(World worldIn, BlockPos pos) {
            if (worldIn instanceof ServerWorld && EntityUtil.isInDungeon(worldIn, pos)) {
                int distance = 45;
                ServerWorld world = (ServerWorld)worldIn;
                PointOfInterestManager poiManager = world.func_217443_B();
                poiManager.func_226347_a_((IWorldReader)world, pos, distance);
                Optional optional = world.func_217443_B().func_226353_b_(poiType -> poiType == SkiesPointsOfInterest.KEYSTONE, pos, distance, PointOfInterestManager.Status.ANY).findFirst();
                if (optional.isPresent() && world.func_175625_s(((PointOfInterest)optional.get()).func_218261_f()) instanceof KeystoneTileEntity) {
                    boolean isInCeilingRange;
                    KeystoneTileEntity keystoneTile = (KeystoneTileEntity)world.func_175625_s(((PointOfInterest)optional.get()).func_218261_f());
                    BlockPos bossRoomCenter = keystoneTile.func_174877_v().func_177971_a((Vector3i)keystoneTile.getSpawnOffset());
                    boolean bl = isInCeilingRange = keystoneTile.getBossRoomCeilingSize() == 0 || pos.func_177956_o() <= bossRoomCenter.func_177956_o() + keystoneTile.getBossRoomCeilingSize();
                    if (isInCeilingRange && pos.func_177956_o() >= bossRoomCenter.func_177956_o() - 1 && GeometryHelper.isPointInsideRec((Vector3i)pos, (Vector3i)new BlockPos(bossRoomCenter.func_177958_n() - keystoneTile.getBossRoomSize(), pos.func_177956_o(), bossRoomCenter.func_177952_p() - keystoneTile.getBossRoomSize()), (Vector3i)new BlockPos(bossRoomCenter.func_177958_n() + keystoneTile.getBossRoomSize(), pos.func_177956_o(), bossRoomCenter.func_177952_p() + keystoneTile.getBossRoomSize()))) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

