/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.interfaces;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.BossItemEntity;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerBossInfo;

public interface ISkyBoss
extends ISkyBossMob {
    public static final Predicate<MobEntity> IS_BOSS = entity -> entity instanceof ISkyBoss;

    default public Predicate<LivingEntity> canAttackPredicate() {
        return entity -> {
            if (entity == this.getBoss() || entity instanceof PlayerEntity && !EntityPredicates.field_188444_d.test(entity) || entity instanceof SupporterPetEntity) {
                return false;
            }
            return !entity.func_190530_aW() && !this.getBoss().func_184191_r((Entity)entity) && entity.func_70089_S() && entity.field_70172_ad <= 0 && EntityPredicates.field_180132_d.test(entity);
        };
    }

    default public Predicate<LivingEntity> canSeeAndAttackPredicate() {
        return entity -> this.getBoss().func_70685_l((Entity)entity) && this.canAttackPredicate().test((LivingEntity)entity);
    }

    public MonsterEntity getBoss();

    public SkiesDungeonType getBossType();

    public int getProgression();

    public boolean isEverbrightBoss();

    public float getHealAmount();

    public double getBossHealth();

    public boolean isBossRespawned();

    default public float getMaxReach() {
        return -1.0f;
    }

    default public int getDamageCap() {
        return 20;
    }

    default public byte getDefaultDifficultyID(Difficulty difficultyIn) {
        return (byte)(difficultyIn == Difficulty.HARD ? 2 : (difficultyIn == Difficulty.NORMAL ? 1 : 0));
    }

    public byte getDifficultyID();

    default public Level getBossDifficulty() {
        return Level.getFromId(this.getDifficultyID());
    }

    default public BlockPos bossSpawnOffset() {
        return BlockPos.field_177992_a;
    }

    public static ITextComponent getDifficultyDecoration(byte diffID) {
        int color = diffID == Level.SILVER.getId() ? 0xB6B6B6 : (diffID == Level.GOLD.getId() ? 14463509 : (diffID == Level.PLATINUM.getId() ? 10336465 : 13467442));
        return new StringTextComponent(" \u2b50").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color)));
    }

    public LootBagItem getLootBag();

    @Nullable
    default public TrophyBlock getTrophy() {
        return null;
    }

    public BlockPos getHome();

    public BossInfo.Color getBossBarColor();

    public boolean isDungeonSpawned();

    default public BossItemEntity dropLootBag(PlayerEntity player) {
        MonsterEntity entity = this.getBoss();
        ItemStack stack = new ItemStack((IItemProvider)this.getLootBag());
        IRarityItem.SkiesRarity rarity = this.getBossDifficulty().getBagRarity(entity.field_70170_p.field_73012_v);
        this.getLootBag().setLootTable(stack, BlueSkies.locate("loot_bags/" + entity.func_200600_R().getRegistryName().func_110623_a() + "/" + (Object)((Object)rarity)));
        this.getLootBag().setRarityTag(stack, rarity);
        if (stack.func_190926_b()) {
            return null;
        }
        if (entity.field_70170_p.field_72995_K) {
            return null;
        }
        BossItemEntity itementity = new BossItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        itementity.setVisiblePlayerId(player.func_110124_au());
        itementity.func_174869_p();
        entity.field_70170_p.func_217376_c((Entity)itementity);
        return itementity;
    }

    default public BossItemEntity dropTrophy(PlayerEntity player) {
        if (this.getTrophy() == null) {
            return null;
        }
        MonsterEntity entity = this.getBoss();
        ItemStack stack = Level.getTier(this.getBossDifficulty()).getItem(this.getTrophy());
        if (stack.func_190926_b()) {
            return null;
        }
        if (entity.field_70170_p.field_72995_K) {
            return null;
        }
        BossItemEntity itementity = new BossItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
        itementity.setVisiblePlayerId(player.func_110124_au());
        itementity.func_174869_p();
        entity.field_70170_p.func_217376_c((Entity)itementity);
        return itementity;
    }

    default public List<PlayerEntity> getAllPlayersInDungeonArea() {
        return this.getPlayersInDungeonArea(15.0, true);
    }

    default public List<PlayerEntity> getPlayersInDungeonArea() {
        return this.getPlayersInDungeonArea(15.0, false);
    }

    default public List<PlayerEntity> getPlayersInDungeonArea(double distance, boolean creative) {
        if (this.getBoss().field_70170_p.field_72995_K) {
            return this.getBoss().field_70170_p.func_175647_a(PlayerEntity.class, this.getBoss().func_174813_aQ().func_186662_g(distance), EntityPredicates.field_188444_d);
        }
        if (!this.getBoss().field_70170_p.field_72995_K && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.getBoss().field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance), creative ? EntityPredicates.field_212545_b.and(EntityPredicates.field_180132_d) : EntityPredicates.field_188444_d);
        }
        return ImmutableList.of();
    }

    default public List<CowEntity> getCowsInDungeonArea(double distance) {
        if (this.getBoss().field_70170_p.field_72995_K) {
            return Lists.newArrayList();
        }
        return this.getBoss().field_70170_p.func_217357_a(CowEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177952_p() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance));
    }

    default public void randomizeAttackTarget(boolean extraChance) {
        List<PlayerEntity> playersInDungeon = this.getPlayersInDungeonArea();
        playersInDungeon.forEach(players -> {
            if (extraChance && players != this.getBoss().func_70638_az() && playersInDungeon.size() > 1 && !players.func_184812_l_() && !players.func_175149_v()) {
                this.getBoss().func_70624_b((LivingEntity)players);
            }
        });
    }

    default public ServerBossInfo getNewBossInfo() {
        return (ServerBossInfo)new ServerBossInfo((ITextComponent)this.getBoss().func_145748_c_().func_230531_f_().func_230529_a_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())), this.getBossBarColor(), BossInfo.Overlay.PROGRESS).func_186741_a(false).func_186742_b(true);
    }

    default public void spawnParticles(IParticleData particleType) {
        if (!this.getBoss().field_70170_p.field_72995_K) {
            return;
        }
        double dx = this.getBoss().field_70170_p.field_73012_v.nextGaussian() * 0.02;
        double dy = this.getBoss().field_70170_p.field_73012_v.nextGaussian() * 0.02;
        double dz = this.getBoss().field_70170_p.field_73012_v.nextGaussian() * 0.02;
        this.getBoss().field_70170_p.func_195594_a(particleType, this.getBoss().func_226277_ct_() + (double)(this.getBoss().field_70170_p.field_73012_v.nextFloat() * this.getBoss().func_213311_cf() * 2.0f) - (double)this.getBoss().func_213311_cf(), this.getBoss().func_226278_cu_() + (double)(this.getBoss().field_70170_p.field_73012_v.nextFloat() * this.getBoss().func_213302_cg()), this.getBoss().func_226281_cx_() + (double)(this.getBoss().field_70170_p.field_73012_v.nextFloat() * this.getBoss().func_213311_cf() * 2.0f) - (double)this.getBoss().func_213311_cf(), dx, dy, dz);
    }

    public ServerBossInfo getBossInfo();

    default public void bossTick() {
        this.getBossInfo().func_186735_a(this.getBoss().func_110143_aJ() / this.getBoss().func_110138_aP());
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
            if (j1 <= 0) {
                this.getBoss().field_70170_p.func_184148_a(null, this.getBoss().func_226277_ct_(), this.getBoss().func_226278_cu_(), this.getBoss().func_226281_cx_(), SkiesSounds.ENTITY_BOSS_SPAWNED, SoundCategory.HOSTILE, 2.0f, 1.0f);
            }
            this.invulnerableTick();
        }
    }

    default public void invulnerableTick() {
    }

    default public void readDefaultBossNBT(CompoundNBT compound) {
        this.setDungeonSpawned(compound.func_74767_n("DungeonSpawned"));
        this.setInvulTime(compound.func_74762_e("Invul"));
        this.setBossRespawned(compound.func_74767_n("BossRespawned"));
        this.setDifficultyID(compound.func_74771_c("DifficultyID"));
        this.getBossInfo().func_186739_a((ITextComponent)this.getBoss().func_145748_c_().func_230531_f_().func_230529_a_(ISkyBoss.getDifficultyDecoration(compound.func_74771_c("DifficultyID"))));
        if (compound.func_74764_b("HomeX") && compound.func_74764_b("HomeY") && compound.func_74764_b("HomeZ")) {
            this.setHome(new BlockPos(compound.func_74769_h("HomeX"), compound.func_74769_h("HomeY"), compound.func_74769_h("HomeZ")));
        }
        if (compound.func_74764_b("BossHomePos")) {
            this.setHome(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BossHomePos")));
        }
    }

    default public void writeDefaultBossNBT(CompoundNBT compound) {
        compound.func_74768_a("Invul", this.getInvulTime());
        compound.func_74757_a("DungeonSpawned", this.isDungeonSpawned());
        compound.func_74757_a("BossRespawned", this.isBossRespawned());
        compound.func_74774_a("DifficultyID", this.getDifficultyID());
        if (this.getHome() != null) {
            compound.func_218657_a("BossHomePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getHome()));
        }
    }

    default public void defaultSpawningRoutine(DifficultyInstance difficultyIn) {
        byte diffId = (byte)(this.getDefaultDifficultyID(difficultyIn.func_203095_a()) + (this.isBossRespawned() ? (byte)1 : 0));
        this.setDifficultyID(diffId);
        this.getBossInfo().func_186739_a((ITextComponent)this.getBoss().func_145748_c_().func_230531_f_().func_230529_a_(ISkyBoss.getDifficultyDecoration(diffId)));
        if (this.getHome() == null || this.getHome() != null && this.getHome().equals((Object)BlockPos.field_177992_a)) {
            this.setHome(this.getBoss().func_233580_cy_());
        }
        this.getBoss().func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getBossHealth());
        this.getBoss().func_70606_j(this.getBoss().func_110138_aP());
        BlueSkies.LOGGER.info("Spawned a(n) " + this.getBoss().func_145748_c_().getString() + " scaled to " + (1 + this.getExtraPlayers()) + " player(s). The difficulty ID is " + (Object)((Object)Level.getFromId(diffId)) + ". The position is " + this.getBoss().func_233580_cy_());
    }

    default public void onBossDeath(DamageSource source) {
        if (!this.getAllPlayersInDungeonArea().isEmpty()) {
            this.getAllPlayersInDungeonArea().forEach(players -> {
                if (this.getBoss().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                    this.dropLootBag((PlayerEntity)players);
                    this.dropTrophy((PlayerEntity)players);
                }
                if (source.func_76346_g() instanceof PlayerEntity && players instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192122_b.func_192211_a((ServerPlayerEntity)players, (Entity)this.getBoss(), source);
                }
                if (!players.func_184812_l_() && !players.func_175149_v()) {
                    if (!this.isBossRespawned()) {
                        players.func_195066_a(SkiesStats.DUNGEONS_CONQUERED);
                    }
                    players.func_195066_a(SkiesStats.BOSSES_DEFEATED);
                }
            });
        }
    }

    default public boolean isSecondPhase() {
        return this.getBoss().func_110143_aJ() <= this.getBoss().func_110138_aP() / 2.0f;
    }

    default public boolean hasAttackTarget() {
        return this.getBoss().func_70638_az() != null;
    }

    default public int getExtraPlayers() {
        return Math.max(0, this.getPlayersInDungeonArea().size() - 1);
    }

    default public boolean isBossInvul() {
        return this.getInvulTime() > 0;
    }

    public void setHome(BlockPos var1);

    public void setDungeonSpawned(boolean var1);

    public void setBossRespawned(boolean var1);

    public int getInvulTime();

    public void setInvulTime(int var1);

    public void setDifficultyID(byte var1);

    default public int lowerCooldown(int cooldown) {
        if (cooldown > 0) {
            --cooldown;
        }
        return cooldown;
    }

    public static enum Level {
        BRONZE(0, 70, 25, 5),
        SILVER(1, 60, 30, 10),
        GOLD(2, 50, 30, 20),
        PLATINUM(3, 0, 60, 40);

        private final int id;
        private final List<IRarityItem.WeightedSkiesRarity> weights = new ArrayList<IRarityItem.WeightedSkiesRarity>();

        private Level(int id, int commonBagChance, int uncommonBagChance, int rareBagChance) {
            this.id = id;
            if (commonBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(commonBagChance, IRarityItem.SkiesRarity.COMMON));
            }
            if (uncommonBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(uncommonBagChance, IRarityItem.SkiesRarity.UNCOMMON));
            }
            if (rareBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(rareBagChance, IRarityItem.SkiesRarity.RARE));
            }
        }

        public IRarityItem.SkiesRarity getBagRarity(Random rand) {
            return ((IRarityItem.WeightedSkiesRarity)WeightedRandom.func_76271_a((Random)rand, this.weights)).getRarity();
        }

        public static Level getFromId(int id) {
            for (Level type : Level.values()) {
                if (id != type.id) continue;
                return type;
            }
            return BRONZE;
        }

        public int getId() {
            return this.id;
        }

        public static TrophyBlock.Tier getTier(Level level) {
            switch (level) {
                case PLATINUM: {
                    return TrophyBlock.Tier.PLATINUM;
                }
                case GOLD: {
                    return TrophyBlock.Tier.GOLD;
                }
                case SILVER: {
                    return TrophyBlock.Tier.SILVER;
                }
            }
            return TrophyBlock.Tier.BRONZE;
        }
    }
}

